#include <ESP8266WiFi.h>
#include <PubSubClient.h>

const char* SSID = "TRAGEDEINESSIDEIN";
const char* PSK = "SUPERSICHERBESTIMMT";
const char* MQTT_BROKER = "IPRASPBERRYHOMEBRIDGE";
unsigned long previousMillis = 61000;
const long intervalon = 1000;
const long intervaloff = 60000;

WiFiClient espClient;
PubSubClient client(espClient);
long lastMsg = 0;
char msg[50];
int value = 0;

void setup() {
  ESP.eraseConfig();
  WiFi.begin("", "");
  pinMode(0, OUTPUT); //Ausgang LED rot (Reserve)
  pinMode(15, OUTPUT); // Ausgang Tueroeffner Relais
  pinMode(16, OUTPUT); //Ausgang LED gruen (Klingelbetaetigt und Bef. oeffnen)
  pinMode(5, OUTPUT); //Ausgang LED gelb (Status)
  pinMode(14, INPUT_PULLUP); //Eingang Klingel (PC817 PIN4)
  Serial.begin(115200);
  setup_wifi();
  client.setServer(MQTT_BROKER, 1883);
  client.setCallback(callback);
}

void setup_wifi() {
  delay(10);
  Serial.println();
  Serial.print("Connecting to ");
  Serial.println(SSID);
  
  WiFi.mode(WIFI_STA);
  WiFi.begin(SSID, PSK);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }

  Serial.println("");
  Serial.println("WiFi connected");
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());
}

void callback(char* topic, byte* payload, unsigned int length) {
  Serial.print("Received message [");
  Serial.print(topic);
  Serial.print("] ");
  char msg[length + 1];
  for (int i = 0; i < length; i++) {
    Serial.print((char)payload[i]);
    msg[i] = (char)payload[i];
  }
  Serial.println();
  msg[length] = '\0';

  Serial.println("Topic:");
  Serial.println(topic);
  Serial.println("Massage:");
  Serial.println(msg);

  if (strcmp(topic, "Haustueroeffnen") == 0) {
    Serial.println("I got an Order!");

    if (strcmp(msg, "gesichert") == 0) {
      Serial.println("I close it for you!");
      digitalWrite(16, LOW);
      digitalWrite(15, LOW);
      delay(2000);
      client.subscribe("Haustuerstatusist");
      digitalWrite(16, LOW);
      digitalWrite(15, LOW);
      client.publish("Haustuerstatusist", "gesichert");
    }
    else if (strcmp(msg, "offen") == 0) {
      Serial.println("I open it for you!");
      digitalWrite(16, HIGH);
      digitalWrite(15, HIGH);
      client.subscribe("Haustuerstatusist");
      client.publish("Haustuerstatusist", "offen");
      delay(3000);
      digitalWrite(16, LOW);
      digitalWrite(15, LOW);
      client.subscribe("Haustuerstatuslaueft");
      client.publish("Haustuerstatuslaueft", "gesichert");
      client.subscribe("Haustuerstatusist");
      client.publish("Haustuerstatusist", "gesichert");
    }
  }

}

void reconnect() {
  while (!client.connected()) {
    Serial.println("Reconnecting MQTT...");
    if (!client.connect("ESP8266Client")) {
      Serial.print("failed, rc=");
      Serial.print(client.state());
      Serial.println(" retrying in 5 seconds");
      delay(5000);
    }
  }
  client.subscribe("Haustueroeffnen");
  Serial.println("MQTT Connected... to:");
  Serial.println("Haustueroeffnen");
}

void loop() {
  if (!client.connected()) {
    reconnect();
  }
  if (digitalRead(14) == LOW) {
    digitalWrite(16, HIGH);
    Serial.println("It ringed for you!");
    client.subscribe("Klingelgedrueckt");
    client.publish("Klingelgedrueckt", "1");
    delay(1000);
    digitalWrite(16, LOW);
    client.publish("Klingelgedrueckt", "0");  
  }
  digitalWrite(0, LOW);
  unsigned long currentMillis = millis(); 
    if (currentMillis - previousMillis >= intervaloff) {
      previousMillis = currentMillis;
      digitalWrite(5, HIGH);
    }
    else if (currentMillis - previousMillis >= intervalon) {
      digitalWrite(5, LOW);
    }
  client.loop();
}
