import { CameraRecordingDelegate } from "../controller";
import { CameraRecordingManagement } from "../definitions";
import { H264CodecParameters, H264Level, H264Profile, Resolution } from "./RTPStreamManagement";
export declare type CameraRecordingConfiguration = {
    mediaContainerConfiguration: MediaContainerConfiguration & {
        prebufferLength: number;
    };
    videoCodec: {
        type: VideoCodecType;
        iFrameInterval: number;
        level: H264Level;
        profile: H264Profile;
        resolution: Resolution;
        bitrate: number;
    };
    audioCodec: AudioRecordingCodec & {
        bitrate: number;
        samplerate: AudioRecordingSamplerate;
    };
};
export declare type CameraRecordingOptions = {
    prebufferLength: number;
    eventTriggerOptions: number;
    mediaContainerConfigurations: MediaContainerConfiguration[];
    video: VideoRecordingOptions;
    audio: AudioRecordingOptions;
    motionService?: boolean;
};
export declare type MediaContainerConfiguration = {
    type: number;
    fragmentLength: number;
};
export declare type VideoRecordingOptions = {
    codec: H264CodecParameters;
    resolutions: Resolution[];
};
export declare type AudioRecordingOptions = {
    codecs: AudioRecordingCodec[];
};
export declare type AudioRecordingCodec = {
    type: AudioRecordingCodecType;
    audioChannels: number;
    bitrateMode: AudioBitrate;
    samplerate: AudioRecordingSamplerate[] | AudioRecordingSamplerate;
};
declare const enum AudioBitrate {
    VARIABLE = 0,
    CONSTANT = 1
}
declare const enum VideoCodecType {
    H264 = 0
}
export declare type AudioRecordingParameters = {
    audioChannels?: number;
    bitrate?: AudioBitrate;
    samplerate: AudioRecordingSamplerate[] | AudioRecordingSamplerate;
};
export declare const enum AudioRecordingCodecType {
    AAC_LC = 0,
    AAC_ELD = 1
}
export declare const enum AudioRecordingSamplerate {
    KHZ_8 = 0,
    KHZ_16 = 1,
    KHZ_24 = 2,
    KHZ_32 = 3,
    KHZ_44_1 = 4,
    KHZ_48 = 5
}
export declare const AudioRecordingSamplerateValues: {
    0: number;
    1: number;
    2: number;
    3: number;
    4: number;
    5: number;
};
export declare class RecordingManagement {
    private delegate;
    private service;
    private selectedConfiguration;
    private readonly supportedCameraRecordingConfiguration;
    private readonly supportedVideoRecordingConfiguration;
    private readonly supportedAudioRecordingConfiguration;
    private static _supportedCameraRecordingConfiguration;
    private static _supportedVideoRecordingConfiguration;
    private _supportedAudioStreamConfiguration;
    constructor(options: CameraRecordingOptions, delegate: CameraRecordingDelegate, service?: CameraRecordingManagement);
    private recordingAudioActive;
    private active;
    private constructService;
    private setupServiceHandlers;
    getSelectedConfiguration(): CameraRecordingConfiguration;
    getService(): CameraRecordingManagement;
}
export {};
//# sourceMappingURL=RecordingManagement.d.ts.map