const http = require('http');
const os   = require('os');
const du   = require('diskusage');
const fs   = require('fs');

const port = 1337
const requestHandler = (request, response) => {
	var out = gatherStats();
	response.writeHead(200, {'Content-Type': 'text/plain'});
	response.end(out + '\n')
}
const server = http.createServer(requestHandler)


function gatherStats() {
	var temp   = fs.readFileSync('/sys/class/thermal/thermal_zone0/temp') / 1000;
	var disk   = du.checkSync('/');
	var values = 
		'{ ' + 
		'"temp": ' + Math.round(temp*10)/10 + ',' +
		'"memory": ' +  
			'{ "total":' + os.totalmem() + ',' +
			'  "free":'  + os.freemem()  + '}' +
			', ' +
		'"disk": ' +  
			'{ "total":' + disk.total + ',' +
			'  "free":'  + disk.free  + '}' +
			', ' +
		'"cpu": ' +  
			'{ "total":'  + os.cpus().length + ',' +
			'  "load1":'  + os.loadavg()[0]    + ',' +
			'  "load5":'  + os.loadavg()[1]    + ',' +
			'  "load15":' + os.loadavg()[2]    + '}' +
			' ' +
		'}';
	return values;
}

server.listen(port, (err) => {
	if (err) {
		return console.log('something bad happened', err)
	}

	console.log('Monitor is listening on Port ' + port)
})


