#!/bin/bash
# set -x
# set -e
#
#
## ============================================================
#                  User Variablen
# in der Datei: /home/UserName/hbridge_install/hbridge.cfg festlegen
## ============================================================
#
# Author: det (@SmartApfel Forum)
# Danke an @Nastra für die Idee zum Verzögerten Start der Dienste und andere Ideen!
#
Version="1.0.67"
#
grep -iq "debug" <<< "${Version}"						# debug version?
is_Debug=$((! $? ))									# "debug" in "$Version" = 1
[ "${is_Debug}" -eq 1 ] && set -x
#
# Mit diesem Script kann man:
#  - Raspberry/Debian System aktualisieren linux Pakete und Firmware
#  - RaspBerry/Debian neu starten
#  - "homebridge" Daten sichern, -entfernen, -neu installieren, updaten, -als Dienst einrichten,
#     Dienste installieren/löschen, -verzögerten start einrichten, deConz installieren/updaten,
#     Kamera am lok. CamPort (RaspBerry) installieren, minimale config Datei erstellen  und die nötigen Plugins installieren.
#     Nach dem Aufruf von "install" sind die Scripte mit ihrem Namen (ohne Pfad angabe) direckt startbar.
#  - sichern/restore von .homebridge/homebridge, hbridge_plugin.inst und Dienste Dateien anlegen,
#  - Benachrichtigung via Telegram möglich
#
#    Beschreibung siehe "/home/UserName/hbridge_imstall/hbridge_new.sh ?"
#
# [plugin]
# Die zu installierenden Plugins, können aus einer Datei (hbridge_plugin.inst)
# eingelesen werden. (Beispiel Datei: hbridge_plugin-example.inst)
#
# [backup]
# Die zu sichernden Dateien/Ordner können aus einer Datei (hbridge_backup.cfg)
# eingelesen werden. (siehe Beispiel Datei: hbridge_backup-example.cfg)
# 
#
## =======================================
## aktuelle (last) Version
## =======================================
max_nodeVersion="13.7.0"							# https://nodejs.org/dist/latest/
max_npmVersion="6.13.6"								# https://github.com/npm/cli
max_hbVersion="0.4.50"								# https://github.com/nfarina/homebridge
max_deCONZVersion="2.05.72"							# http://www.dresden-elektronik.de/rpi/deconz/beta
# http://deconz.dresden-elektronik.de/raspbian/beta
# Raspi alpha Version:http://deconz.dresden-elektronik.de/raspbian/alpha
#max_deCONZVersionDeb="2.05.60"		 				# http://www.dresden-elektronik.de/deconz/ubuntu/beta
# http://deconz.dresden-elektronik.de/ubuntu/beta
max_deCONZVersionDeb="${max_deCONZVersion}"
#
# History:
# 1.0.67 = BugFix ${}, shrink BugFix
# 1.0.66 = Bakup Dateiname wird rotiert von 1 bis $maxSicTag (beta)
# 1.0.66 = -hue -i/-d/-b/-r, install/deinstall/backup/restore HUE-Bridge konfig
# 1.0.65 = Date_Format, final
# 1.0.64 = 0=Name, 1=Name_Date.tar.gz, 2=Date_Name.tar.gz, BugFix, formatDate, Date_Format
# 1.0.63 = Restart_Services="" Instanzen werden gesucht, ="reporter deconz homebridge homebridge-hue" diese Services beenden/starten
# 1.0.62 = deCONZ download Quelle angepasst, BugFixing
# 1.0.61 = reporter.service first stop / last start
# 1.0.60 = "HB_bkp_Deconz_user" eingeführt, für Backup von deConz, Sicherung in /.local/share/dresden-elektronik/deCONZ/deCONZ.tar.gz
#			"HB_bkp_Deconz_ip" IP-Adresse wo der "deconz_service" läuft, default localhost:80
# 1.0.59a = Instanz restart/start/stop von mgtt und deconz* muss seperat erfolgen "hb.. -s restart InstanzName"
# 1.0.59 = seperater restart/start/stop mosquitto.service
# 1.0.58 = fineTuning, BugFixing
# 1.0.57 = BugFix restart Service, Variable "deconz_service" eingeführt, Code cleening
# 1.0.56 = dashboard download git, stop/start/restart deCONZ
# 1.0.55c = install homebridge-lib removed
# 1.0.55 = Anwendung=Homebridge/MM2, include dashboard
# 1.0.54 = de-/install MQTT-Broker (+remove Plugin)
# 1.0.53 = -s -r InstanzName
# 1.0.53 = beim installieren Plugin hue -> homebridge-lib@latest homebridge-hue@latest
# 1.0.52 = -service forked-daapd
# 1.0.51 = BugFix-> pi_clean
# 1.0.50 = BugFix, pi_clean
# 1.0.49 = optional, config-ui-x standalone Instanz
# 1.0.48 = nach node auch npm aktualisieren
# 1.0.47 = incl. npm-check (-npm)
# 1.0.45 = BugFix read a "j/y", Abbruch bei -u
# 1.0.44b = BugFix ","
# 1.0.44a = Parameter: -u npm node # update beides, Funktionen RC
# 1.0.43 = Debian Nodejs 11.x
# 1.0.42 = erweiterung/anpassungen "input_HBServices", deconz -s,
# 1.0.41 = umstellung von "read -nx" auf "inquire $1 $2 $3"
# 1.0.40 = deConz Dienste angepasst
# 1.0.39 = selftest remove, modified in warning
# 1.0.38 = inquire mit $attr
# 1.0.37 = beim erstellen, if exist Instanz eingebaut
# 1.0.36 = "service" und "restart" +InstanzName eingeführt; service status; Kurzbefehle
# 1.0.35 = "service install (-i) InstanzName"
# 1.0.33 = inkl. selftest, BugFix
# 1.0.32 = test auf npm-check eingebunden "npm-check -gu"
# 1.0.31d = Systemlinks angepasst
# 1.0.31c = BugFix "service start/stop", new "service restart"
# 1.0.31b = BugFix tar handling
# 1.0.31a = cleaning debug, cleaning help
# 1.0.31 = Parameter $1 $2, "update npm 6.4.0"
# 1.0.30 = Code cleaning
# 1.0.29b = debug, Version aktualisiert, 
# 1.0.29a = tar, error Auswertung, error Handling
# 1.0.28b = BugFixing, restore komplett, einzelen Datei
# 1.0.28 = send_Telgram umgebaut, BugFix backup
# 1.0.27k = backup telegram
# 1.0.27j = sicherung History, del nodel
# 1.0.27i = BugFix backup mv -2 und service_ctrl, backp_datum.tar.gz
# 1.0.27h = Parameter umbenannt, BugFix backup gz
# 1.0.27g = HB_sic_Device, service_list erweitert
# 1.0.27f = umstellumg restore, sichern "HB_sic_Name" leer -> eingabe Name
# 1.0.27e = einführen Load_Plugin_selective
# 1.0.27d = einführen HB_sic_Pfad=, HB_sic_Name=
# 1.0.27b = ${MYSELF}, function, BugFix logwatch Instanz,
# 1.0.27a = swap list
# 1.0.27 = eingabe -X plugins" in /etc/default/EnvironmentDatei vorbereitet
# 1.0.26 = BugFix'ing
# 1.0.26 = "config" wenn vorhanden = Anzeige der config Datei
# 1.0.25k = logwatch und n Packet installieren, neue cfg Datei, sh angepasst
# 1.0.25j = backup erweitert, von whoami zu $HOME
# 1.0.25h = while-case, pattern, exitCode einbau Einführung, umstellen von pi auf $(whoami)
# 1.0.25f = Script/User prüfung, Code cleaning backup, timesynd dienst angepasst
# 1.0.25d = Fritz Variablen, .sh, trennen deconz Deb- Rasp- Version
# 1.0.25 = deConz beta, create_CtrlService umbauen
# 1.0.24e = Variablen, fritzbox-reboot.sh
# 1.0.24d = Kosmetik
# 1.0.24c = BugFix
# 1.0.24 = Variablen anpassen, $HOSTNAME im Telegram
# 1.0.23 = if telegram remove ln hbridge_new.sh
# 1.0.22 = (sudo apt-get dist-upgrade linux-image-amd64), x86
# 1.0.21 = swap
# 1.0.20 = umstellung auf hbridge.cfg
# 1.0.17 = install pip, ntfy, BugFix
# 1.0.16 = Time-Sync Dienst, timesyncd
# 1.0.15 = BugFix
# 1.0.14 = Backup erweitert, User abfangen, Code cleaning,
# 1.0.13 = journalctl, Telegram
# 1.0.12c = x86 deconz
# 1.0.12 = backup, restore
# 1.0.11 = Distri erkennung verbessert
# 1.0.10beta = update wieder frei für Debian
# 1.0.08 = einfürung Distri "Debian", BugFix backup,
# 1.0.07 = deconz debian und Raspi, BugFix,Code cleaning
# 1.0.06 = service_list
# 1.0.05 = logging, "LOGFILE", echo -e2msg, chown, chmod
# 1.0.04 = release, multi Instanzen
# 1.0.03 = service_remove Service, von sh2bash, echo -e, [restart], [service_remove]
# 1.0.02B = service_remove Service
# 1.0.01B = BugFix, Code cleaning
# 1.0.00B = wait2deconz, deconzdienst, Dienst start/stop umgestellt, homebridge Multi-Instanzen
#          (standard Dienst /etc/systems/system/homebridge.service muss laufen)
## ============================================================
# -- Exit Codes --
# exit 0  = beendet
# exit 1  = beendet, hilfe
# exit 2  = beendet, restart
# exit 3  = Abbruch, CAM einrichten
# exit 4  = beendet, plugin_list
# exit 5  = Abbruch, backup (nichts zum sichern)
# exit 6  = beendet, falsche node Version eigegeben für Debian
# exit 7  = Abbruch mounten Backupmedium
# exit 8  = falsche Distri erkannt
# exit 9  = beendet, service_list
# exit 10 = beendet, Instanze gelöscht
# exit 11 = als falscher User gestartet
# exit 12 = CreateConfig
# exit 13 = beendet, deConz gelöscht
# exit 14 = Abbruch curl installieren
# exit 15 = Abbruch restore
# exit 16 = Abbruch tar
# exit 17 = exit "debug" Info anzeigen
# exit -1 = Abbruch/mit Fehler beendet
#
# #!# = code for cleaning
# #! = code for developer
#
## =======================================
## Variablen
## =======================================
# letzte stabiele Version
stab_nodeVersion="${max_nodeVersion}"
stab_npmVersion="${max_npmVersion}"
stab_hbVersion="${max_hbVersion}"
stab_deCONZVersion="${max_deCONZVersion}"
stab_deCONZVersionDeb="${max_deCONZVersionDeb}"
#stab_hbVersion="0.4.50"
#stab_nodeVersion="11.14.0"
#stab_npmVersion="6.9.0"
#stab_deCONZVersion="2.05.65"
#
## =======================================
## Konstanten
## =======================================
#~⁄
www_deconz_ubuntu="http://deconz.dresden-elektronik.de/ubuntu/beta"
www_deconz_raspian="http://deconz.dresden-elektronik.de/raspbian/beta"
toolDir=$(dirname "$(readlink -e "$0")")
#toolDir="$HOME/hbridge_install"
pluginFile="hbridge_plugin.inst"					# zu installierende Plugins Dateiname
hb_Backup_cfg="hbridge_backup.cfg"					# Backup-config Dateiname
dbgFile="hbridge.dbg"								# Debug-Info Dateiname
helpFile="hbridge.hlp"								# Hilfe Dateiname
HB_del_Sic="1"										# 0= nichts löschen, 1= max. AnzSicherung-1 Sic bleiben auf dem Stick, 2= alle Sicherungen löschen
configFile="hbridge.cfg"							# config Dateiname (RaspBerry)
#Load_Plugin_selective=
PID_dCA=`pidof deconz-gui`  						# X11 autostart ID
PID_dCS=`pidof deCONZ`								# systemd ID
UNAME=`uname -m`									# cpu
hbridge_time="10"  		    						# homebridge 10sec verzögert nach dem start/reboot starten
exitCode=0                  						# Exit-Code
MYSELF=${0##*/}										# ScriptName.sh
MYNAME=${MYSELF%.*}									# ScriptName
PID=`pidof homebridge`								# Prozess ID "homebridge"
[ ! -z "${PID}" ] && Anwendung="Homebridge"			# auf dem Raspi läuft HB
PID_mm2=`pidof sh run-start.sh`               		# Prozess ID "MagicMirror2"
#[ [ ! -z "${PID}_mm2" ] && [ -d ~/MagicMirror ] ] && Anwendung="MM2"				# auf dem Raspi läuft MM2
[ -d $HOME/MagicMirror ] && Anwendung="MM2"			# auf dem Raspi läuft MM2
fkt_mm2="mm2.fkt"									# MagicMirror2 Funktionen
deConzInstMode="manual"								# Installationsmodus deCONZ (manual/apt)
bkp_Filename=""										# = Dateiname inkl. Backupnummer für Sicherung (hue_sic-01)
maxSicTag="30"										# maximale Anzahl der Sicherungen pro Tag
RC=0												# globaler ReturnCode
#CURRENT_DIR=$(pwd)
#
tRot="\033[0;31m"
tGelb="\033[0;33m"
tBlue="\033[0;36m"
tGreen="\033[0;32m"
tFGelb="\033[1;33m"
tFMagenta="\033[1;35m"
tFBlue="\033[1;36m"
tFGreen="\033[1;32m"
tFRot="\033[1;31m"
tFWithe="\033[1;97m"
tNormal='\033[0m'
tFNormal="\033[1;37m"
#
START_deCONZ="sudo systemctl start deconz"
STOP_deCONZ="sudo systemctl stop deconz"
START_deCONZgui="sudo systemctl start deconz-gui"
STOP_deCONZgui="sudo systemctl stop deconz-gui"
#
## ============================================================
# Funktionen
## ============================================================

function msg(){										# $1=message to logging and console, $2=farbattribut
    local text=$1
    local attr=$2
  	local date_string=`date +'%Y-%m-%d %H:%M:%S'`

	echo -e "${attr}${text} \033[0m"
	if [ "${Logfile}" == "journal" ]; then
	  echo "${text}" | systemd-cat -t "homebridge"
	elif [ -n "${Logfile}" ]; then
	  echo -e "${date_string} ${text}" | sudo tee -a ${Logfile} >> /dev/null
	fi
#	 if [ -n "${Logfile}" ] && [ "${Logfile}" != "journal" ]; then echo -e ${date_string} ${text} | sudo tee -a ${Logfile} >> /dev/null; fi
}

function send_Telegram(){							# $1 = message to send
	local a
	
	command -v curl >/dev/null 2>&1 || { msg "[Abbruch] bitte curl installieren!"; exit 14; }
  	if [ "${SendTelegram}" != "1" ] || ( [ "${TChat_ID_raspiBackup}" == "" ] || [ "${TToken_raspiBackup}" == "" ] ); then
    [ "${SendTelegram}" != "1" ] && msg "Benachrichtigung mit Telegram nicht erlaubt" $tRot
    ( [ "${TChat_ID_raspiBackup}" == "" ] || [ "${TToken_raspiBackup}" == "" ] ) &&  msg "Die Variablen \"TToken_raspiBackup\" und \"TChat_ID_raspiBackup\" sind nicht gesetzt !" $tRot
  	else
#	  a=$(curl -s -X POST https://api.telegram.org/bot${TToken_hbridge_new}/sendMessage -d chat_id=${TChat_ID_hbridge_new} -d text="Nachricht von $HOSTNAME: ${1}" 2>&1)
	  a=$(curl -s -X POST "https://api.telegram.org/bot${TToken_hbridge_new}/sendMessage" --data "disable_notification=true" -d chat_id="${TChat_ID_hbridge_new}" -d "parse_mode=html" -d "text=<b>Nachricht von $HOSTNAME:</b>%0A${1}" 2>&1)
      if [[ "${a}" =~ "error" ]]; then
		msg "\n\t Abbruch$tFGelb es trat eine Fehler auf!! " $tFRot
		msg " Error:$tFGelb $a \n$tNormal\t Es wurde keine Nachricht gesendet!\n" $tFGreen
	  else
		if [ "${TelegramAnhang}" != "" ]; then curl -s -X POST  https://api.telegram.org/bot${TToken_hbridge_new}/sendDocument -F chat_id="${TChat_ID_hbridge_new}" -F document=@"${TeleAnhang}" >/dev/null 2>&1; fi
		if [ -n "${TelegramPhoto}" ]; then curl -s -X POST  https://api.telegram.org/bot${TToken_hbridge_new}/sendPhoto -F chat_id="${TChat_ID_hbridge_new}" -F photo="@${TelePhoto}" >/dev/null 2>&1; fi
		if [ -n "${TelegramVideo}" ]; then curl -s -X POST  https://api.telegram.org/bot${TToken_hbridge_new}/sendVideo -F chat_id="${TChat_ID_hbridge_new}" -F video="@${TeleVideo}" >/dev/null 2>&1; fi
	  fi
	fi
}

function neustart (){
	msg "\nDrücke Enter für neustart des ${Distri-System} oder CTRL+C für Abbruch!!\c" $tFRot
	read dummy
	sudo reboot
}

function inquire (){								# waiting for input RC answer
#	local answer									# Return global
  	local finish="-1"
  	local message=$1								# $1= Text für Abfrage 
  	local attr=$2									# $2= Color Attribut
  	local max_input=$3								# $3= Anzahl der Ziffern

  if [ -z ${max_input} ]; then 	
	echo -e -n "${attr}${message} [y/j/n]? \033[0m\c"
	read answer
	while [ "${finish}" = '-1' ]; do
	  finish="1"
	  if [ "${answer}" = '' ]; then
	    answer=""
	  else
	    case ${answer} in
	      y*|Y*|j*|J*) answer="y";;
	      n*|N*) answer="n";;
	      *) finish="-1";
	         echo -e -n 'Eingabe fehlerhaft -- bitte nochmal: \c';
	         read answer;;
	    esac
      fi
  	done
  else
    while [ "${finish}" = '-1' ]; do
      finish=1
      echo -e -n "${attr}${message} [max. ${max_input} Zahlen]? \033[0m\c"
      read -n${max_input} answer 
      echo 
#      [ "${answer}" = '' ] && answer=-
	  if [ ! -z "$(echo ${answer}|tr -d '0-9')" ]; then
 	    echo -e -n "Eingabe darf nur aus den Zeichen 0-9 bestehen (bitte nochmal):\n"
  	    finish=-1
	  fi  
    done
  fi 
}

function HB_Services (){							# homebridge $1=start, stop or restart; $2=ServiceName
	local action=$1									# $1=Action für Service
	local PID_HB=`pidof homebridge`					# PID HB
#	local PID_dCS=`pidof deCONZ`
	local tk="${action}e"							# Text korrektur
	local i											# Servicename homebridge-*.service
	local service_name=$2							# $2=ServiceName
	local found=0									# ServiceName found
	local no_found=0									# 1= Service nicht gefunden
    local Service_Array=( ${Restart_Services[@]} )		# Array mit Servicenamen füllen (Variable vor Parameter $2)
  	
	[ "${action}" == "stop" ] && tk="${action}pe"			# Text korrektur einrichten

    if  [ ! -z "${Service_Array[0]}" ]; then			# nur wenn Arry nicht leer ist
 	  i=0
	  for service_name in ${Service_Array[@]}	;do		# service = Dienst aus Service_Array
	    if [ "${service_name}" = "mosquitto" ]; then
	      msg "${tk} das Programm:$tNormal ${service_name}" $tFGelb
	  	  sudo /etc/init.d/mosquitto $action &
	    else
	  	  msg "${tk} den Dienst:$tNormal ${service_name}" $tFGelb
	      sudo systemctl ${action} ${service_name} &
	    fi
	    sleep 1
	    i=$((i + 1));
	  done
      return 1
    fi
  	if [ "${service_name}" = "" ]; then
	  if [ -n "${PID_HB}" ] && [ "${action}" = "start" ]; then
	    msg "Die Homebridge läuft schon mit der ID:\033[1;33m$PID_HB$tNormal und kann nicht noch einmal gestartet werden!!\n"
	  elif [ -z "${PID_HB}" ] && [ "${action}" = "stop" ]; then
	    msg "Die Homebridge kann nicht gestoppt werden, da sie aktuell nicht läuft!!\n"
	  else
	    [ -e /etc/init.d/mosquitto ] && msg "!! Benutze:$tNormal \"${MYSELF} -s $action mqtt\"$tFGreen um das Programm \"mosquitto\" neu zu startetrn !!" $tRot
#  	    if [ -e /etc/init.d/mosquitto ]; then
#  	      sudo /etc/init.d/mosquitto ${action}
#  	      msg "${tk$tNormal} das Programm:$tFGelb mosquitto$tNormal" $tFGelb
#  	      [ "${tk}" = "starte" ] || [ "${tk}" = "restarte" ] && msg "($tRot ACHTUNG!!$tNormal Nach dem neu starten, die Cam's neu starten. Damit diese sich wieder mit dem Dienst verbinden können!)" $tNormal
#  	    fi
	    [ "${action}" == "stop" ] && [ -e /etc/systemd/system/reporter.service ] && sudo systemctl ${action} reporter.service && msg "${tk} den Dienst:$tNormal reporter.service" $tFGelb
 	    [ -e /etc/systemd/system/multi-user.target.wants/deconz-gui.service ] && [ -L /etc/systemd/system/multi-user.target.wants/deconz-gui.service ] && sudo systemctl ${action} deconz-gui.service && msg "${tk} den Dienst:$tNormal deconz-gui.service" $tFGelb
	    [ -e /etc/systemd/system/multi-user.target.wants/deconz.service ] && [ -L /etc/systemd/system/multi-user.target.wants/deconz.service ] && sudo systemctl ${action} deconz.service && msg "${tk} den Dienst:$tNormal deconz.service" $tFGelb
	    if [ -e /etc/default/homebridge ]; then
	      for i in /etc/systemd/system/homebridge*.service ; do
	        [ ! -f "${i}" ] && continue
	        # Alle Zeichen inkl. dem letzt möglichen "/" werden von Links entfernt.
	        service_name=${i##*/}
  	        msg "${tk} den Dienst:$tNormal ${service_name}" $tFGelb
	        sudo systemctl ${action} ${service_name} & 					# alle homebridge* services stoppen/re-starten
	        sleep 1
	      done
	      [ -e /etc/systemd/system/logwatch.timer ] && sudo systemctl ${action} logwatch.timer && msg "${tk} den Dienst:$tNormal logwatch.timer" $tFGelb
	      [ -e /etc/systemd/system/fritzbox-reboot.timer ] && sudo systemctl ${action} fritzbox-reboot.timer && msg "${tk} den Dienst:$tNormal fritzbox-reboot.timer" $tFGelb
        elif [ -f /etc/init.d/homebridge ]; then
  	      msg "${action}e Homebridge als Programm!" $tFGelb
   	      sudo /etc/init.d/homebridge $action
  	    else
  	      msg "Habe keinen Autostart der Homebridge gefunden!" $tFGreen
  	    fi
	    [[ "${action}" =~ "start" ]] && [ -e /etc/systemd/system/reporter.service ]  && sudo systemctl ${action} reporter.service && msg "${tk} den Dienst:$tNormal reporter.service" $tFGelb			# enthält "start"
  	  fi
  	else
  	  if [ "${service_name}" = "mosquitto" ] || [ "${service_name}" = "mqtt" ]; then
  	    msg "${tk} das Programm:$tNormal ${service_name}" $tFGelb
	    sudo /etc/init.d/mosquitto $action &
	    [ "${tk}" = "starte" ] || [ "${tk}" = "restarte" ] && msg "($tRot ACHTUNG!!$tNormal Nach dem neu starten, die Cam's neu starten. Damit diese sich wieder mit dem Dienst verbinden können!)" $tNormal
  	    return 2
  	  elif [ -e /etc/systemd/system/$service_name ]; then 
  	    found=$service_name
  	  elif [ -e /etc/systemd/system/$service_name.service ]; then 
  	    found=$service_name.service
  	  elif [ -e /etc/systemd/system/homebridge-$service_name.service ]; then
  	    found=homebridge-$service_name.service
  	  elif [ -e /etc/systemd/system/homebridge$service_name.service ]; then
  	    found=homebridge$service_name.service
  	  elif [ -e /etc/systemd/system/multi-user.target.wants/$service_name.service ]; then  	 
  	     found=$service_name.service   
  	  else
		no_found=1
  	  fi 
  	  if [ $found != 0 ]; then 
  	    msg ${tk}" den Dienst:$tNormal \"$found\"" $tFGelb
	    sudo systemctl ${action} ${found} & 							# service stoppen/re-starten
	  else
		no_found=1
  	  fi
  	fi
	[ "${no_found}" = "1" ] && msg "Der Service$tNormal \"...${service_name}.service\"$tFGreen wurde nicht gefunden!" $tFGreen
}

function create_Tools (){
	local isInFile
	local dummy=n
	
	cd $HOME
	[ ! -d "${toolDir}" ] && sudo /bin/mkdir -p ${toolDir} && echo -e "${toolDir} wurde angelegt!"
#	[ ! -O "${toolDir}" ] && sudo chown homebridge:users ${toolDir} && echo -e "${toolDir} Egentümer gesetzt!"   	# test auf Eigentümer und setzen
#defekt	[ ! -w "${toolDir}" ] && sudo chmod 0777 ${toolDir} && echo -e "${toolDir} Rechte gesetzt!"       		# schreibrechte prüfen und setzen
	sudo chmod 0777 ${toolDir} && echo -e "${toolDir} Rechte gesetzt!"       									# Ordner rwx setzen
	sudo chmod -R 0664 ${toolDir}/* 																			# Dateien rw setzen
	sudo chmod 0777 ${toolDir}/files																			# Ordner rwx setzen
	sudo chmod -R 0777 ${toolDir}/*.sh && echo -e "${toolDir}/*.sh Rechte gesetzt!"       						# x setzen für *.sh
	msg "Vorsichtshalber \"ping\" für alle ausführbar machen." $tFGreen
	sudo chmod u+s /bin/ping
	if [ ! -e /etc/ssh/sshd_config.org ]; then
	  isInFile=$(cat /etc/ssh/sshd_config | grep -c "PermitRootLogin yes")
	  if [ "${isInFile}" -eq 0 ]; then
        msg "/etc/ssh/sshd_config wird gesichert und erweitert."
        msg "Für root ssh erlauben."
        sudo cp /etc/ssh/sshd_config /etc/ssh/sshd_config.org
        sudo bash -c "echo PermitRootLogin yes >> /etc/ssh/sshd_config"
	  fi
	else
      msg "User \"root\" darf sich schon per shh anmelden."
	fi
	msg "Erstelle Service-Benutzer und Gruppe homebridge."
	sudo useradd -M --system -U homebridge
# User pi der Gruppe homebridge hinzufügen
	sudo usermod -a -G homebridge pi
	msg "Erlaube systemd-journal für Benutzer homebridge."
	sudo usermod -a -G systemd-journal homebridge
	if [ ! -e /etc/sudoers.d/011_homebridge ]; then
      msg "setze benötigte Rechte für User homebridge."
      sudo cp ${toolDir}/files/011_homebridge /etc/sudoers.d/011_homebridge
      sudo chmod 640 /etc/sudoers.d/011_homebridge
	fi
	msg "Prüfe den Zeitsynchronisierungs-Dienst." $tNormal
	if [ ! -e /etc/systemd/timesyncd.conf.org ]; then
	  if [ -e /usr/sbin/ntpd ]; then
	    msg "Der NTP-Dienst muss entfernt werden." $tNormal
	    sudo apt-get --yes remove --purge ntp
	  fi
	  msg "Zeitsynchronisierungs-Dienst wird eingerichtet." $tNormal
	  sudo mv -f /etc/systemd/timesyncd.conf /etc/systemd/timesyncd.conf.org
	  sudo cp -f ${toolDir}/files/timesyncd.conf /etc/systemd/timesyncd.conf
	  sudo timedatectl set-ntp true
	  sudo systemctl daemon-reload
	  sudo systemctl start systemd-timesyncd
	fi
#	sudo timedatectl status
#	sudo systemctl status systemd-timesyncd
#
	if [ ! -e /var/spool/cron/crontabs/root ] && [ -e ${toolDir}/files/cron_root ]; then
	  msg "Cron Job für root wird kopiert."
	  sudo cp -f ${toolDir}/files/cron_root /var/spool/cron/crontabs/root
	fi
	if [ ! -h /usr/bin/${MYSELF} ] && [ -e $toolDir/${MYSELF} ]; then
	  sudo chmod -R 0766 ${toolDir}/${MYSELF}
	  sudo ln -s ${toolDir}/${MYSELF} /usr/bin/${MYSELF}
	  msg "Systemlink zur Anwendung ${MYSELF} wurde angelegt!"
	elif [ ! -e ${toolDir}/${MYSELF} ]; then
	  msg "Systemlink zur Anwendung ${toolDir}/${MYSELF} wurde entfernt!"
	  sudo rm -rf /usr/bin/${MYSELF}
	else
	  msg "Systemlink zur Anwendung ${MYSELF} existiert bereits!"
	fi
	if [ ! -h /usr/bin/raspiBackup.sh ] && [ -e ${toolDir}/raspiBackup.sh ]; then
	  sudo chmod -R 0766 ${toolDir}/raspiBackup.sh
	  sudo ln -s $t{oolDir}/raspiBackup.sh /usr/bin/raspiBackup.sh
	  msg "Systemlink zur Anwendung ${toolDir}/raspiBackup.sh wurde angelegt!"
	elif [ ! -e ${toolDir}/raspiBackup.sh ]; then
	  msg "Systemlink zur Anwendung ${toolDir}/raspiBackup.sh wurde entfernt!"
	  sudo rm -rf /usr/bin/raspiBackup.sh
	else
	  msg "Systemlink zur Anwendung ${toolDir}/raspiBackup.sh existiert bereits!"
	fi
	if [ ! -h /usr/bin/pishrink.sh ] && [ -e ${toolDir}/pishrink.sh ]; then
	  sudo chmod -R 0766 $toolDir/pishrink.sh
	  sudo ln -s ${toolDir}/pishrink.sh /usr/bin/pishrink.sh
	  msg "Systemlink zur Anwendung ${toolDir}/pishrink.sh wurde angelegt!"
	elif [ ! -e ${toolDir}/pishrink.sh ]; then
	  msg "Systemlink zur Anwendung $toolDir/pishrink.sh wurde entfernt!"
	  sudo rm -rf /usr/bin/pishrink.sh
	fi
	if [ ! -e /usr/local/bin/npm-check ]; then
	  msg "Soll das Tool \"npm-check\" jetzt installiert werden? \033[0;32m[y/j/n]$tGreen (j) \c" $tFGelb
      read -t 5 dummy
      if [[ ${dummy} =~ ^[JjYy]$ ]] || [ "${dummy}" = "" ]; then
	    sudo npm install -g npm-check
	    msg "Benutze:\033[0m \"npm-check -gu\" !" $tFGreen
	  fi
	elif [ -e /usr/local/lib/node_modules/npm-check ]; then
	  msg "Soll das Tool \"npm-check\" jetzt deinstalliert werden? \033[0;32m[y/j/n]$tGreen (n) \c" $tFGelb
      read -t 5 dummy
      if [[ ${dummy} =~ ^[JjYy]$ ]]; then      
	    sudo npm uninstall -g npm-check 
	    msg " \"npm-check\" wurde deinstalliert !!"
	  fi
	fi
	
	if [ -d ${toolDir}/det ]; then
	  msg "Det's Tool-Dir wurde gefunden und wird jetzt eingebunden."
	  sudo chmod 0777 ${toolDir}/det
	  sudo chmod -R 0777 ${toolDir}/det/*.sh && echo -e "${toolDir}/det/*.sh Rechte gesetzt!"
	  if [ ! -e /var/spool/cron/crontabs/$(whoami) ] && [ -e ${toolDir}/files/cron_pi ]; then
	    msg "Cron Job für $(whoami) wird kopiert."
	    cp -f ${toolDir}/files/cron_pi /var/spool/cron/crontabs/$(whoami)
        sudo chmod 0600 /var/spool/cron/crontabs/*
	  fi
	  if [ ! -h /usr/local/bin/WiFi_Check.sh ] && [ -e ${toolDir}/files/WiFi_Check.sh ]; then
	    msg "WiFi_Check für RaspBerry einrichten." $tFGreen
	    msg "Mit$tNormal \"sudo crontab -e\"$tFGelb noch einen Eintrag hinzufügen!" $tFGelb
	    sudo ln -s ${toolDir}/files/WiFi_Check.sh /usr/local/bin/WiFi_Check.sh
#	     sudo cp -f ${toolDir}/files/cron_root /var/spool/cron/crontabs/root
#        sudo chmod 0600 /var/spool/cron/crontabs/*
	  fi

	  msg "\tJetzt werden Det's pers. Tools eingerichtet!!" $tFGreen
      sudo cp -Rf ${toolDir}/det/hbridge.cfg.det ${toolDir}/hbridge.cfg
      msg "\tRichte eigene .bash_aliases ein!!" $tFGelb
	  cp -f ${toolDir}/det/.bash_aliases $HOME/
	  msg "\tmeine hbridge.cfg wieder herstellen.." $tFGelb
	  rm -fr ${toolDir}/hbridge.cfg  >> /dev/null
	  cp -Rf ${toolDir}/det/hbridge.cfg.det ${toolDir}/hbridge.cfg  >> /dev/null
	  # Plugin-Datei verlinken	  
	  [ ! -h ${toolDir}/$pluginFile ] && sudo ln -s ${toolDir}/hbridge_plugin-example.inst ${toolDir}/${pluginFile} && msg "\tPlugin-Datei hbridge_plugin.inst verlinkt.." $tFGelb
	  # Backup-Datei verlinken
	  [ ! -h ${toolDir}/$hb_Backup_cfg ] && sudo ln -s ${toolDir}/hbridge_backup-example.cfg ${toolDir}/$hb_Backup_cfg && msg "\tBackup-Datei hbridge_backup.cfg verlinkt.." $tFGelb	  
	  if [ ! -e /etc/init.d/homebridge ]; then
	    msg "\tcopy homebridge nach /etc/init.d/.." $tFGelb
	    sudo cp -Rf $toolDir/det/homebridge_initd /etc/init.d/homebridge
#	     sudo update-rc.d homebridge defaults		# /etc/.../homebridge aktivieren
	  fi
	  if [  -d $HOME/Desktop ]; then
	    msg "\tDesktopsymbole für X11 festlegen.." $tFGelb
	    cp -Rf ${toolDir}/det/home/pi/Desktop/* $HOME/Desktop/
	  fi
	  if [  -d $HOME/Downloads ]; then
	    msg "\tDownloads werden zurück gespielt.." $tFGelb
	    cp -Rf ${toolDir}/det/home/pi/Downloads/* $HOME/Downloads/
	  fi
	fi
	msg ""
}

function create_ctrlService (){						# CTRL-Services erstellen?
	local service_name=$1							# $1= service-name 
	local service_typ=$2							# $2= service/timer $3=no
	local rc=0										# RC
	local a
	
	if [ "${service_name}" != "" ] || [ "${service_typ}" != "" ]; then
      if [ -e /etc/systemd/system/${service_name}.${service_typ} ]; then
        msg "Der Service \"$service_name.${service_typ}\" existiert bereits, soll er$tFRot gelöscht$tFGelb werden? \033[0;32m[y/j/n]$tGreen (n) \c" $tFGelb
        read a
        if [[ ${a} =~ ^[JjYy]$ ]]; then 
	      msg "lösche den Service:$tNormal $service_name.$service_typ" $tFGelb
	      sudo systemctl disable ${service_name}.${service_typ} >> /dev/null
	      sleep 1
	      sudo rm -fr /etc/systemd/system/${service_name}.${service_typ} >> /dev/null
		  if [ "${service_typ}" = "timer" ]; then sudo rm -fr /etc/systemd/system/${service_name}.service >> /dev/null ; fi
	      sudo rm -fr /etc/default/${service_name} >> /dev/null
	      sudo systemctl daemon-reload
	      msg "Der Service \"${service_name}.${service_typ}\" wurde deaktiviert und entfernt." $tFGelb
          msg "Link \"/usr/local/bin/${service_name}.sh\" wird gelöscht." $tFGelb
          sudo rm -fr /usr/local/bin/${service_name}.sh >> /dev/null
          if [ "${service_name}" = "logwatch" ]; then
          	msg "Soll das Paket ${service_name} und n jetzt entfernt werden? \033[0;32m[y/j/n]$tGreen (n) \c" $tFGelb
          	read a
          	if [[ ${a} =~ ^[JjYy]$ ]]; then 
          	  sudo npm uninstall -g n
	      	  sudo apt-get remove -y ${service_name}
	      	  sudo apt-get purge -y ${service_name}
	      	  sudo apt-get update
	      	  msg "Das Paket ${service_name} und n wurde gelöscht und das System bereinigt!" $tNormal
	      	else
	      	  msg "Das Paket \"${service_name}\" und \"n\" wurde$tFRot NICHT$tNormal gelöscht.\n" $tNormal
	      	fi
	      fi
        else
	      msg "Der Service \"${service_name}.${service_typ}\" wurde$tFRot NICHT$tFGelb gelöscht.\n" $tFGelb
        fi
      else
        if [ -e ${toolDir}/${service_name}.sh ] && [ ! -e /etc/systemd/system/${service_name}.${service_typ} ]; then
          msg "Jetzt kann der$tNormal \"${service_name}.${service_typ}\"$tFGreen Service zur System-Überwachung,\n (Benachrichtigung per Telegram API), angelegt werden!" "$tFGreen"
          if [ ! -e /etc/systemd/system/${service_name}.${service_typ} ]; then
            msg "Jetzt den Service: \"${service_name}.${service_typ}\" anlegen? \033[0;32m[y/j/n]$tGreen (n) \c" $tFGelb
            read a
            if [[ ${a} =~ ^[JjYy]$ ]]; then 
      		  if  [ "${service_name}" = "logwatch" ]; then
  	    		if [ ! -e /usr/sbin/${service_name} ]; then
          		  msg "Das Paket ${service_name} und n wird installiert!"
	      		  sudo apt-get install -y ${service_name}
	      		  sudo npm install -g n
	      		  rc=$?
	    		fi
	    		if [ ! -d "${toolDir}/${service_name}" ]; then
        	      sudo /bin/mkdir -p ${toolDir}/${service_name} >> /dev/null
        	      sudo chmod -R 0777 ${toolDir}/${service_name} >> /dev/null
        	      sudo chown -R $(whoami):users ${toolDir}/${service_name}  >> /dev/null
        	      msg " Ordner \"${toolDir}/${service_name}\" wurde angelegt und\n alle notwendigen Rechte gesetzt!"
        	    else
        	      msg " Ordner \"${toolDir}/${service_name}\" existiert bereits."
        	    fi
      	      fi
	          cd /etc/systemd/system
	          sudo cp ${toolDir}/files/${service_name}.${service_typ} /etc/systemd/system/${service_name}.${service_typ}
		      if [ "${service_typ}" = "timer" ]; then sudo cp ${toolDir}/files/${service_name}.service /etc/systemd/system/${service_name}.service; fi
		      sudo chmod 0755 ${toolDir}/$service_name.sh
	          sudo ln -s ${toolDir}/$service_name.sh /usr/local/bin/${service_name}.sh
#	           sudo cp ${toolDir}/files/$service_name.sh /usr/local/bin/${service_name}.sh
	          sudo systemctl daemon-reload ; rc=$?
	          sudo systemctl enable ${service_name}.${service_typ}
	          sudo systemctl restart ${service_name}.${service_typ}
	          msg "Der Service \"${service_name}.${service_typ}\" wurde erstellt und aktiviert." $tFGelb
	          cd $HOME
            else
	          msg "Der Service \"${service_name}.${service_typ}\" wurde$tFRot NICHT$tFGelb erstellt.\n" $tFGelb
            fi
          fi
        else
          msg "Der Service \"${service_name}.${service_typ}\" konnte$tFRot NICHT$tFGelb angelegt werden, es fehlen Dateien!\n" "$tFGelb"
        fi
      fi
	fi
	return "$rc"
}

function ctrl_Services (){							# Ctrl-Services erstellen?
	create_ctrlService logwatch timer no			# name, dienstart, 
	RC=$?
# 	[ ${RC} != 0 ] && if_error "create_ctrlService" ${RC} -1
    create_ctrlService reporter service no
	RC=$?
# 	[ ${RC} != 0 ] && if_error "create_ctrlService" ${RC} -1    
    create_ctrlService fritzbox-reboot timer no
	RC=$?
# 	[ ${RC} != 0 ] && if_error "create_ctrlService" ${RC} -1    

#    create_ctrlService homebridge service
#	 RC=$?
# 	 [ ${RC} != 0 ] && if_error "create_ctrlService" ${RC} -1
}

function find_entry  (){			
  	local search_answer=$2							# $2 = zu suchender Wert
  	local search=$1									# $1 nur in Zeile mit $1$2 suchen
  	local file										# InstanzName
  	local dummy
  	local rc=0										# RC
	local dd
	
	for file in $(sudo ls /var/homebridge*/config.json); do
  	  dd=$(cat ${file} | grep -c "${search}${search_answer}")
  	  if [ $dd != "0" ]; then 
        file=${file#*/}	
        file=${file#*/}	
        file=${file%/*}	
	    msg "Die Instanz:$tNormal \"${file}\"$tGelb benutzt die Eingabe: ${search}$tNormal${search_answer}!" $tGelb
        msg "Soll die Eingabe$tNormal \"${search_answer}\"$tFGelb genommen werden [y/j/n]$tGreen (n) \c" $tFGelb
        read dummy
        if [ "${dummy}" = "n" ] || [ "${dummy}" = "" ]; then
          rc=1
        fi
#	   sudo systemctl restart ${file}
      fi
	done
	return "$rc"
}

function input_HBServices (){
	local Service_NAME=1							# = while = Beenden
	local service_cfg_Datei="config.json"
	local service_name="$1"							# $1 = ServiceName, "" = Abfrage
	local service_exist=1							# 1= Instanz existiert bereits
	local answer
	local sic_port									# zwichenspeicher Port eingabe
	local rc=0										# RC

	if [ -e /etc/default/homebridge ]; then
	  msg "\nDie Instanz: $tFGreen\"homebridge\"$tFGelb ist bereits eingerichtet, weitere Instanzen als Dienst einrichten!"
	  while [ -n "$Service_NAME" ]; do
	    cd /etc/systemd/system
	    msg "\033[0;33m\nDiese homebridge* Instanzen existieren bereits:$tNormal"
	    sudo find homebridge*.service -exec echo {} \;
	    cd ${toolDir}
	    service_exist=1
		while [ -n "${service_exist}" ]; do
	   	  service_exist=""  
	      if [ "${service_name}" != "" ]; then
	        Service_NAME=${service_name}
	        service_name=""
	      else
	        msg "\nBitte den Namen für eine weitere Instanz eingeben: \033[0;32m(Abbruch mit Enter)$tNormal \n (Eingabe: \"hue\" erstellt die Instanz: \"homebridge-hue\") \c" "\033[1;33m"
	        read  Service_NAME
	        if [ "${Service_NAME}" = "" ]; then
      	      continue												# enter -> beenden
      	    fi
      	  fi
     	  [ -e "/etc/systemd/system/homebridge-${Service_NAME}.service" ] && service_exist=1 && msg "$tRot Abbruch:$tFGelb Die Instanz $tNormal\"homebridge-${Service_NAME}.service\"$tFGelb existiert bereits!"
     	  [ -e "/etc/systemd/system/${Service_NAME}.service" ] && service_exist=1 && msg "$tRot Abbruch:$tFGelb Die Instanz $tNormal\"${Service_NAME}.service\"$tFGelb existiert bereits!"
        done
		[ "${Service_NAME}" = "" ] &&  continue						# enter -> beenden
        inquire "Soll die Instanz:$tNormal homebridge-${Service_NAME}.service$tFGelb jetzt angelegt werden? \033[0;32m(j) $tNormal" $tFGelb
        if [ "$answer" = "n" ]; then
          Service_NAME="1"
          continue													# n -> erneut abfragen
        fi      
        if [ "${Load_Plugin_selective}" = "" ]; then
	      inquire "Sollen die Plugins für diese Instanz selective geladen werden? \033[0;32m(j) $tNormal" $tFGelb
          if [ "${answer}" = "y" -o "${answer}" = "" ]; then
 			Load_Plugin_selective=1
   	    	inquire "Läuft der Config-UI-X in einer eigenen Instanz (standalone)? \033[0;32m(n) $tNormal" $tFGelb
            if [ "${answer}" = "y" ]; then
              sudo cp -f ${toolDir}/files/homebridge-config-ui-x.service.${Distri} /etc/systemd/system/homebridge-config-ui-x-${Service_NAME}.service
              Load_Plugin_selective=2             
            fi
          else
            Load_Plugin_selective=0
          fi
	  	fi 
        sudo cp -f ${toolDir}/files/homebridge /etc/default/homebridge-${Service_NAME}
        sudo cp -f ${toolDir}/files/homebridge.service.${Distri} /etc/systemd/system/homebridge-${Service_NAME}.service
        sudo sed -i 's;HOMEBRIDGE_OPTS=-U /var/homebridge;HOMEBRIDGE_OPTS=-U /var/homebridge-'${Service_NAME}';g' /etc/default/homebridge-${Service_NAME}
        sudo sed -i 's;EnvironmentFile=/etc/default/homebridge;EnvironmentFile=/etc/default/homebridge-'${Service_NAME}';g' /etc/systemd/system/homebridge-${Service_NAME}.service
        sudo sed -i 's;Description=Node.js HomeKit Server;Description=Node.js HomeKit homebridge-'${Service_NAME}';g' /etc/systemd/system/homebridge-${Service_NAME}.service
        msg "Erlaube systemctl Service für homebridge-${Service_NAME}."
        sudo systemctl enable homebridge-${Service_NAME} >> /dev/null ; rc=$?
        if [ "${Load_Plugin_selective}" = "2" ]; then														# Plugin selective und config-ui-x standalone
          sudo cp /etc/systemd/system/homebridge-${Service_NAME}.service /etc/systemd/system/homebridge-config-ui-x-${Service_NAME}.service
          sudo sed -i 's;RestartSec=10;RestartSec=3;g' /etc/systemd/system/homebridge-config-ui-x-${Service_NAME}.service
          sudo sed -i 's;ExecStart=/usr/local/bin/homebridge $HOMEBRIDGE_OPTS;ExecStart=/usr/local/bin/homebridge-config-ui-x $HOMEBRIDGE_OPTS;g' /etc/systemd/system/homebridge-config-ui-x-${Service_NAME}.service
          msg "Erlaube systemctl Service für homebridge-config-ui-x-${Service_NAME}."
          sudo systemctl enable homebridge-config-ui-x-${Service_NAME} >> /dev/null ; rc=$?
        fi
        if [ -e /var/homebridge-${Service_NAME}/config.json ]; then
          msg "Die Datei: /var/homebridge-${Service_NAME}/config.json existiert schon und wird übernommen!" $tFGelb
        else
          msg "Erstellen und Einrichten des Daten-Ordner: /var/homebridge-${Service_NAME}"
          sudo mkdir -p /var/homebridge-${Service_NAME} >> /dev/null
	  	  [ "${Load_Plugin_selective}" = "0" ] && service_cfg_Datei="config.json"	
	  	  [ "${Load_Plugin_selective}" = "1" ] && service_cfg_Datei="config_selective.json"				# Plugin selective laden
	  	  [ "${Load_Plugin_selective}" = "2" ] && service_cfg_Datei="config_selective_standalone.json"	# Plugin selective und config-ui-x standalone
          msg "Eine leere config.json wurde im homebridge Ordner /var/homebridge-${Service_NAME}/ erstellt!" $tFGreen
          sudo cp -f ${toolDir}/files/$service_cfg_Datei /var/homebridge-${Service_NAME}/config.json

#	  	   sudo chown -R homebridge:users /var/homebridge-${Service_NAME}/
#          sudo chmod 0777 /var/homebridge-${Service_NAME}	  	  
#          sudo chmod -R 0666 /var/homebridge-${Service_NAME}/*.*
        fi
    	service_exist=1
 		while [ -n "${service_exist}" ]; do
 		  service_exist=""
          sudo sed -i 's;"name": "Homebridge",;"name": "Homebridge-'${Service_NAME}'",;g' /var/homebridge-${Service_NAME}/config.json
          msg "Jeder Port darf nur einmal benutzt werden, bereits benutzt werden:" $tFGelb
          sudo find /var/ -iname 'config.json' -exec grep -H '"port": ' {} \;
          inquire "Eingabe HomeBridge-Port, (5 Zeichen) eines unbenutzten Port's:$tGreen (51832) \c" $tFGelb 5
          echo ""
          if [ "${answer}" = "" ]; then
            answer="51832"
          fi
          sic_port="${answer}"
		  find_entry  "\"port\": " ${answer}
		  [ ${?} = "1" ] && service_exist=1
		done
        sudo sed -i "s;\"port\"\: 5.*;\"port\"\: ${answer},;" /var/homebridge-${Service_NAME}/config.json        
        msg "\naktueller Eintrag für den HomeBridge-Port ist jetzt:" $tFGelb
        sudo find /var/homebridge-${Service_NAME}/ -iname 'config.json' -exec grep -H '"port": ' {} \;
    	answer2=`echo ${answer:3:5}`								# von answer nur stelle 4 und 5 nehmen
    	service_exist=1
 		while [ -n "${service_exist}" ]; do
 		service_exist=""
          msg "\nJeder Username darf nur einmal benutzt werden, bereits benutzt werden:" $tFGelb
          sudo find /var/ -iname 'config.json' -exec grep -H 'CC:22:' {} \;
		  inquire "Eingabe (2 Zeichen) eines unbenutzten Username'n:$tGreen (${answer2})$tGelb\n(bei Eingabe: ${answer2} wird aus CC:22:3D:E3:CE:30 -> CC:22:3D:E3:CE:${answer2})" $tFGelb 2
          echo ""
          if [ "${answer}" = "" ]; then
            answer="${answer2}"
          fi
    	  find_entry "CC\:22\:3D\:E3\:CE\:" ${answer}
    	  [ ${?} = "1" ] && service_exist=1    	  
    	done 

 	    sudo sed -i "s;\"pin\": \"031-45-1.*;\"pin\": \"031-45-1${answer}\";" /var/homebridge-${Service_NAME}/config.json
        sudo sed -i "s;\"name\"\: \"Homebridge-.*;\"name\"\: \"Homebridge-${Service_NAME}\",;" /var/homebridge-${Service_NAME}/config.json
        sudo sed -i "s;\"username\"\: \"\CC\:22\:.*;\"username\"\: \"CC\:22\:3D\:E3\:CE\:${answer}\",;" /var/homebridge-${Service_NAME}/config.json
		if [ "$Load_Plugin_selective" = "1" ] || [ "$Load_Plugin_selective" = "2" ]; then						# UI-X Interface einrichten
 		  sudo sed -i "s;\"homebridge-people\".*;\"homebridge-${Service_NAME}\";" /var/homebridge-${Service_NAME}/config.json	# selec. PluginName in config
		  msg "Das Config-UI-X Interface wird für Port: ${answer} eingerichtet." $tFGelb
          sudo sed -i "s;\"name\"\: \"Config-UI.*;\"name\"\: \"Config-UI${answer}\",;" /var/homebridge-${Service_NAME}/config.json
          sudo sed -i "s;\"port\"\: 80.*;\"port\"\: 80${answer},;" /var/homebridge-${Service_NAME}/config.json
 		  sudo sed -i "s;\"restart\"\: \"sudo -n systemctl restart homebridge-.*;\"restart\"\: \"sudo -n systemctl restart homebridge-${Service_NAME}\",;" /var/homebridge-${Service_NAME}/config.json
		  sudo sed -i "s;\"service\"\: \"homebridge-.*;\"service\"\: \"homebridge-${Service_NAME}\",;" /var/homebridge-${Service_NAME}/config.json
		  sudo sed -i "s;\"command\"\: \"sudo journalctl -fau homebridge-.*;\"command\"\: \"sudo journalctl -fau homebridge-${Service_NAME}\";" /var/homebridge-${Service_NAME}/config.json
        fi
        msg "\naktueller Eintrag ist jetzt:" $tFGelb
        sudo find /var/homebridge-${Service_NAME}/ -iname 'config.json' -exec grep -H 'CC:22:' {} \;
		sudo find /var/homebridge-${Service_NAME}/ -iname 'config.json' -exec grep -H '"port": ' {} \;
        sudo find /var/homebridge-${Service_NAME}/ -iname 'config.json' -exec grep -H '"pin":' {} \;
		if [ "${Load_Plugin_selective}" = "1" ] || [ "${Load_Plugin_selective}" = "2" ]; then						# UI-Interface einrichten
          sudo find /var/homebridge-${Service_NAME}/ -iname 'config.json' -exec grep -H 'Config-UI' {} \;
          sudo find /var/homebridge-${Service_NAME}/ -iname 'config.json' -exec grep -H '\"port\": 80' {} \;
        fi   
		msg "\nNicht Vergessen!!$tGelb Die \"/var/homebridge-${Service_NAME}/config.json\" muss noch manuell bearbeitet werden, die Plugin-Configuration eintragen!!\n" $tFRot
 		[ "${Load_Plugin_selective}" = "1" ] || [ "${Load_Plugin_selective}" = "2" ] && msg " (und die zu ladenden Plugin's eintragen!!)" $tGelb
		msg "(Benutze: sudo nano /var/homebridge-${Service_NAME}/config.json)" $tGelb
      done
    else
      msg "Es wird homebridge als Instanz eingerichtet!" $tFGreen
      msg "Kopiere Service Dateien ins Dateisystem."
      sudo cp -Rf ${toolDir}/files/homebridge /etc/default/homebridge
      sudo cp -Rf ${toolDir}/files/homebridge.service.${Distri} /etc/systemd/system/homebridge.service
      msg "Service Dateien wurden kopiert."
      msg "Erlaube systemctl Service für homebridge."
      sudo systemctl daemon-reload ; rc=$?
      sudo systemctl enable homebridge ; rc=$?
      if [ ! -e /var/homebridge/config.json ]; then
        if [ "${Load_Plugin_selective}" = "" ]; then
	      inquire "$tFGelb Sollen die Plugins für diese Instanz selective geladen werden? \033[0;32m(j) $tNormal" $tFGelb
          if [ "${answer}" = "y" -o "${answer}" = "" ]; then
            Load_Plugin_selective=1
          fi
		fi
		[ "${Load_Plugin_selective}" = "0" ] && service_cfg_Datei="config.json"				
	  	[ "${Load_Plugin_selective}" = "1" ] && service_cfg_Datei="config_selective.json"				# Plugin selective laden
	  	[ "${Load_Plugin_selective}" = "2" ] && service_cfg_Datei="config_selective_standalone.json"	# Plugin selective und config-ui-x standalone
        sudo mkdir -p /var/homebridge/accessories
        sudo mkdir -p /var/homebridge/persist
        sudo cp -f ${toolDir}/files/${service_cfg_Datei} /var/homebridge/config.json
 #       sudo chown -R homebridge:users /var/homebridge/
 #       sudo chmod -R 0777 /var/homebridge
 #       sudo chmod -R 0666 /var/homebridge/*.*
        msg "Eine leere config.json wurde im homebridge Ordner /var/homebridge/ erstellt!" $tFGreen
		msg "\nNicht Vergessen!!$tGelb Die /var/homebridge/config.json muss noch manuell bearbeitet werden, die Plugin-Configuration eintragen!!\n" $tFRot
 		[ "${Load_Plugin_selective}" = "1" ] && msg " (die zu ladenden Plugin's eintragen!!)" $tGelb
		msg "(Benutze: nano /var/homebridge/config.json)" $tGelb
      else
        msg "Die vorhandene /var/homebridge/config.json wird benutzt!" $tFGreen
        cd /var
        sudo tar cf - ./homebridge | gzip -f9 > "${toolDir}/homebridge.tar.gz"
        rc=$?
        cd $toolDir
        msg "Es wurde ein Sicherung von /var/homebridge/* in ${toolDir}/homebridge.tar.gz erstellt!\n" $tFGelb
      fi
    fi
    msg "...setze Rechte und Eigentümer in \"/var/homebridge*\"" $tFGelb
    sudo chown -R homebridge:users /var/homebridge*
    sudo chmod -R 0777 /var/homebridge*
    sudo chmod -R 0666 /var/homebridge*/*.*
    sudo systemctl daemon-reload ; rc=$?
    cd $HOME	
    return "$rc"
}

function create_ConfigFile (){						# minimal config erstellen
  cat > ${toolDir}/hbridge.cfg << "EOF"
## Begin /home/UserName/hbridge_install/hbridge.cfg

########################################################################################################################
#													Gemeinsame Configdatei											   #
#										   	Begin /home/pi/hbridge_install/hbridge.cfg"								   #
########################################################################################################################


########################################################################################################################
#											   	 		  Allgemein													   #
########################################################################################################################
Distri="" 							# "no"= keine Überprüfung, "Raspbian" für RaspBerri oder "Debian" für x86 System
Logfile="" 							# kein mit loggen, in einer Datei oder journal
SendTelegram="0" 					# 1= über Telegram API benachrichtigen, 0= keine Nachricht senden
Restart_Services=""					# Services die beendet/gestartet werden soll, eintragen "reporter deconz-gui"
#									# "deconz mosquitto" wenn diese Service beendet/gestartet werden soll
Date_Format="Tag"					# Datumformat "Tag"=09122019, "Jahr"=20191209, "Monat"=12092019
Date_SicName="1"					# 0=only Name, 1=Name_(Date_Format), 2=(Date_Format)_Name, Format des Namen der Sicherungsdatei


########################################################################################################################
#											   	 		hbridge_new.sh											       #
########################################################################################################################
hb_ServicesRestart="1" 				# Vorgabe: 1=stoppen/starten, 0=nicht stoppen, aller Dienste
HB_sic_Device=""					# hier das externe Sicherungs-Device eintragen (\"\dev\sda1\", \"\dev\sdc1\" oder \"192.168.6.68:/volume1\")
HB_sic_Pfad=""						# Pfad für Sicherungs-Datei (wenn leer: "$HOME/hbridge_install")
HB_sic_Name=""						# Name der Sicherungsdatei ohne "_Date_Format-01.tar.gz" (wenn leer: "homebridge_Datum-01.tar.gz")
HB_sic_Anzahl="3"					# Anzahl der SicherungsDateien im Sicherungsordner, 2 alte Sicherungen bleiben erhalten +1 (aktuelle Sicherung)
HB_bkp_Deconz_user=""				# Phoscon User für Deconz-Backup (Anmeldung aus config.json \"00212EFFFFFFFFFF\": \"046FFFFFFF\" nur dir Ziffern nach :)
HB_bkp_Deconz_ip=""					# ip Adresse des deconz_service, default localhost:80
Load_Plugin_selective=				# 1= config.json mit "selective Plugin laden" benutzen beim erstellen von Instanzen
TToken_hbridge_new=			    	# Token für Telegram API
TChat_ID_hbridge_new=				# CHAT ID für Telegram bot Chat
TelegramAnhang="" 			        # Datei an Telegram senden
TelegramPhoto=""			        # Photo an Telegram senden
HB_hue_ip=""						# IP-Adresse der Hue, kann aus der Plugin config.json genommen werden
HB_hue_api=""						# API-Key, aus der Plugin config.json von "users" der Teil nach dem : als "ApiKey" speichern
HB_hue_sic_Pfad=""					# Pfad für HUE-Sicherung (wenn leer: "$HOME/hbridge_install")
HB_hue_sic_Name=""					# Name der HUE-Sicherungsdatei , "hue_sic", HB_sic_Pfad/HB_hue_sic_Name-01.json


########################################################################################################################
#											   	 		raspiBackup.sh											   	   #
########################################################################################################################
Boot_Device="" 											# Das Boot-Device eintragen (Achtung ohne Ziffer, "sda", "sdb")
Backup_Device=""										# hier das Sicherungs-Device eintragen (\"\dev\sda1\", \"\dev\sdc1\" oder \"192.168.6.68:/volume1\")
Backup_Pfad=""					    					# Backup Ziel ("" = /mnt/USB_Device) oder z.B. "/home/UserName/hbridge_install" eintragen
Backup_Anzahl="3" 										# 2 alte Backups bleiben erhalten +1 (aktuelle Backup)
Del_Img="1" 											# 0= nichts löschen "nodel", 1= max. AnzBackup-1 Img bleiben auf dem Stick, 2= alle Img löschen "del"
DispSicTime="1"											# Anzeige der Uhrzeit vor und nach der Sicherung/Shrinking 1= an, 0= aus
Run_Batch="0" 											# 1= Batch-Modus an, 0= Batch-Modus aus
image_Name="" 											# Dateiname der Sicherungsdatei vorgeben (das Datum, wird autom. angefügt)
Backup_txt="0"											# 1 = eine Kommentar-Datei zum Backup anlegen (Bestätigung mit Enter notwendig!)
KommentarZeilen="5"										# Anzahl der Zeilen für den Kommentar
Backup_Log=0											# 1= mini Log-Datei zum Backup mit erstellen
TToken_raspiBackup=$TToken_hbridge_new					# Token für Telegram API
TChat_ID_raspiBackup=$TChat_ID_hbridge_new				# CHAT ID für Telegram bot Chat


########################################################################################################################
#											   	 		logwatch.sh												   	   #
########################################################################################################################
TToken_lwatch=$TToken_hbridge_new       				# Telegram API Token, logwatch senden
TChatID_lwatch=$TChat_ID_hbridge_new					# Telegram CHAT ID für "bot Chat", logwatch senden


########################################################################################################################
#											   	 		reporter.sh												   	   #
########################################################################################################################
TToken_reporter=$TToken_hbridge_new						# Telegram API Token, report senden
TChatID_reporter=$TChat_ID_hbridge_new					# Telegram CHAT ID für "bot Chat", report senden


########################################################################################################################
#											   	 		fritzbox-reboot.sh										   	   #
########################################################################################################################
Fritz_User=""											# User-Name zur Anmeldung an der Fritz-Box
Fritz_Passwort=""										# Password zur Anmeldung an der Fritz-Box und Repeater
FritzBox_IP=""											# IP-Adresse der Fritz-Box
FritzRepeater_IP=""										# IP-Adresse der Repeater = "192.168.178.1 192.168.178.2"
TChatID_fritz=$TChat_ID_hbridge_new						# Telegram CHAT ID für "bot Chat", fritzbox senden
TToken_fritz=$TToken_hbridge_new						# Telegram API Token, fritzbox senden


########################################################################################################################
#											   	 		Notiz Timerzeiten										   	   #
########################################################################################################################
#logwatch.timer:										# OnCalendar=Mon-Sun *-*-* 00:00:00
#raspiBackup.timer:										# OnCalendar=Mon-Sun *-*-* 01:00:00
#fritzbox-reboot.timer:									# OnCalendar=Sun *-*-* 02:00:00
#system-reboot.timer:									# OnCalendar=Sun *-*-* 02:30:00


########################################################################################################################
#											   	 		Beispiele												   	   #
########################################################################################################################
# Logfile="journal"			                			# "journal" loggen in /var/log/syslog mit "sudo journalctl -f"
# Logfile="/var/log/hbridge_new.log"	        		# logge alle Ausgaben in dieser Datei mit
# TelegramAnhang="/home/pi/findgrep.sh" 	    		# Datei an Telegram senden
# TelegramPhoto="/home/pi/6.jpg"		        		# Photo an Telegram senden
# Backup_Device="192.168.6.68:/volume1/Backup-HBS"		# Sicherungs-Device
# Backup_Pfad="/home/pi/hbridge_install/Backup-HBS"		# Backup Ziel
# Restart_Services="deconz deconz-gui homebridge"		# diese Services vor dem Backup beenden/starten
# 														# deconz/deconz-gui wenn Service beendet/gestartet werden soll
#

# End /home/UserName/hbridge_install/hbridge.cfg
EOF

msg "\n Es wurde eine neue minimale \"${toolDir}/$configFile\" Datei angelegt,\n" $tFGreen
awk '/\=/ {print}' ${toolDir}/$configFile
msg "\n Jetzt mit $tNormal\"nano ${toolDir}/$configFile\"$tFGelb die gewünschten Variablen setzen!!\n" $tFGelb
msg "Danach \"${MYSELF}\" erneut starten."
exit 12
}

function mount_SicMedium() {						# Sicherungsmedium mounten
	local a
	local rc=0										# RC
	
	if [ "${HB_sic_Device}" != "" ]; then
	  if [[ -n "${HB_sic_Pfad}" ]]; then
	    a=$(sudo grep "${HB_sic_Pfad}" /proc/mounts)
	  fi
      if [ -n "${a}" ]; then
        msg " \"${HB_sic_Pfad}\" ist bereits gemounted." $tFGelb
      else
        if [ ! -e ${HB_sic_Pfad} ]; then
          msg " Mountpoint ${HB_sic_Pfad} für das Sicherungsmedium wird angelegt!" $tFGelb
          sudo mkdir ${HB_sic_Pfad}
          sudo chown -R homebridge:users ${HB_sic_Pfad}
          sudo chmod -R 0777 ${HB_sic_Pfad}
        else
          msg " Der Mountpoint \"${HB_sic_Pfad}\" existiert und wird jetzt benutzt." $tFGelb
        fi 
        sudo mount ${HB_sic_Device} ${HB_sic_Pfad} >> /dev/null
        rc=$?
        if [ ${rc} != 0 ]; then
          msg "$tFRot ABBRUCH!! $tFGelb mounten von ${HB_sic_Device} nach ${HB_sic_Pfad} ist fehlgeschlagen\n" $tFGelb
          if [ "${SendTelegram}" == "1" ]; then  send_Telegram "<b>ABBRUCH!!</b>%0A Das mounten von ${HB_sic_Device} nach ${HB_sic_Pfad} ist fehlgeschlagen." ; fi
          exit 7
        else
          msg " Der MountPoint:\"${HB_sic_Pfad}\" wurde eingebunden!" $tFGelb
        fi
      fi
	fi
	return "$rc"
}

function umount_SicMedium (){						# Sicherungsmedium umounten	
	local rc=0										# RC

 	if [ "${HB_sic_Device}" != "" ]; then
	  msg "Das Sicherungsmedium wird entladen!"
      sudo umount ${HB_sic_Pfad} >> /dev/null
      rc=$?
	  sleep 4
	fi
	return "$rc"
}

function if_error (){								# $1=Programmname, $2=ProgrammErrorCode, $3=ExitCode
	local prog_name=$1
	local prog_error=$2
	
	if [ $# == 3 ]; then
	  msg "Abbruch !! $tFGelb Das Programm: \"${prog_name}\" wurde mit dem Exitcode: \"${prog_error}\" beendet.\n" $tFRot
      if [ "${SendTelegram}" == "1" ]; then  send_Telegram "<b>ABBRUCH!!</b>%0A Das Programm: ${prog_name} wurde mit dem Exitcode: ${prog_error} beendet." ; fi
      [ "${prog_name}" == "tar" ] && [ "${prog_error}" == "2" ] && msg "Hinnweis !!$tFGelb Exitcode 2 bedeutet meist: Datei oder Verzeichnis nicht gefunden" $tFGreen
	  exit $3
	else
	  msg "Ich bin der Funktion: ${FUNCNAME}"
	  msg "Ein Parameter fehlt, Aufruf:$tNormal if_error \"Programmname\" ReturnCode ExitCode" $tFGreen
	  msg "Anzahl der Parameter, die übergeben wurden: $#" $tFGelb
	fi
}

function update_modul (){							# $1 = node/npm, $2 = npm/node/VersionNummer (leer=latest)
	local prog=$1
	local vers=$2
	local inst_npm									# ="npm" wenn auch npm updaten
	local rc=0												# RC
	local modul_path="/usr/local/lib/node_modules/"			# RaspBerry

	[ "${vers}" == "node" ] && [ "${prog}" == "npm" ] && prog=node && inst_npm=npm	&& vers=""
	[ "${vers}" == "npm" ] && vers="" && inst_npm=npm		# wenn $2 = npm
	[ "${vers}" == "node" ] && vers="" && prog=node			# wenn $2 = node
	[ "${vers}" == "" ] && vers=latest						# wenn $2 = ""

    if [ "$p{rog}" == "node" ]; then
      msg " Es wird $tFGelb\"${prog}\"$tNormal auf Version $tFGelb\"${vers}\"$tNormal aktualisiert!" $tNormal
      msg " [letzte stabile Version ist: ${stab_nodeVersion}, installiere jetzt: ${vers}]" $tFGreen
      msg " (bei Abbruch, mit \"$0 -s start\" alle Instanzen starten)" $tFGelb
	  read -t 9 -p " (Abbruch: CTRL+C)"
	  msg "" 
	  echo -e "\033[0m\033[33m\033[5m...Bitte warten! ⏳\033[0m"		# gelb blinkend
#	  sudo npm cache clean -f
	  if [ ! -e /usr/local/bin/n ]; then
	    msg " installiere: n" $tFGreen
        sudo npm install -g n
        rc=$?
      fi
      sudo n ${vers}												# latest
#      sudo npm install -g --unsafe-perm homebridge@latest
	  [ -d /usr/local/lib/node_modules/ ] && modul_path="/usr/local/lib/node_modules/" || modul_path="/usr/lib/node_modules/"
	  cd ${modul_path}
	  msg " starte Rebuild aus ${modul_path}"  $tNormal
 	  sudo npm rebuild --unsafe-perm
 	  rc=$?
 	  if [ "${inst_npm}" != "npm" ]; then
	    inquire "Nach der node Installation sollte auch die aktuelle npm Version installiert werden? \033[0;32m(n) $tNormal" $tFGelb
        [ "${answer}" = "j" ] && inst_npm="npm"
	  fi	  
	fi
	
	[ "${inst_npm}" == "npm" ] && prog="npm"
    if [ "${prog}" == "npm" ]; then
      msg " Es wird $tFGelb\"${prog}\"$tNormal auf Version $tFGelb\"${vers}\"$tNormal aktualisiert!" $tNormal    
      msg " [letzte stabile Version ist: ${stab_npmVersion}, installiere jetzt: ${vers}]" $tFGreen
      msg " (bei Abbruch, mit \"$0 -s start\" alle Instanzen starten)" $tFGelb
	  read -t 9 -p " (Abbruch: CTRL+C)"
	  msg ""
      sudo npm cache clean -f
      sudo npm i npm@${vers} -g
      rc=$?
	fi
	if [ "${prog}" == "node" ] || [ "${prog}" == "npm" ]; then
	  msg "Falls beim starten der Instanzen Fehler auftreten, bitte folgende Befehle ausführen:" $tFGelb
	  msg " \"hbridge_new.sh -s stop\"" $tNormal
	  if [ -d  /usr/local/lib/node_modules ]; then
	    msg " cd /usr/local/lib/node_modules/" $tNormal
	  else
	    msg " cd /usr/lib/node_modules/"  $tNormal
	  fi
	  msg " sudo chown -R \$USER /usr/local && npm rebuild" $tNormal
	  msg " hbridge_new.sh -s start\n" $tNormal
	  msg " ${prog} Version: \c" $tNormal
      $prog -v
      read -p " (Instanzen starten, [j/y/n] (j))" dummy
   	  if [[ ${dummy} =~ ^[JjYy]$ ]] || [ "${dummy}" = "" ]; then    
        HB_Services start
      fi
      exit ${rc}
	fi
	return "$rc"
}

function raspi_clean (){
	local dummy
	local Krnl_Ver=`uname -r`						# akt. Kernel Version
	local Node_Ver=`node -v`						# akt. node Version
	
	Node_Ver=${Node_Ver#*v}							# v von li entfernen
#	if [ "${Anwendung}" = "MM2" ]; then				# wenn exist dann MagicMirror2
	msg "\n\t RaspBerry cleanen\n"  $tFGreen
	df -h
	msg "RaspBerry cleaning starten ? \033[0;32m[y/j/n] ..15sec ->$tGreen (n) $tNormal \c" $tFGelb
	read -t 15 dummy
	if [[ ${dummy} =~ ^[JjYy]$ ]]; then 
	  msg "\n...cleaning" $tNormal
	  sudo apt-get remove --purge wolfram-engine libreoffice* minecraft-pi sonic-pi -y > /dev/null 2>&1
	  sudo apt-get purge --auto-remove scratch > /dev/null 2>&1
	  sudo apt-get clean 
	  sudo apt-get autoremove
	  sudo apt-get autoclean
	  msg "leere Log-Archive, Mail-Ordner.."
	  cd /var
#	  sudo find /var/ -type f -regex '.*\.[0-9]+\.gz$' -delete	> /dev/null 2>&1	# log mit *.gz
#	  sudo find /var/ -type f -regex '.*\.[0-9]+$' -delete	> /dev/null 2>&1		# log mit *.1
	  sudo find /var/ -name '*.gz' -delete > /dev/null 2>&1			# alle *.gz löschen
	  sudo find /var/ -name '*.1' -delete > /dev/null 2>&1			# alle *.1 löschen
	  
	  msg "\033[0mOrdner sortiert nach Grösse:\n (\033[0m\033[33m\033[5m...Bitte warten! ⏳\033[0m)"
	  sudo du -hsx /usr/* | sort -rh | head -10
#	  msg "leere Mail-Ordner.."
#	  sudo rm -f /var/mail/* > /dev/null 2>&1
#	  sudo rm -Rf /tmp/* > /dev/null 2>&1

	  msg "\nDie Datei „/etc/logrotate.d/rsyslog“ wird optimiert."  $tFGelb
	  msg "Im zweiten Abschnitt wird „weekly“ durch „daily“ ersetzt und „rotate“ von „4“ auf „7“ geändert.\n" $tNormal
	  msg "prüfe auf rotate 7" $tFGelb
	  dummy=`grep -rw /etc/logrotate.d/rsyslog -e rotate | fgrep 'rotate' | sed -ne 3p`
	  dummy=${dummy#*r}												# von li alles inkl r löschen
	  if [ "${dummy}" = "otate 4" ]; then
	    msg "rotate wird erhöht auf 7" $tNormal
	    sudo sed -i "s;rotate 4;rotate 7;" /etc/logrotate.d/rsyslog	# tausche rotate 4->rotate 7
	  else
	    msg "rotate ist bereits auf 7" $tNormal
	  fi
	  msg "setze, wenn nötig, weekly auf daily\n" $tFGelb
	  sudo sed -i "s;weekly;daily;" /etc/logrotate.d/rsyslog
	  msg "rsyslog wird nach der Änderung neu gestartet" $tNormal
	  sudo service rsyslog restart
	  if [ "${Distri}" = "Raspbian" ]; then
	  	msg "Nach einer längeren Laufzeit des RasPi, einigen Updates nit \"rpi-update\"\n sowie mehreren \"node\"-Updates, sollte man jetzt mit "j" bestätigen." $tGreen
	    msg "\n\tVORSICHT,$tFGelb es wird an den Systemdateien gearbeitet!!" $tFRot
	    msg " \t (Eine Sicherung der SD-Card ist vorhanden!)"
	    msg "\nWirklich fortfahren? \033[0;32m[y/j/n]$tGreen (n)$tNormal \c" $tFGelb
	    read dummy
	      if [[ ${dummy} =~ ^[JjYy]$ ]]; then 
	      msg "Wenn vorhanden, werden alte Kernel-Versionen gelöscht!\n akt. Kernel: \"${Krnl_Ver}\"$tNormal (wird nicht gelöscht)\n" $tFGelb
# alles in /lib/modules ausser den aktuellen Kernel, alte Node Versionen unter /usr/local/n/versions/node/ ausser der aktuellen
		 [ -d /lib/modules.bak ] && sudo rm -rf /lib/modules.bak/* && msg "bereinige /lib/modules.bak...\n" $tNormal
		  cd /lib/modules/
		  sudo ls /lib/modules/ | grep -v -e "${Krnl_Ver}" | xargs -d '\n' sudo rm -rf --
		  msg "Alte Node.js Versionen werden gelösch!\n akt. Node: \"${Node_Ver}\"$tNormal (wird nicht gelöscht)\n" $tFGelb
		  cd /usr/local/n/versions/node/
		  sudo ls /usr/local/n/versions/node/ | grep -v -e "${Node_Ver}" | xargs -d '\n' sudo rm -rf --
		  msg "bereinige /root/.node-gyp/.." $tNormal
		  sudo sh -c "cd /root/.node-gyp/; ls /root/.node-gyp/ | grep -v -e "${Node_Ver}" | xargs -d '\n' rm -rf --"
		  if [ -d $HOME/.node-gyp ]; then
		    msg "bereinige $HOME/.node-gyp/.." $tNormal
		    cd $HOME/.node-gyp/
		    sudo ls $HOME/.node-gyp/ | grep -v -e "${Node_Ver}" | xargs -d '\n' sudo rm -rf --
		  fi
	    fi
	    msg "ACHTUNG!!\n$tFGelb Wer weis was er macht, kann jetzt manuell Ordner löschen.\n$tNormal(Beenden mit: \"q\")\n\033[0;32m[y/j/n] ..10sec ->$tGreen (n)$tNormal" $tFRot
	    read -t 10 dummy
	    if [[ ${dummy} =~ ^[JjYy]$ ]]; then 	  	
	      sudo ncdu -x /
	    fi
	  fi
	  cd $HOME
	  df -h
	  msg "\nRaspberry cleanen ist fertig!!\n" $tFGelb
	else
	  msg "RaspBerry cleaning abgebrochen!" $tFGelb
	fi
}

function Mqtt_Broker  (){							# de-/installiere MQTT-Broker für camera-ui Plugin
	if [ -e /etc/init.d/mosquitto ]; then
	  msg "Der \"MQTT-Broker\" für u.a.$tNormal \"homebridge-camera-ui\"$tFGreen Plugin ist bereits installiert." $tFGreen
	  msg "Soll der  \"MQTT-Broker\" jetzt deinstalliert werden? \033[0;32m[y/j/n]$tGreen (n) \c" $tFGelb
	  read dummy
	  if [[ ${dummy} =~ ^[jJYy]$ ]]; then
	    sudo /etc/init.d/mosquitto stop
	    sudo apt-get remove --purge -y mosquitto mosquitto-clients > /dev/null 2>&1
	    msg "Der \"MQTT-Broker\" wurde entfernt." $tFGelb
	  else
	    msg "Der \"MQTT-Broker\" wurde$tFRot NICHT$tFGreen gelöscht." $tFGreen
	  fi
	else
	  msg "Installiere den \"MQTT-Broker\" für das \"homebridge-camera-ui\" Plugin!" $tFGreen
	  sudo apt-get update
	  sudo apt-get install mosquitto mosquitto-clients -y
	  sudo /etc/init.d/mosquitto restart
	fi
}

function inst_AirPlay  (){							# erstinstallation AirPlay Lautsprecher
	local dummy
	
	msg " Erst Installation AirPlay Lautsprecher ins HomeKit einbinden!" $tFGreen
	msg "installiere.. forked-daapd is an \"iTunes\" music server for Linux" $tGelb
	msg "It can:\n
 -be controlled by remotes like Apple Remote on iOS, Retune/TunesRemote+ on Android or Remote for WP on Windows Phone\n
 -be controlled by any MPD client\n
 -play your music via AirPlay, via Chromecast, as an mp3 stream or locally on the RPi\n
 -stream audio and some video to iTunes\n
 -has support for audio files in most formats, internet radio and Spotify" $tNormal

	# https://www.raspberrypi.org/forums/viewtopic.php?t=49928
	cd $HOME
	echo -e "Add repository key"
	wget http://www.gyfgafguf.dk/raspbian/forked-daapd.gpg $HOME/forked-daapd.gpg
	cat ./forked-daapd.gpg  | sudo apt-key add -
	rm -f ./forked-daapd.gpg
	apt-key list
	read -p "wait..-> (Enter)"
	echo -e "Add this line to /etc/apt/sources.list:\ndeb http://www.gyfgafguf.dk/raspbian/forked-daapd/ stretch contrib\n(if you use Jessie, then replace \"stretch\" with \"jessie\" - note Jessie version has no web interface)\nRun "
	read -p "wait..-> (Enter)"
	sudo nano /etc/apt/sources.list
	read -p "wait..-> (Enter)"
	sudo apt update
#	[ -e = /lib/systemd/system/forked-daapd.service ] (/usr/sbin/forked-daapd)
	msg "Soll \"forked-daapd\" (i)nstalliert oder (r)emoved werden?$tGreen (i/r)" $tFGreen
	[ -e = /etc/forked-daapd.conf ] && msg "\"forked-daapd\" Config ist bereits eingerichtet!!" $tFGelb
	[ -e = /lib/systemd/system/forked-daapd.service ] && msg "\"forked-daapd\" Dienst ist bereits installiert!!" $tFGelb
	read dummy
	if [[ ${dummy} =~ ^[iI]$ ]]; then n
	  sudo apt install forked-daapd
	  mkdir /srv/music/Podcasts
	  mkdir /srv/music/Compilations
	  mkdir /srv/music/Audiobooks
	  cp -f $HOME/hbridge_install/files/sender.m3u /srv/music/sender.m3u
	  sudo cp -f $HOME/hbridge_install/files/forked-daapd.conf /etc/forked-daapd.conf
	  sudo systemctl daemon-reload
	  sudo systemctl enable forked-daapd
	  sudo systemctl restart forked-daapd
	elif [[ ${dummy} =~ ^[rR]$ ]]; then
	  sudo systemctl disable forked-daapd
	  sudo systemctl daemon-reload
	  sudo apt remove forked-daapd
	  sudo apt purge forked-daapd
	  sudo rm -fr /srv/music/* >> /dev/null
	  sudo rm -f /etc/forked-daapd.conf >> /dev/null
	  sudo rm -fr /var/cache/forked-daapd >> /dev/null
	fi

	echo -e "Edit the configuration file (usually /etc/forked-daapd.conf) to suit your needs\n
 Start or restart the server:\n
 sudo service forked-daapd restart\n
 Wait for the library scan to complete. You can follow the progress with\n
 tail -f /var/log/forked-daapd.log\n
 If you are going to use a remote app, pair it by going to http://forked-daapd.local:3689/ \n(username is admin, password is set in the config file)" $tNormal
	read -p "wait..-> (Enter)"
	sudo nano /etc/forked-daapd.conf
	sudo service forked-daapd restart
	tail -f /var/log/forked-daapd.log

	# http://ejurgensen.github.io/forked-daapd/
	# npm homebridge-http-multiswitch
	msg "Das Plugin \"homebridge-cmdswitch2\" noch installieren!"
	sudo npm install -g homebridge-cmdswitch2
}

function parameter_check (){										# Parameter in array speichern (bash)
	RunParamArray=( $# $* )											# sichert Anzahl und alle Parameter im array
	pattern="${RunParamArray[1]}"									# Parameter1 laden für while
	local rc=0														# RC
	local i
		
#	P=`expr ${RunParamArray[0]} - 1`								# Parameteranzahl von [0]-1
# 	msg "Anzahl der Elemente= "${#RunParamArray[*]}					# Anzahl der Elemente im array
# 	msg "Anzahl der Parameter= "${RunParamArray[0]}					# Anzahl der Parameter im array
#	echo "RunParamArray alle Elemente= "${RunParamArray[@]}			# komplettes array
# 	msg "Länge von Element3= "${#RunParamArray[3]}					# länge vom Parameter3
 	i=1
 	while [ ${i} -lt ${#RunParamArray[*]} ]; do						# solange kleiner Anzahl der Parameter +1
	 if [[ ${RunParamArray[${i}]} = -* ]]; then						# nur wen 1.te Zeichen ein "-" ist
      RunParamArray[${i}]=${RunParamArray[${i}]#*-}					# bei "-l" das "-" abschneiden
      case "${RunParamArray[${i}]}" in
        u) RunParamArray[${i}]=update;;								# "update"
        r) RunParamArray[${i}]=remove;;								# "remove"
        i) RunParamArray[${i}]=install;;							# "install"
        p) RunParamArray[${i}]=plugin;;								# "plugin"
        s) RunParamArray[${i}]=service;;							# "service"
        d) RunParamArray[${i}]=deconz;;								# "deconz"
        wd) RunParamArray[${i}]=wait2deconz;;						# "wait2deconz"
        l) RunParamArray[${i}]=list;;								# "list"      
        c) RunParamArray[${i}]=ctrl;;								# "ctrl"
#        pak) RunParamArray[2]=paket;;								# "update_paket"
        *) pattern=? && msg " ERROR:$tGreen Parameter \"${RunParamArray[2]}\" ist unbekannt!!" $tRot;;
      esac
	fi
	  i=`expr $i + 1`												# i=i+1
	done
#echo "RunParamArray alle Elemente= "${RunParamArray[@]}			# komplettes array
	[[ ${pattern} = "?"* ]] && pattern=? && rc=1						# wenn pattern mit ?_ anfängt
#	pattern="${RunParamArray[1]}"									# = pattern_RunParamArray[1]
	pattern="${RunParamArray[@]:1:${RunParamArray[0]}}"				# = pattern_RunParamArray[@]
		
#	[ $? != 0 ] && msg " Fehler: \"$?\" ist aufgetreten!!" $tRot && exit $?
#	unset RunParamArray												# array löschen
#	unset RunParamArray[2]											# Parameter2 im array löschen
	msg "pattern=$pattern"
	msg "RC=$rc"
 	return "$rc"
}

function rotiere_bkp_file (){										# rotieren der Backup Datei max. 30/Tag
	local pfad=$1													# Pfad zur Sicherungsdatei
	local ext=$3													# Name der Sicherungsdatei											
	local bkp_file=$2												# erweiterung der Sicherungsdatei
	local lastname													# letzte gefundene Datei
	local name														# sichern Dateiname ohne Backupnummer
	local backupnr													# gef. BackupNr. -> +1 (30->1)
	local rc=0
	
#	echo -e $bkp_file
	if [ -e "${pfad}/${bkp_file}.${ext}" ]; then
	  set -- ${pfad}/*-??.${ext}
	  lastname=${!#}												# letzte gefundene Datei
	  name=${lastname%%-*}	
	  name=${name##*/}												# sichern Dateiname
	  backupnr=${lastname##*-}
	  backupnr=${backupnr%%.*}
	  backupnr=${backupnr//\?/0}
	  backupnr=$[10#${backupnr}]									# letzte gef. BackupNr.
	  [ ${backupnr} = "0" ] && echo "Keine \"*.${ext}\" Datei gefunden." && continue 2	# wen keine gef. exit

#	  [ ${Date_SicName} = "2" ] && name="${formatDate}_${name}"
#	  [ ${Date_SicName} = "1" ] && name="${name}_${formatDate}"
#	  [ ${Date_SicName} != "1" ] && [ ${Date_SicName} != "2" ] && name="${name}"
#	echo -e $name
	
	  if [ "$[backupnr++]" -ge "${maxSicTag}" ]; then				# Backupdateinummer automatisch um +1 bis maximal 30 erhoehen
	    backupnr=1													# bei 30 wieder auf 1
	  fi
	  backupnr=000${backupnr}
	  backupnr=${backupnr: -2}										# letzte 2 stellige Backupnummer
	  bkp_Filename="${name}-${backupnr}"							# return Dateiname
	else
	  bkp_Filename="${bkp_file}"									# return, keine rotation
	fi
	return "$rc"
}

function hue_config (){												# sichern der HUE Konfiguration
	local action=$1													# backup/restore/warn/test
	local rc=0														# RC 0=iO, 1=no Variable, 2=no Plugin

	if [ -e ${toolDir}/hue_backup_restore ]; then
	  [ "${action}" = "restore" ] || [ "${action}" = "backup" ] && [ "${HB_hue_sic_Name}" = "hue_sic" ] && msg "\"HB_hue_sic_Name\"$tNormal wurde auf$tGelb \"hue_sic.json\"$tNormal gesetzt." $tGelb
	  [ "${HB_hue_api}" == "" ] || [ "${HB_hue_ip}" == "" ] && msg "ACHTUNG!!$tNormal Bitte erst die benötigten Daten in der $tGelb\"$hb_Backup_cfg\"$tNormal eintragen!\n$tGelb HB_hue_ip=\"\"$tNormal und/oder$tGelb HB_hue_api=\"\"$tNormal sind leer." $tFRot && rc=1
	  cd ${toolDir}
	  mount_SicMedium ${HB_hue_sic_Pfad}
	  RC=$?
	  [ ${RC} != 0 ] && if_error "mount_SicMedium" ${RC} -1
	  if [ "${action}" = "backup" ]; then
	    rotiere_bkp_file  ${HB_hue_sic_Pfad} ${HB_hue_sic_Name} json
	    HB_hue_sic_Name=${bkp_Filename}
	    msg "\033[33m\033[5m...Bitte warten! ⏳\033[0m"
        sudo python ./hue_backup_restore/hue_br.py -b ${HB_hue_sic_Pfad}/${HB_hue_sic_Name}.json ${HB_hue_ip} ${HB_hue_api}
	  elif [ "${action}" = "restore" ]; then
	    msg "\033[0;33m\nDiese Sicherungs-Dateien wurden gefunden:$tNormal"
	    sudo find ${HB_hue_sic_Pfad}/*.json -exec echo {} \; | more
	    msg "\nBitte den Namen der Sicherungs-Datei für das Restore eingeben ! \n(Name ohne .json)" "\033[1;33m" 
#	    [ ${Date_SicName} = "2" ] && msg "\033[0;32m(Enter = ${formatDate}_${HB_hue_sic_Name}.json)$tNormal" "\033[1;33m" && dummy1="${formatDate}_${HB_hue_sic_Name}"
#	    [ ${Date_SicName} = "1" ] && msg "\033[0;32m(Enter = ${HB_hue_sic_Name}_${formatDate}.json)$tNormal" "\033[1;33m" && dummy1="${HB_hue_sic_Name}_${formatDate}"
#	    [ ${Date_SicName} != "1" ] && [ ${Date_SicName} != "2" ] && msg "\033[0;32m(Enter = ${HB_hue_sic_Name}.json)$tNormal" "\033[1;33m" && dummy1="${HB_hue_sic_Name}"
		msg "\033[0;32m(Enter = ${HB_hue_sic_Name}.json)$tNormal" "\033[1;33m"
#		 && dummy1="${HB_hue_sic_Name}"
	    read  -t 20 dummy 
	    [ "${dummy}" = "" ] && dummy=${HB_hue_sic_Name}
  	    if [ -e ${HB_sic_Pfad}/${dummy}.json ]; then
	      msg "\033[33m\033[5m ...Bitte warten! ⏳\033[0m"
	      sudo python ./hue_backup_restore/hue_br.py -r ${HB_hue_sic_Pfad}/${dummy}.json ${HB_hue_ip} ${HB_hue_api}
	      msg "Die HUE-Einstellungen wurden aus der Datei:$tGelb \"${HB_hue_sic_Pfad}/${dummy}.json\"$tFGreen wieder hergestellt!" $tFGreen	    
	    else
	      msg "Ich konnte die Datei:$tGelb \"${HB_hue_sic_Pfad}/${dummy}.json\"$tFGreen nicht finden!" $tFGreen
	    fi
	  fi 
	  cd $HOME
	  umount_SicMedium ${HB_hue_sic_Pfad}
	  RC=$?
	  [ ${RC} != 0 ] && if_error "umount_SicMedium" ${RC} -1
	elif [ "${action}" = "warn" ]; then
	  msg "Hinnweis!!$tNormal\n Das Tool wird von:$tGelb \"https://github.com/schreter/hue_backup_restore\"$tNormal runter geladen," $tFRot
	  msg " dazu muss der Raspi eine Inernet verbindung haben.\n Dort kann alles weitere nachgelesen werden." $tNormal
	  msg " Die Benutzung geschieht auf eigene Gefahr, ich selber habe die Option$tGelb restore$tNormal nicht getestet." $tNormal
	  msg " Folgende Variablen müssen in der$tGelb \"${hb_Backup_cfg}\"$tNormal gesetzt werden." $tNormal
	  msg " HB_hue_sic_Pfad=\"\"$tNormal\t\t # Pfad für Sicherungsdatei (wenn leer: \"$HOME/hbridge_install\")" $tGelb
	  msg " HB_hue_sic_Name=\"\"$tNormal\t\t # Name der Sicherungsdatei (wenn leer: \"hue_sic\") \"-01.json\" wird autom. angefügt" $tGelb
	  msg " HB_hue_ip=\"\"$tNormal\t\t\t # IP-Adresse der Hue-Bridge, kann aus der Plugin config.json entnommen werden" $tGelb
	  msg " HB_hue_api=\"\"$tNormal\t\t\t	# API-Key, aus der Plugin config.json von $tGelb\"users\": {\"UserID\":\"ApiKey\"}\n\t\t\t\t$tNormal # den Teil nach dem : als$tGelb \"ApiKey\"$tNormal eintragen." $tGelb
	  read -t 15 -p " ...15sec (=Enter, Abbruch CTRL+C)"
	  echo ""
	else
	  rc=2															# keinTool installiert
	fi
 	return "$rc"
}

## ========================================================================================================================
######################################
#########    Mainprogramm     ########
######################################
## ========================================================================================================================

# -- auf Tools-Ordner prüfen --
#[ "$(whoami)" == 'root' ] || [ ! -e "${toolDir}/${MYSELF}" ] && ( msg "\nDas Script nicht als User $tFRot\"root\"$tFGreen starten,\n bzw. existiert $tFGelb\"${toolDir}/${MYSELF}\"$tFGreen nicht!\n" $tFGreen) && exit 11
[ ! -e "${toolDir}/${MYSELF}" ] && ( msg "\n ABBRUCH!$tFGreen\n Es existiert kein Tool-Ordner $tFGelb\"${toolDir}/\"$tFGreen\n bitte die Tools neu installieren!\n" $tFRot) && exit 11
if [ -f ${toolDir}/${MYSELF} ]; then
  [ ! -h /usr/bin/${MYSELF} ] && sudo ln -s ${toolDir}/${MYSELF} /usr/bin/${MYSELF} && msg "System-Link zu ${toolDir}/${MYSELF} wurde erstellt."
fi

# test ob hlp  Datei vorhanden ist
#hlp_intern=1
#[ -f "${toolDir}/$helpFile" ] && hlp_intern=0 && . ${toolDir}/$helpFile && msg "Die Hilfedatei \"$helpFile\" wurde eingelesen!" $tFRGelb

# -- test auf MagicMirror2 --
#PID_mm2=123
if [ ! -z "${PID_mm2}" ] && [ -d ~/MagicMirror ]; then
#	if [ "${Anwendung}" = "MM2" ]; then								# wenn exist dann MagicMirror2
	Version="$Version (${Anwendung})"
    . ${toolDir}/$fkt_mm2
    # mm2_install
    # mm2_update_js
    # mm2_switch_remote
    # mm2_start
    # mm2_stop
    # mm2_restart
    # mm2_list
    # mm2_save
    # exit
else
#	Anwendung="Homebridge"
    PID_mm2=
fi
#[ ! -z "${PID_mm2}" ] && mm2_restart && continue 2    
[ ! -z "${PID_mm2}" ] &&  msg "${hlp_mm2}" $tNormal && read -t 15 -p "weiter mit Enter (15sec)..."

cd $toolDir
clear
msg "\n\t\033[4;36mEs wird das Script: ${MYSELF} in der Version: ${Version} benutzt !!$tNormal\n\t\t\033[0;32m (die Angaben in () werden mit Enter übernommen)$tNormal"

[ ! -z "${PID_mm2}" ] && msg "\t\t\t (MagicMirror2 wurden geladen)$tNormal" $tGreen

# -- selftest, ob Script schon läuft --
#[ "$(pidof -x "$0")" != $$ ] && (msg "$tFRot ABBRUCH! $tNormal$0$tFGelb läuft bereits, \n$tFGreen Bitte erst beenden !\n") && exit 222
[ "$(pidof -x "$0")" != $$ ] && (msg "$tFRot ACHTUNG! $tNormal$0$tFGelb läuft bereits!\n") 

# -- test auf config Datei -> erstellen --
if [ -f ${toolDir}/$configFile ]; then
  . ${toolDir}/$configFile
else
  create_ConfigFile
fi
[ "${HB_hue_sic_Name}"  = "" ] && HB_hue_sic_Name="hue_sic-01" || HB_hue_sic_Name="${HB_hue_sic_Name}-01"
[ "${HB_hue_sic_Pfad}" = "" ] && HB_hue_sic_Pfad="${toolDir}"
[ "${HB_sic_Pfad}" = "" ] && HB_sic_Pfad="${toolDir}"
[ -z ${Date_Format+x} ] && Date_Format="%d%m%Y" 					# wenn Variable nicht existiert -> setzen 
if [[ ${Date_Format} =~ ^[mM](onat)* ]]; then						# fängt mit [mM] an -> Monat
 Date_Format="%m%d%Y"
elif [[ ${Date_Format} =~ ^[jJ](ahr)* ]]; then						# fängt mit [jJ] an ->  Jahr
 Date_Format="%Y%m%d"
else																# rest Tag
 Date_Format="%d%m%Y"
fi
#[[ ${Date_Format} =~ ^[jJyY]$ ]] && Date_Format="%Y%m%d" || Date_Format="%d%m%Y" # fängt mit [jJyY] an -> Jahr/Monat/Tag sonst Tag/Maonat/Jahr setzen
formatDate=$(date +${Date_Format})									# internes Datumsformat 

# -- auf Distri prüfen --
[ "${Distri}" == "no" ] && flag=1
if [ "${Distri}" == "" ] || [ "${Distri}" != "{Debian}" -a "${Distri}" != "Raspbian" ]; then
  Distri=`lsb_release -s -i`
  if [ "${Distri}" != "Raspbian" -a "${Distri}" != "Debian" ]; then
    msg "Distributor = ${Distri} !" $tFGelb
    if [ "${flag}" != "1" ]; then
      msg "\n Abbruch:$tFGelb Dieses System wird derzeit nicht supportet, nur Raspbian und Debian!!\n" $tFRot
      msg " (evtl. \"Distri\" manuell setzen)" $tNormal
      exit 8
    fi
  fi
fi

# -- logging anzeigen --
if [ -n "${Logfile}" ]; then msg " (logge in \"${Logfile}\" mit)" "\t\t"; fi
msg ""

#parameter_check $*
#RC=$?
#msg "select exit code= $RC"
#[ ${RC} != 0 ] && if_error "parameter_check" ${RC} -1

#---------------------------------
if [ "${hb_ServicesRestart}" != "0" ]; then
# -- test auf $1 -> kein Dienst beenden -> Script ende --
  if [ "${1}" = "help" -o "${1}" = "-h" -o "${1}" = "" -o "${pattern}" = "?" -o "${1}" = "?" -o "${1}" = "-?" -o "${1}" = "config" -o "${1}" = "service_list" -o "${1}" = "backup" -o "${1}" = "plugin_list" -o "${1}" = "swap" -o "${1}" = "swap_list" -o "${1}" = "service_ctrl" -o "${1}" = "debug" -o "${1}" = "deb" -o "${2}" = "list" -o "${2}" = "-l" -o "${1}" = "restart" -o "${2}" = "restart" -o "${2}" = "start" -o "${2}" = "stop" -o "${2}" = "status" -o "${1}" = "deconz" -o "${1}" = "-d" -o "${1}" = "dashboard" -o "${1}" = "-dashboard" -o "${1}" = "hue" -o "${1}" = "-hue" ]; then
#  -o "${1}" = "-npm" -o "${2}" = "-npm" ]; then
    hb_ServicesRestart=0
  else
    send_Telegram "Mit dem Programm: "$0" wird die "homebridge" bearbeitet!"
    HB_Services stop
  fi 
fi

# -- test auf debug info --
[ "${is_Debug}" -eq 1 ] && [ -f ${toolDir}/$dbgFile ] && . ${toolDir}/${dbgFile} ${is_Debug} hbridge	# is_Debug=1 ?

#---------------------------------

#pattern="${RunParamArray[1]}"										# $1
pattern=$1															# wird oben gesetzt
while [ "${pattern}" != "BREAK" ]; do
  case "${pattern}" in
	update|-u)
      pattern="BREAK"
      [ "${2}" = "-d" ] || [ "${2}" = "deconz" ] && pattern="-d" && continue 	# update deconz -> deconz
      #      [ "${2}" != "" ] && update_modul $2 $3 && RC=$?
      [ "${2}" != "" ] && update_modul "${@:2}" && RC=$?
#      RC=$?
#	  msg "select exit code= $RC"
 	  [ ${RC} != 0 ] && if_error "update_modul" ${RC} -1
	  msg "Starte das $Distri-Systemupdate.." $tFGreen
	  sudo apt-get update -y
	  sudo apt-get check
	  sudo apt-get autoclean >> /dev/null
	  inquire "Nicht benötigte Pakete jetzt entfernen \033[0;32m(j) $tNormal" $tFGelb
	  if [ "${answer}" = "" -o "${answer}" = "y" ]; then
	    sudo apt-get autoremove 
	  fi
	  inquire "Jetzt die Firmware (Kernel/Pakete) aktualisieren \033[0;32m(n) $tNormal" $tFGreen
	  if [ "${answer}" = "y" ]; then
        msg " update Firmware (Kernel) für ${Distri}" $tNormal
	    sudo apt-get dist-upgrade -y
	    if [ "${Distri}" == "Debian" ]; then
    	  sudo apt full-upgrade linux-image-amd64
	    else
	      inquire "Soll der aktuellste Test-Kernel installiert werden \033[0;32m(y) $tNormal" $tFGreen
	  	  if [ "${answer}" = "n" ]; then    
	        inquire "Wechsel zurück vom Test-Kernel zum Standard-Kernel \033[0;32m(n) $tNormal" $tFGreen
	  	  	if [ "${answer}" = "y" ]; then    
		      sudo apt install --reinstall raspberrypi-bootloader raspberrypi-kernel
			else
		  	  msg "Standard Kernel und Firmware wird aktualisiert!" $tNormal
	          sudo apt-get update -y >> /dev/null
	          sudo apt-get dist-upgrade -y >> /dev/null
	        fi
	  	  else
	  	  	if [ ! -e /usr/bin/rpi-update ]; then
	          msg " installiere: rpi-update" $tFGreen
	          sudo wget https://raw.github.com/Hexxeh/rpi-update/master/rpi-update -O /usr/bin/rpi-update && sudo chmod +x /usr/bin/rpi-update >> /dev/null
	        fi
	        sudo rpi-update											# akt. Test Kernel installieren		
	      fi
#		  sudo ls -al /var/cache/apt/archives
		  sudo apt-get clean >> /dev/null							# Archiv cleanen
	    fi
        sudo apt update -y
        sudo apt upgrade
	  fi
	  sudo uname -a
	  inquire "$tFRotJetzt $Distri-System neu starten \033[0;32m(j) $tNormal" ""
	  if [ "${answer}" = "" -o "${answer}" = "y" ]; then
	    neustart
	  fi
	  inquire "Soll jetzt homebridge und NodeJs entfernt werden \033[0;32m(j) $tNormal" $tFGreen
	  if [ "${answer}" = "" -o "${answer}" = "y" ]; then
        pattern="remove"
	  fi
	;;
	
	update_paket|-u_paket|-up)
	  pattern="BREAK"
	  [ "${2}" = "-d" ] || [ "${2}" = "deconz" ] && pattern="-d" && continue 	# update deconz -> deconz
	  [ "${2}" != "" ] && update_modul "${@:2}" && RC=$? 						# update_modul 
#	  && update_modul $2 $3 && RC=$?											# update_modul 
#	  RC=$?
	  [ ${RC} != 0 ] && if_error "update_modul" ${RC} -1
	  [ "${2}" = "" ] && pattern="-u"
	;;

	remove|-r)
      pattern="BREAK"
      [ "${2}" = "npm-check" ] && msg "Plugin npm-check wird entfernt!!" $tFGreen && sudo npm uninstall -g npm-check && continue
	  inquire "Alle \"homebridge\"-Instanzen jetzt löschen \033[0;32m(n) $tNormal" $tFRot
	  if [ "${answer}" = "y" ]; then
        for i in /etc/systemd/system/homebridge*.service ;do
          [ ! -f "$i" ] && continue
	      # Alle Zeichen inkl. dem letzt möglichen "/" werden von Links entfernt.
	      l=${i##*/}
	      # Alle Zeichen inkl. dem letzt möglichen "." werden von rechts entfernt.
	      r=${l%.*}
	      msg "lösche den Dienst:$tNormal ${l}" $tFGelb
	      sudo systemctl disable ${l} >> /dev/null
	      sleep 1
	      sudo rm -fr /etc/systemd/system/${l} >> /dev/null
	      sudo rm -fr /etc/default/${r} >> /dev/null
#          sudo rm -fr /var/$r >> /dev/null  						# /var/homebridge-*/config.json nicht löschen
	      sudo systemctl daemon-reload
        done
      fi
	  msg "Jetzt wird homebridge inkl. NodeJs und npm entfernt !!" $tFGreen
	  msg "Drücke Enter zum löschen oder CTRL+C für Abbruch!! \c" $tFGelb
	  read dummy
	  [ -e "/usr/local/bin/node" ] && sudo rm -fr /usr/local/bin/node >> /dev/null
	  sudo rm -fr /usr/local/bin/npm* >> /dev/null
	  [ -d "/usr/lib/nodejs" ] && sudo rm -fr /usr/lib/nodejs/*	 >> /dev/null
	  sudo rm -fr /usr/bin/node >> /dev/null
	  [ -d "/usr/local/lib/node_modules" ] && sudo rm -fr /usr/local/lib/node_modules/* >> /dev/null
	  [ -d "/usr/lib/node_modules" ] && sudo rm -fr /usr/lib/node_modules/* >> /dev/null
	  [ -d "/usr/local/include/node" ] && sudo rm -fr /usr/local/include/node/* >> /dev/null
	  [ -d "/usr/include/node/" ] && sudo rm -fr /usr/include/node/* >> /dev/null
	  [ -e "~/node_modules" ] && sudo rm -fr ~/node_modules >> /dev/null
	  [ -e "~/.npm" ] && sudo rm -fr ~/.npm >/dev/null
	  [ -e "~/.node-gyp" ] && sudo rm -fr ~/.node-gyp >> /dev/null
	  [ -e "~/.node-red" ] && sudo rm -fr ~/.node-red >> /dev/null
	  [ -e "~/.npm-global" ] && sudo rm -fr ~/.npm-global >> /dev/null
	  [ -e "/root/.npm" ] && sudo rm -fr /root/.npm >> /dev/null
	  [ -e "/root/.node-gyp" ] && sudo rm -fr /root/.node-gyp >> /dev/null

	  msg "Jetzt kann die homebridge neu installiert werden!" $tFGreen
	  inquire "Soll jetzt homebridge neu installiert werden \033[0;32m(j) $tNormal" $tFRot
	  if [ "${answer}" = "" -o "${answer}" = "y" ]; then
        pattern="install"
	  fi
	;;

	install|-i)
      pattern="BREAK"
	  cd $HOME
      [ "${2}" = "AirPlay" ] || [ "${2}" == "-AirPlay" ] &&  inst_AirPlay && continue
	  msg "Installiere und konfiguriere benötigte Tools." $tFGreen
#	   sudo apt-get install -y lsb-core  # install the lsb modules
#	   sudo apt-get install -y git ntp mc ntpdate libpcap*
	  sudo apt-get install -y git mc libpcap*
	  create_Tools
      ctrl_Services
#      create_ctrlService homebridge service

	  if [ "${Distri}" == "Debian" ]; then
	    msg "\nWelche NodeJS Version soll installiert 8.x, 9.x, 10.x oder 11.x werden: \033[0;32m(10)$tNormal? \c"
	    read -n2 nodeVersion
	    echo ""
	    if [ "${nodeVersion}" = '' ]; then
	      nodeVersion="10"
	    elif [ "${nodeVersion}" -gt "11" -o "${nodeVersion}" -lt "8" ]; then	# grösser 11 oder kleiner 8
	      msg "Eingabe von Version= ${nodeVersion}"
	      msg "\n\t\t Abbruch !!\n$tFGelb aktuell existiert für ${Distri} nur Versionen 8.x, 9.x, 10.x und 11.x!" $tFRot
          exitCode=6
          pattern="BREAK"
	    fi
	    msg "Es wird das nodejs ${nodeVersion}.x für ${Distri} installiert!!" $tFGelb
#	     sudo curl -sL https://deb.nodesource.com/setup_${nodeVersion}.x | sudo -E bash -    # Ubuntu
	    sudo curl -sL https://deb.nodesource.com/setup_${nodeVersion}.x | bash -    		 # Debian
        sudo apt-get install -y nodejs
	    sudo apt-get install -y build-essential
	  elif [ "${Distri}" == "Raspbian" ]; then
	    msg "\nWelche NodeJS Version soll installiert werden: \033[0;32m($max_nodeVersion)$tNormal?"
	    msg "[letzte stabile Version: ${stab_nodeVersion}]" $tFGreen
	    read nodeVersion
	    if [ "${nodeVersion}" = '' ]; then
	      nodeVersion="${max_nodeVersion}"
	    fi
	    msg "Installiere node in Version ${nodeVersion} auf einem ${Distri-System}" $tFGreen
	    if [ "${UNAME}" = "armv6l" -o "${UNAME}" = "armv7l" ]; then
	      msg "Der RasPi basiert auf: ${UNAME}"
#!	       wget https://nodejs.org/dist/latest/node-v?.?.?-linux-$UNAME.tar.gz
#!	       node-v7.10.0-linux-armv7l.tar.gz
	      wget https://nodejs.org/dist/v${nodeVersion}/node-v${nodeVersion}-linux-${UNAME}.tar.gz
	      tar -xvf node-v${nodeVersion}-linux-${UNAME}.tar.gz
	      cd $HOME/node-v${nodeVersion}-linux-${UNAME}/
	      sudo cp -Rf * /usr/local/
	      cd $HOME
	      sudo rm -f node-v${nodeVersion}-linux-${UNAME} -r
	      sudo rm -f node-v${nodeVersion}-linux-${UNAME}.tar.gz
	    fi
	  else
	    msg "\n\t\t Abbruch !!\n$tFGelb Die Distribution ist unbekannt." $tFRot
	    exit 8
      fi
	  msg "..installiere libavahi libdnssd-dev." $tFGreen
	  sudo apt-get install -y libavahi-compat-libdnssd-dev
	  msg "\nWelche NPM Version soll installiert werden: \033[0;32m(latest)$tNormal?"
	  msg "(Eingabe möglichkeiten: ${max_npmVersion}, \"latest\" oder \"no\")"
	  msg "(mit \"no\" wird nur homebridge installiert und die npm von node ${nodeVersion} benutzt)"
	  msg "[letzte stabile Version: ${stab_npmVersion}]" $tFGreen
	  read npmVersion
	  if [ "${npmVersion}" = '' ]; then
	    npmVersion="latest"
	  fi

	  msg "\nWelche homebridge Version soll installiert werden: \033[0;32m(latest)$tNormal?"
	  msg "(Eingabe möglichkeiten: ${max_hbVersion}, \"latest\" oder \"no\")"
	  msg "(mit \"no\" wird keine homebridge installiert)"
	  msg "[letzte stabile Version: ${stab_hbVersion}]" $tFGreen
	  read hbVersion
	  if [ "${hbVersion}" = '' ]; then
	    hbVersion="latest"
	  fi
	  msg "Moment: installiere das npm@${npmVersion} und homebridge@${hbVersion} Release!" $tFGreen
	  if [ "${npmVersion}" = "no" ]; then
        if [ "${hbVersion}" = "no" ]; then
	      msg " "
	    else
	      sudo npm install -g --unsafe-perm homebridge@${hbVersion}
	    fi
	  else
        if [ "${hbVersion}" = "no" ]; then
	      sudo npm install -g --unsafe-perm npm@${npmVersion}
	    else
	      sudo npm install -g --unsafe-perm npm@${npmVersion}
	      sudo npm install -g --unsafe-perm homebridge@${hbVersion}
	    fi
	  fi
	  if [ -e /root/.npm-global/bin/homebridge ]; then
	    sudo ln -s /root/.npm-global/bin/homebridge /usr/local/bin/homebridge
	    msg "Link zum .npm-global erstellt."
	  fi
	  if [ -e /root/.npm-global/bin/npm ]; then
	    sudo mv -f /usr/local/bin/npm /usr/local/bin/npm.org
	    sudo ln -s /root/.npm-global/bin/npm /usr/local/bin/npm
	    msg "Link zum npm-global/bin/npm erstellt."
	  fi
	  cd ${toolDir}
	  msg "\nEs wurde node@${nodeVersion}, npm@${npmVersion} und homebridge@${hbVersion} installiert!!\n" $tFGreen
      if [ ! -e /var/homebridge/config.json ]; then
        sudo mkdir /var/homebridge
        sudo cp -f ${toolDir}/files/config.json /var/homebridge/config.json
        sudo chown -R homebridge:users /var/homebridge/
        sudo chmod -R 0777 /var/homebridge
        msg "Eine leere config.json und der homebridge Ordner /var/homebridge/config.json wurde erstellt!" $tFGreen
      fi
	  inquire "Sollen jetzt die Plugin's installiert werden \033[0;32m(j) $tNormal" $tFGreen
	  if [ "${answer}" = "" -o "${answer}" = "y" ]; then
        pattern="plugin"
	  else
	    msg "Nicht vergessen, Plugin's müssen noch installiert werden!" "\n\033[1;36m"
	  fi
	;;

	plugin|-p)
      pattern="BREAK"
      [ "${2}" = "list" ] || [ "${2}" == "-l" ] &&  pattern="plugin_list" && continue
 #     [ "${RunParamArray[3]}" = "list" ] || [ "${RunParamArray[3]}" == "-l" ] &&  pattern="plugin_list" && continue
   	  msg  "Plugindatei: $tFGelb${toolDir}/${pluginFile}$tFGreen wird gesucht." $tFGreen
	  if [ -e ${toolDir}/$pluginFile ]; then
	    msg  "Plugindatei: $tFGelb${toolDir}/${pluginFile}$tFGreen wurde gefunden, \nlese die zu installierenden Plugin's ein." $tFGreen
	    while read -r line
	    do
	      pluginBaseName="homebridge-"
	      pluginName="${pluginBaseName}${line}"
	      if echo "${line}" | grep -q '^#' ; then
	        msg "Plugin: ${line} wird nicht installiert ($tFGelb ist auskommentiert$tFGreen )!" $tFGreen
	      elif echo "${line}" | grep -q '^@' ; then
	        line2=`echo "$line" | awk '{print substr($0,2)}'`
	        msg "Plugin: ${line2} wird direkt aus dem web/git installiert!" $tFGreen
	        sudo chown -R $USER /usr/local && npm install -g ${line2}
	      else
	        msg "installiere Plugin: ${pluginName}" $tFGreen
	        if echo "${line}" | grep -q '\>@' ; then
		      msg "Es wird eine bestimmte Version installiert von: $tNormal${pluginName}" $tFGelb
	        else
		      pluginName="${pluginName}@latest"
		      msg "Es wird die letzte Version installiert von: $tNormal${pluginName}" $tFGelb
	        fi
#	        if echo "${pluginName}" | grep -q '\>-hue' ; then
#	          msg "Es wurde \"HUE\" erkannt, ich installiere die letzte Version von: $tNormal\"homebridge-lib homebridge-hue\"" $tFGelb
#	          read -p "Sollen beide installiert werden [j/y/n] (n)?" choice
#	          if [[ ${choice} =~ ^[jJYy]$ ]]; then
#	            pluginName="homebridge-lib@latest homebridge-hue@latest"
#	          fi
#	        fi
#	        sudo chown -R $USER /usr/local && npm install --unsafe-perm -g ${pluginName}
		    sudo chown -R $USER /usr/local && npm install -g ${pluginName}
	      fi
	      done < ${toolDir}/${pluginFile}
	  else
	    msg "Es wurde keine Plugindatei $tFGelb${toolDir}/${pluginFile}$tFGreen gefunden, bitte die Plugins manuell installieren!" $tFGreen
	  fi
	  sudo npm list -g --depth=0
	  inquire "\nSoll Homebridge jetzt als Dienst installierte werden \033[0;32m(j) $tNormal" $tFGreen
	  if [ "${answer}" = "" -o "$answer" = "y" ]; then
        pattern="service"
	  fi
	;;

	service|-s)
      pattern="BREAK"
      if [ "${2}" == "list" ] || [ "${2}" == "-l" ] || [ "${2}" == "status" ]; then
        pattern="service_list"
        continue
      elif [ "${2}" == "ctrl" ] || [ "${2}" == "-c" ]; then
        pattern="service_ctrl"
        continue
      elif [ "${2}" == "stop" ] || [ "${2}" == "start" ] || [ "${2}" == "restart" ]; then
#    	HB_Services "$2" "$3"										# "$3"= ServiceName
    	HB_Services "${@:2}" 										# ab Parameter 2 übergeben
    	hb_ServicesRestart="0"
        continue
      elif [ "${2}" == "remove" ] || [ "${2}" == "delete" ] || [ "${2}" == "-r" ]; then
        pattern="service_remove"
        continue
      elif [ "${2}" == "inst" ] || [ "${2}" == "install" ] || [ "${2}" == "-i" ]; then
        pattern="service_install"
        continue
      else
#	     create_Tools
        ctrl_Services
	    input_HBServices
	    RC=$?
 	    [ ${RC} != 0 ] && if_error "input_HBServices" ${RC} -1
	    msg "Alle Services wurden erstellt und aktiviert." $tFGreen
	    msg "\nFür das Einrichten eines verzögerten Start$tNormal \"$0 wait2deconz\"$tFGreen benutzen." $tFGelb
#!#	     inquire "\n$tFRot Ein neustart des $Distri-System ist jetzt zu empfehlen \033[0;32m(n) $tNormal" ""
#!#	     if [ "${answer}" = "y" ]; then
#!#	       neustart
	  fi
	;;

	service_install)
      pattern="BREAK"
	  input_HBServices $3
	  RC=$?
 	  [ ${RC} != 0 ] && if_error "input_HBServices" ${RC} -1
	;;
	
	service_list)
      pattern="BREAK"
	  msg "Anzeige der HB-Instanzen und wenn vorhanden reporter, logwatch, fritzbox-reboot und deCONZ Instanzen!" $tFGreen
	  msg "\033[0;33mBeispiel: $tNormal\n loaded active running - \t Instanz ist aktiviert und läuft (running)"
	  msg "$tNormal loaded inactive dead - \t Instanz deaktiviert und gestoppt (dead)\n"
	  msg "gefundene Instanzen:" $tFGelb
	  sudo systemctl list-units --type=service --all | grep 'deconz\|homebridge\|reporter\|logwatch\|fritzbox-reboot\|forked\|mosquitto'
	  msg "installierte Instanzen inkl. Status:" $tFGelb
	  sudo systemctl list-unit-files | grep 'deconz\|homebridge\|reporter\|logwatch\|fritzbox-reboot\|forked\|mosquitto'
      exitCode=9
	;;

	npm-check|-npm)
	  pattern="BREAK"
	  which npm-check || msg "Das Tool \"npm-check\" wird installiert!\033[0m" $tFGelb && sudo npm install -g npm-check
	  msg "\nPlugin-Update mit dem Tool \"npm-check\" !\n" $tFGelb
	  sudo npm-check -gu
	;;

	hue|-hue)
	  pattern="BREAK"
	  hue_config test
	  RC=$?
	  [ ${RC} = 1 ] && continue										# && msg "Error = ${RC}"
	  if [ "${2}" == "inst" ] || [ "${2}" == "-i" ] || [ "${2}" == "deinst" ] || [ "${2}" == "-d" ]; then
	    if [ ! -e ${toolDir}/hue_backup_restore ]; then
	      hue_config warn
	      msg "Es wird jetzt das Tool$tNormal \"hue_backup_restore\"$tFGelb installiert!!" $tFGelb
	      git clone https://github.com/schreter/hue_backup_restore >> /dev/null
	    else
	      msg "Soll das Tool$tNormal \"hue_backup_restore\"$tFGelb gelöscht werden? \033[0;32m[y/j/n]$tGreen (n) \c" $tFGelb
          read -t 10 dummy
          if [[ ${dummy} =~ ^[JjYy]$ ]]; then							# || [ "$dummy" == "" ]; then 
	        sudo rm -rf ${toolDir}/hue_backup_restore >> /dev/null
		  fi
	    fi
	  elif [ "${2}" == "backup" ] || [ "${2}" == "-b" ]; then
	    hue_config backup
	    RC=$?
	    [ ${RC} = 2 ] && msg "\033[0;33mBenutze zu erst:\033[1;37m $0 -hue -i\033[0m"
	    [ ${RC} != 0 ] && continue
	    
	  elif [ "${2}" == "restore" ] || [ "${2}" == "-r" ]; then
	    hue_config warn
	    hue_config restore
	    RC=$?
	    [ ${RC} = 2 ] && msg "\033[0;33mBenutze zu erst:\033[1;37m $0 -hue -i\033[0m"
	    [ ${RC} != 0 ] && continue  
	  else
	    msg "Es wurde kein Parameter (-i / -d / -b / -r) angegeben!" $tGreen
	  fi

	;;
	
	dashboard|-dashboard)
	  pattern="BREAK"
	  if [ ! -e /usr/local/bin/homebridge-dashboard.sh ]; then
	  	msg "Das aktuelle DashBoard wird vom gut-hub geladen!" $tFGelb
	    wget -qO - https://raw.githubusercontent.com/nastras/homebridge-dashboard/master/dashboard-installer.sh | bash
	    sleep 2
	    msg "Das DashBoard \"homebridge-dashboard.sh\" wurde eingerichtet!" $tFGelb
	    which npm-check || msg "Das Tool \"npm-check\" wird installiert, da es benötigt wird!\033[0m" $tFGelb && sudo npm install -g npm-check
	    dummy=$(cat $HOME/.profile | grep -c "homebridge-dashboard.sh")
	  	if [ "${dummy}" -eq 0 ] && [ -e /usr/local/bin/homebridge-dashboard.sh ]; then
	      msg "Soll das Dashboard bei der SSH-Anmeldung ausgeführt werden? \033[0;32m[y/j/n]$tGreen (j) \c" $tFGelb
          read -t 5 dummy
          if [[ ${dummy} =~ ^[JjYy]$ ]] || [ "${dummy}" == "" ]; then 
            sudo bash -c "echo /usr/local/bin/homebridge-dashboard.sh >> $HOME/.profile" 		# an Datei anfügen
	  	    msg "Das DashBoard wurde in \"$HOME/.profile\" eingetragen und wird beim nächsten Login ausgeführt!\n" $tFGelb
	  	  fi
  	      msg "Der Befehl \"homebridge-dashboard.sh\" wurde eingerichtet!\n" $tFGelb
		fi
	  else
	    msg "Das DashBoard \"homebridge-dashboard.sh\" wird entfernt!" $tFGelb
	    sudo rm -rf /usr/local/share/homebridge-dashboard
	    sudo rm -rf /usr/local/bin/homebridge-dashboard.sh
	    msg "Das DashBoard wird (wenn vorhanden) aus \"$HOME/.profile\" entfernt!\n" $tFGelb
	    sudo sed -i '/homebridge-dashboard.sh/d' $HOME/.profile
	    msg "Soll das Tool \"npm-check\" jetzt deinstalliert werden? \033[0;32m[y/j/n]$tGreen (n) \c" $tFGelb
        read -t 5 dummy
        if [[ ${dummy} =~ ^[JjYy]$ ]]; then      
	      sudo npm uninstall -g npm-check 
	      msg "Tool \"npm-check\" wurde deinstalliert!!" $tFGelb
	    fi
	  fi
	;;	
	 
	cam)
      pattern="BREAK"
	  if [ "${Distri}" == "Raspbian" ]; then
	    inquire "\n\033[0;33mSoll jetzt am Cam-Anschluss eine Kamera eingerichtet werden? \033[0;32m(j) $tNormal" $tFGreen
	    if [ "${answer}" = "n" ]; then exit 3; fi
	    inquire "\nWurde die Option Cam im raspi-config (-> 5 -> P1) schon aktiviert?\033[0;32m(j) $tNormal" $tFGelb
	    if [ "${answer}" = "n" ]; then
	      sudo raspi-config
	      neustart
	    fi
	    msg "\nModul bcm2835-v4l2 wird aktiviert!!" $tFGelb
	    sudo modprobe bcm2835-v4l2
	    isInFile=$(cat /etc/modules | grep -c "bcm2835-v4l2")
	    if [ "${isInFile}" -eq 0 ]; then
	      msg "/etc/modules wird gesichert und erweitert." $tNormal
	      msg "Einrichten: autoload von bcm2835-v4l2." $tNormal
	      sudo cp -f /etc/modules /etc/modules.org
	      sudo bash -c "echo bcm2835-v4l2 >> /etc/modules"
	    else
	      msg "bcm2835-v4l2 wird schon geladen." $tNormal
	    fi
	    msg "ffmpeg für die Kamera wird installiert." $tFGelb
	    sudo apt install ffmpeg
	    sudo npm install -g homebridge-camera-rpi
	    msg "Die Kamera sollte jetzt funktionieren, in der iOS-APP Gerät hinzufügen und Code von der Homebridge eingeben." $tFGreen
	    neustart
	  else
	    msg "Der CAM -Support wird nur auf einem Raspberry unterstützt." $tFGreen
	  fi
	;;

	deconz|-d)
      pattern="BREAK"
      [ "${2}" = "service" ] || [ "${2}" == "-s" ] && pattern="deconz_service" && continue
      if [ "${2}" = "remove" ] || [ "${2}" == "-r" ]; then
        inquire "Soll deCONZ jetzt gelöscht werden: \033[0;32m(n) $tNormal" $tFGreen
	    if [ "${answer}" = "y" ]; then
	      sudo systemctl disable deconz-gui >> /dev/null
	      sudo systemctl disable deconz-homebridge >> /dev/null
	      sudo systemctl disable deconz-init >> /dev/null
	      sudo systemctl disable deconz-update >> /dev/null
	      sudo systemctl disable deconz-wifi >> /dev/null
	      sudo systemctl disable deconz >> /dev/null
	      ${STOP_deCONZgui} >> /dev/null
	      sudo systemctl stop deconz-homebridge >> /dev/null
	      sudo systemctl stop deconz-init >> /dev/null
	      sudo systemctl stop deconz-update >> /dev/null
	      sudo systemctl stop deconz-wifi >> /dev/null
	      ${STOP_deCONZ} >> /dev/null
	      sudo systemctl daemon-reload >> /dev/null
	      sudo rm -f $HOME/.config/autostart/deCONZ.desktop >> /dev/null
          sudo dpkg -r deconz										# remove deConz
          msg "deConz wurde gelöscht!" $tFGreen
          exitCode=12
          continue
        fi
      fi
    
	  msg "\t\t  Jetzt wird deCONZ installiert!\n" $tFGreen
	  if [ -n "${PID_dCS}" ]; then
        msg " Für das Update wird \"deCONZ\" gestoppt!" $tFGelb
        sudo kill ${PID_dCS}
	  fi
	  if [ -n "${PID_dCS}" ]; then
        msg " Für die Dauer der Installation wird der Dienst \"deconz\" gestoppt!" $tFGelb
        ${STOP_deCONZ} ; ${STOP_deCONZgui}
	  fi
	  if [ "${Distri}" == "Raspbian" ]; then
	    msg "Zugriffsrechte der seriellen Schnittstelle für Nutzer setzen" $tFGelb
	    msg " Zuerst müssen mit dem Befehl:\n $tFGelb\"sudo raspi-config\"\n$tNormal folgende Einstellungen gemacht werden!" $tNormal
	    msg " gehe zu $tFGelb\"Interfacing Options → Serial\"" $tNormal
	    msg " wähle $tFGelb\"Would you like a login shell accessible over serial? → No\"" $tNormal
	    msg " und   $tFGelb\"Would you like the serial port hardware to be enabled? → Yes\"" $tNormal
	    msg "Hinweis: Die Zugriffsrechte werden erst nach einem Neustart aktiv.\n" $tNormal
		msg "Jetzt beenden, das diese Einstellungen gemacht werden können? \033[0;32m[y/j/n]$tGreen (n) $tNormal" $tFGreen
		read answer
		[[ ${answer} =~ ^[jJyY]$ ]] && pattern="restart" && continue 2
	    msg "Die akt. Raspi-Version einsehen: \033[0;33m${www_deconz_raspian}/$tNormal."
	    msg "\nWelche Version von deCONZ soll installiert werden: \033[0;32m(${max_deCONZVersion})$tNormal?"
	    msg "[letzte stabile deCONZ Version: ${stab_deCONZVersion}, beta]" $tFGreen
	  else
	    msg "Die akt. Debian-Version einsehen: \033[0;33m${www_deconz_ubuntu}/$tNormal."
	    msg "\nWelche Version von deCONZ soll installiert werden: \033[0;32m(${max_deCONZVersionDeb})$tNormal?"
	    msg "[letzte stabile deCONZ Version: ${stab_deCONZVersionDeb}]" $tFGreen
	  fi
	  read deCONZVersion
	  if [ "${deCONZVersion}" = '' ]; then
	    if [ "${Distri}" == "Raspbian" ]; then
	      deCONZVersion=${max_deCONZVersion}
	    else
	      deCONZVersion=${max_deCONZVersionDeb}
	    fi
	  fi

# deCONZ installation apt
#-------------------------
	  if [ "${Distri}" == "Raspbian" ]; then
	    msg "deCONZ manuell oder mit Paketmanager installieren\033[0;32m [m/p]$tGreen (p)" $tFGreen
	    read answer
	    [ ${answer} = "m"]  || [ ${answer} = "M" ] && answer=m && deConzInstMode=manual
	    [ ${answer} = "" ] || [ ${answer} = "p" ] || [ ${answer} = "P" ] && deConzInstMode=apt
	  
	    if [ "${deConzInstMode}" = "apt" ] && [ "${Distri}" == "Raspbian" ]; then		# deCONZ installation via Paketmnanger
	      if [ ! -e /etc/apt/sources.list.d/deconz.list ]; then
	        msg "Phoscon Public-Key anzeige/importieren" $tFGelb
	        sudo apt-key list >> /dev/null
	        read -p "Import mit Enter.." dummy
	        wget -O - http://phoscon.de/apt/deconz.pub.key | sudo apt-key add -
  	        msg "APT-Repository für deCONZ konfigurieren" $tFGelb
	        msg "Soll die Stable oder Beta (Alternativ) eingerichtet werden? \033[0;32m[s/b/q]$tGreen (s) $tNormal" $tFGreen
	        read answer
	        if [ ${answer} = "s" ] || [${answer} = "S"] || [ ${answer} = "" ]; then
		      sudo sh -c "echo 'deb http://phoscon.de/apt/deconz $(lsb_release -cs) main' > /etc/apt/sources.list.d/deconz.list"
            elif [ "${answer}" = "b" ] || [${answer} = "B"]; then									# Beta (Alternativ)
		      sudo sh -c "echo 'deb http://phoscon.de/apt/deconz $(lsb_release -cs)-beta main' > /etc/apt/sources.list.d/deconz.list"
            else
              continue 2
            fi
          fi
	        msg "APT-Paketliste wird aktualisiert" $tFGelb
	        sudo apt update >> /dev/null
	        if [ -e /etc/apt/sources.list.d/deconz.list ] && [ ! -e /lib/systemd/system/deconz-update.service ]; then
	          msg " installiere deCONZ..." $tFGelb
	        elif [ -e /etc/apt/sources.list.d/deconz.list ] && [ -e /lib/systemd/system/deconz-update.service ]; then
	          msg " update deCONZ..." $tFGelb
	        fi
	        sudo apt-get install -y deconz >> /dev/null
	        if [ "${Distri}" == "Raspbian4" ]; then					# if = Raspberry 4 (WiringPi aktualisieren)
			  cd /tmp
			  wget https://project-downloads.drogon.net/wiringpi-latest.deb
			  sudo dpkg -i wiringpi-latest.deb
			  cd ${toolDir}
		  fi
	      continue
	    fi
	  fi

# deCONZ installation manual
#--------------------------
	  if [ "${deCONZVersion}" = 'beta' ] && [ "${Distri}" == "Raspbian" ]; then
	    msg "Installiere für ${Distri} das \033[0;33mdeconz-latest-beta.deb\033[1;32m Release!" $tFGreen
	    wget ${www_deconz_raspian}/deconz-latest-beta.deb
	    sudo dpkg -i deconz-latest-beta.deb							# install Raspberry & Debian
	  else
	    msg "Installiere für ${Distri} das \033[0;33mdeconz-${deCONZVersion}-qt5.deb\033[1;32m Release!" $tFGreen
	    if [ "${Distri}" == "Raspbian" ]; then						# download Raspberry
	      wget ${www_deconz_raspian}/deconz-${deCONZVersion}-qt5.deb
	    else														# download Debian
	      wget ${www_deconz_ubuntu}/deconz-${deCONZVersion}-qt5.deb
	    fi
	    sudo dpkg -i deconz-${deCONZVersion}-qt5.deb					# install Raspberry & Debian
	  fi
 	  sudo apt update && sudo apt upgrade -y
	  sudo apt install -f
	  msg " ..lösche den Download" $tFGelb
	  sudo rm -f ./deconz-${deCONZVersion}-qt5.deb
#      pattern=d"econz_service"
	;&
#;;
	
	deconz_service)
#      if [ "${deconz_service}" != "deconz" ] || [ "${deconz_service}" != "deconz-gui" ]; then
	    msg "Soll deCONZ als Dienst$tNormal (d)$tFGreen oder X11 Anwendung$tNormal (x)$tFGreen starten? \033[0;32m[d/x] (n) $tNormal" $tFGreen
	    read -p "weiter mit Enter.." answer 
#	  fi
	  if [ "${answer}" = "d" ]; then
	  # || [ "${deconz_service}" = "deconz" ]; then
	  	if [ -e $HOME/.config/autostart/deCONZ.desktop ]; then
	  	  msg "\n\t\tdeCONZ autostart im Grafikmode von X11 wird entfernt!" $tFGelb
		  sudo systemctl disable deconz-gui >> /dev/null
		  ${STOP_deCONZgui} >> /dev/null
		  rm -f $HOME/.config/autostart/deCONZ.desktop
		fi
		sudo systemctl disable deconz-gui >> /dev/null
		${STOP_deCONZ} >> /dev/null
	    sudo systemctl enable deconz >> /dev/null
	    sudo systemctl daemon-reload >> /dev/null
	    msg "\n\t\tdeCONZ startet als Dienst!" $tFGelb
	    if [ -n "${PID_dCS}" ]; then
          msg "\033[1;33mDer Dienst \"deconz\" wird wieder gestartet!$tNormal\n"
          ${START_deCONZ}
	    fi
#	    sudo sed -i 's;deconz_service=\"\";deconz_service=\"deconz\";g' $toolDir/$configFile
	  elif [ "${answer}" = "x" ]; then
	  # || [ "$deconz_service" = "deconz-gui" ]; then
	    if [ ! -e $HOME/.config/autostart/deCONZ.desktop ]; then
	      sudo systemctl disable deconz >> /dev/null
		  ${STOP_deCONZ} >> /dev/null
	      sudo mkdir -p $HOME/.config/autostart
	      cp -Rf ${toolDir}/files/deCONZ.desktop $HOME/Desktop
	      cp -Rf ${toolDir}/files/deCONZ.desktop.autostart $HOME/.config/autostart/deCONZ.desktop
	      sudo systemctl enable deconz-gui >> /dev/null
		  sudo systemctl restart deconz-gui >> /dev/null
	      msg "\n\t\tdeCONZ startet im Grafikmode von X11!" $tFGelb
#	      sudo sed -i 's;deconz_service=\"\";deconz_service="\deconz-gui\";g' ${toolDir}/$configFile
	    else
	      msg "\n\t\tAutostart für deCONZ unter X11 ist schon eingerichtet!" $tFGelb
	    fi
	  else
	    msg "Der deCONZ start wurde nicht verändert " $tFGelb
	  fi
#	  [ "${answer}" = "x" ] || [ "${answer}" = "d" ] && msg "Evtl. muss noch die Variable $tNormal\"deconz_service\"$tFGelb in $tNormal\"${toolDir}/${configFile}\"$tFGelb gesetzt werden!" $tFGelb
	  [ "${pattern}" = "deconz_service" ] && pattern="BREAK" && continue
	  pattern="BREAK"
	  msg "\n\t\t$tFRotDas ${Distri}-System sollte jetzt neu gestartet werden!!$tNormal\n"
	  msg "Hinnweis für Raspbian Jessie or Stretch with Qt5:" $tFGelb
	  echo -e "Important The serial port must be configured as follows to allow communication with the RaspBee."
	  echo -e "$ sudo raspi-config\n() Interfacting Options > Serial \n    * Would you like a login shell accessible over serial?"
	  echo -e "      > No\n    * Would you like the serial port hardware to be enabled?"
	  echo -e "      > Yes\n\n"
	  msg "\t Zum übernehmen muss der ${Distri}-System neu gestartet werden!" $tFGreen
	  neustart
	;;
	
	wait2deconz|-wd)
      pattern="BREAK"
      msg "Verzögerten Start für \"homebridge\" Instanz einrichten/entfernen!" $tFGreen
      Service_NAME="1"
      while [ -n "${Service_NAME}" ]; do
        cd /etc/systemd/system
        msg "\033[0;33m\nWelche homebridge-Instanz soll verzögert starten?$tNormal"
        sudo find homebridge*.service -exec echo {} \;
        cd ${toolDir}
        msg "\nName der Instanz (alles vor .service) eingeben: \033[0;32m(Abbruch mit Enter)$tNormal" "\033[1;33m"
        read  Service_NAME
        if [ "${Service_NAME}" = "" ]; then
          continue
        fi
        if [ -e /etc/systemd/system/${Service_NAME}.service ]; then
	      isInFile=$(sudo cat /etc/systemd/system/${Service_NAME}.service | grep -c "ExecStartPre=")
	      if [ "${isInFile}" -eq 0 ]; then
	        msg "In der Datei$tNormal /etc/systemd/system/${Service_NAME}.service,$tFRot wurde kein entsprechender Eintrag gefunden!" $tFRot
	        sudo sudo cp -R ${toolDir}/files/homebridge.service.${Distri} /etc/systemd/system/${Service_NAME}.service
	        sudo sed -i 's;EnvironmentFile=/etc/default/homebridge;EnvironmentFile=/etc/default/'${Service_NAME}';g' /etc/systemd/system/${Service_NAME}.service
	        msg "Es wurde eine neue Instanz \"${Service_NAME}.service\" erstellt!" $tFGelb
          fi
	      wert=$(grep "ExecStartPre=" /etc/systemd/system/${Service_NAME}.service)
	      msg "aktuelle Verzögerung ist: "${wert#* }"sec"
	      msg ""
	      msg "\nWieviel Sekunden nach dem start/reboot, soll die Instanz starten: \033[0;32m(Enter=löschen)$tGelb?" $tFGelb
	      read hbridge_vtime
          if [ "${hbridge_vtime}" = "" ]; then
	        # Zeilelenanfang suchen, global (mehrere Einträge tauschen)
            sudo sed -i 's;^ExecStartPre=.*$;ExecStartPre= ;g' /etc/systemd/system/${Service_NAME}.service
            msg "Die Verzögerung von ${Service_NAME}.service wurde glöscht." $tFGelb
          else
            # zeile ersetzen
            sudo sed -i 's;^ExecStartPre=.*$;ExecStartPre=/bin/sleep '${hbridge_vtime}';g' /etc/systemd/system/${Service_NAME}.service
            msg "Die Instanz ${Service_NAME} startet jetzt um ${hbridge_vtime} sec verzögert." $tFGelb
          fi
	    else
	      msg "Die Instanz existiert nicht, zum anlegen den Parameter \033[1;37m[ -s ]$tRot benutzen!" $tRot
	    fi
      done
      sudo systemctl daemon-reload
    ;;

	reboot)
	  neustart
	;;

	restart)
      pattern="BREAK"
      [ ! -z "${PID_mm2}" ] && mm2_restart && continue 2
      HB_Services restart $2										# $2 = Servicenamne
      hb_ServicesRestart="0"
      exitCode="2"
	;;

	service_remove)	
      pattern="BREAK"
      if [ -z "${3}" ]; then										# $3 = Servicenamne
	    cd /etc/systemd/system
	    msg "\nDiese homebridge-Instanzen existieren:\n" $tGelb
	    sudo find homebridge*.service -exec echo {} \;
	    cd $toolDir
	    msg "\nWelche Instanz soll gelöscht werden?\n$tGelb (Eingabe: \"homebridge\" löscht die homebridge Instanz)\n (Eingabe: \"hue\" löscht die homebridge-hue Instanz)" $tFGelb
	    msg "(falls eine standalone Instanz für \homebridge-config-ui-x-InstanzName\"  existiert, wird diese mit gelöscht)" $tFGelb
	    read  Service_NAME
	  else
	    Service_NAME="${3}"
	  fi
	  [[ ${Service_NAME} =~ "homebridge-" ]] && Service_NAME=${Service_NAME#*-}		# wenn mit homebridge- anfängt, von li alles inkl. homebridge- löschen
	  if [ "${Service_NAME}" = "homebridge" ]; then
	    sudo sudo systemctl disable ${Service_NAME}.service
	    sudo rm -fr /etc/default/${Service_NAME} >> /dev/null
	    sudo rm -fr /etc/systemd/system/${Service_NAME}.service >> /dev/null
#	     sudo rm -fr /var/${Service_NAME} >> /dev/null  								# /var/homebridge-*/config.json nicht löschen
	    msg " Die Instanz$tNormal \"${Service_NAME}.service\"$tGelb wurde gelöscht!" $tFGelb
	    msg " Der Ordner$tNormal \"/var/${Service_NAME}\"$tGelb wurde\033[0;31m NICHT$tGelb gelöscht!" $tGelb	  
	    msg " Das Plugin$tNormal \"${Service_NAME}\"$tGelb wurde\033[0;31m NICHT$tGelb deinstalliert!" $tFGelb
	  elif [ -e /etc/systemd/system/homebridge-${Service_NAME}.service ]; then
	    sudo sudo systemctl disable homebridge-${Service_NAME}.service
	    sudo rm -fr /etc/default/homebridge-${Service_NAME} >> /dev/null
	    sudo rm -fr /etc/systemd/system/homebridge-${Service_NAME}.service >> /dev/null
#	     sudo rm -fr /var/homebridge-${Service_NAME} >> /dev/null  					# /var/homebridge-*/config.json nicht löschen
	    msg " Die Instanz$tNormal \"homebridge-${Service_NAME}.service\"$tGelb wurde gelöscht!" $tFGelb
	    msg " Der Ordner$tNormal \"/var/homebridge-${Service_NAME}\"$tGelb wurde\033[0;31m NICHT$tGelb gelöscht!" $tGelb

	    msg " Soll das zugehörige Plugin deinstalliert werden?\n$tGelb Bitte den Plugin-Namen eingeben (\"hue\" =$tNormal \"homebridge-hue\"$tGelb):\033[0;32m (Enter = weiter ohne Deinstallation)$tNormal" $tFGreen
		read answer
		if [ ${answer} != "" ]; then
	      sudo npm -g uninstall homebridge-$answer
	      msg " Das Plugin$tNormal \"homebridge-${answer}\"$tGelb wurde deinstalliert!" $tFGelb
	    fi
	  else
	    msg " Die Instanz existiert nicht:$tNormal \"homebridge-${Service_NAME}.service\"  $tFRot(Abbruch)" $tFGelb
	  fi
	  if [ -e /etc/systemd/system/homebridge-config-ui-x-${Service_NAME}.service ]; then
	  	sudo systemctl disable homebridge-config-ui-x-${Service_NAME}.service
	    sudo rm -fr /etc/default/homebridge-config-ui-x-${Service_NAME} >> /dev/null
	    sudo rm -fr /etc/systemd/system/homebridge-config-ui-x-${Service_NAME}.service >> /dev/null
	    msg " Die zugehörige Instanz \"homebridge-config-ui-x-${Service_NAME}.service\" wurde auch gelöscht!" $tFGelb
	  fi
      sudo systemctl daemon-reload
	;;

	backup)
      pattern="BREAK"
	  if [ "${2}" = "del" ]; then						# alle Sicherungen löschen
	    HB_del_Sic="2"
	  elif [ "${2}" = "nodel" ]; then					# keine Sicherung löschen
	    HB_del_Sic="0"
	  fi
	  mount_SicMedium ${HB_sic_Pfad}
	  RC=$?
	  [ ${RC} != 0 ] && if_error "mount_SicMedium" ${RC} -1
	  if [ ${HB_sic_Anzahl} != "" ]; then
  	    if ls ${HB_sic_Pfad}/*.tar.gz 1> /dev/null 2>&1; then
          if [ "${HB_del_Sic}" = "2" ]; then
            sudo rm -rf ${HB_sic_Pfad}/*.tar.gz >> /dev/null
            txt1_Telegram=" Alle Sicherungs-Dateien wurden am Sicherungsort gelöscht!!"
          elif [ "${HB_del_Sic}" = "1" ]; then
            msg "   (max. verbleiben ${HB_sic_Anzahl} Sicherungen am Sicherungsort)" "\t\t\033[0;33m"
            ## Sicherungshistorie bereinigen (Anzahl = Anzahl Historie+1)
            sudo ls -td ${HB_sic_Pfad}/*.tar.gz |tail -n +${HB_sic_Anzahl} |xargs rm -rf > /dev/null
            txt1_Telegram=" Die Sicherungs-Dateien wurden bereinigt !!"
          else
            txt1_Telegram=" Es werden keine Sicherungs-Dateien am Sicherungsort gelöscht!!"
          fi
        else
          txt1_Telegram=" Es sind keine Sicherungs-Dateien zum löschen am Sicherungsort vorhanden!!"
        fi
        msg "${txt1_Telegram}" $tFGelb
	  fi
	  if [ -n "${HB_bkp_Deconz_user}" ]; then
		[ -z "${HB_bkp_Deconz_ip}" ] && HB_bkp_Deconz_ip="127.0.0.1"
	    msg "Die deConz Einstellungen werden gesichert in: \"./.local/share/dresden-elektronik/deCONZ\" " $tFGelb
#	    log telegram nachricht!
	    ph -H ${HB_bkp_Deconz_ip} -u ${HB_bkp_Deconz_user} post /config/export
	  else
	    msg "Etwas fehlt,$tFGelb die Variable $tNormal\"HB_bkp_Deconz_user\"$tFGelb muss gesetzt sein!!" $tRot
	  fi
	  if [ -e ${toolDir}/hue_backup_restore ]; then
	    hue_config backup
	    RC=$?
		[ ${RC} != 0 ] && msg "Achtung!!\n$tFGelb Bei der Hue-Sicherung trat ein Fehler auf." $tRot
	  fi
	  if [ "${HB_sic_Name}" = "" ]; then
	    if ls ${HB_sic_Pfad}/*.tar.gz 1> /dev/null 2>&1; then		# nur wenn *.tar.gz existiert
	      msg "\033[0;33m\nDiese Sicherungs-Dateien existieren bereits:$tNormal"
	      sudo find ${HB_sic_Pfad}/*.tar.gz -exec echo {} \;
	    fi
	    msg "\nBitte den Namen der Sicherungs-Datei eingeben ! \n(Name ohne -01.tar.gz)" "\033[1;33m"
	    [ ${Date_SicName} = "2" ] && msg "\033[0;32m(Enter = ${formatDate}_homebridge-01.tar.gz)$tNormal" "\033[1;33m" 
	    [ ${Date_SicName} = "1" ] && msg "\033[0;32m(Enter = homebridge_${formatDate}-01.tar.gz)$tNormal" "\033[1;33m"
		[ ${Date_SicName} != "1" ] && [ ${Date_SicName} != "2" ] && msg "\033[0;32m(Enter = homebridge-01.tar.gz)$tNormal" "\033[1;33m"
	    read  -t 20 HB_sic_Name
	    [ "${HB_sic_Name}" = "" ] && HB_sic_Name="homebridge"
	  fi
	  [ ${Date_SicName} = "2" ] && HB_sic_Name=${formatDate}_${HB_sic_Name} 
	  [ ${Date_SicName} = "1" ] && HB_sic_Name=${HB_sic_Name}_${formatDate}
	  HB_sic_Name="${HB_sic_Name}-01"
	  if [ -e ${HB_sic_Pfad}/${HB_sic_Name}.tar.gz ]; then
	  	rotiere_bkp_file ${HB_sic_Pfad} ${HB_sic_Name} tar.gz
		HB_sic_Name="${bkp_Filename}"
	  fi
	  msg  "Die Sicherungs Config-Datei: $tFGelb${toolDir}/${hb_Backup_cfg}$tFGreen  wird gesucht." $tFGreen
	  if [ -e ${toolDir}/${hb_Backup_cfg} ]; then
	    msg  "Config-Datei: $tFGelb${toolDir}/${hb_Backup_cfg}$tFGreen existiert und wird benutzt, \nlese die zu sichernden Daten ein." $tFGreen
	    while read -r line
	    do
	      if echo "${line}" | grep -q '^#' ; then
	        msg "Kommentar: $tNormal$line$tFGreen wird nicht gesichert ($tFGelb ist auskommentiert$tFGreen )!" $tFGreen
		  elif echo "${line}" | grep -q '^!' ; then
		    dummy=""												# dummy befehl
	      else
	        msg "sichere Datei/Ordner: $tNormal$line" $tFGreen
	        sudo tar -rf "${HB_sic_Pfad}/${HB_sic_Name}.tar" /$line &> /dev/null
	        RC=$?
		    [ ${RC} -ne 0 ] && if_error "tar" ${RC} 16
	      fi
	    done < ${toolDir}/{$hb_Backup_cfg}
	    msg " Die Datei ${HB_sic_Pfad}/${HB_sic_Name}.tar wird jetzt gepackt!" $tFGelb
        gzip -f -9 "${HB_sic_Pfad}/${HB_sic_Name}.tar" &> /dev/null
        if [ "${SendTelegram}" == "1" ]; then  send_Telegram "HB_Sicherung vom: <b>$(date +%d.%m.%Y)</b>%0A${txt1_Telegram}%0A Es wurde eine Sicherung \"${HB_sic_Name}.tar.gz\" im Ordner \"${HB_sic_Pfad}/\" abgelegt!" ; fi
	  else
	    msg "Es wurde keine Sicherungs Config-Datei gefunden, starte jetzt die automatische Sicherung!" $tFGreen
	    msg "Wenn ein /homebridge bzw. /.homebridge Ordner gefunden wird, wird dieser gesichert!" $tFGelb
	    msg "\t\t (inkl. der Service-Dateien für die Dienste)" $tFGelb
	    daten_Dir=""
	    if [ -d /var/homebridge ]; then
	      daten_Dir=/var/homebridge
	    elif [ -e $HOME/.homebridge/config.json ]; then
	      daten_Dir=$HOME/.homebridge
	    else
	      msg "Es wurde kein \"homebridge\" Ordner gefunden!!" $tFRot
	      daten_Dir=""
	    fi
	    if [ "${daten_Dir}" != "" ]; then
	      msg "Der Ordner$tFGelb \"${daten_Dir}\"$tFGreen wurde gefunden!" $tFGreen
	      cd ${daten_Dir}
	      cd ..
	      if [ "${daten_Dir}" = "/var/homebridge" ]; then
	        sudo tar -cf "${HB_sic_Pfad}/${HB_sic_Name}.tar" ${daten_Dir}* &> /dev/null
	        RC=$?
	      else
	        sudo tar -cf "${HB_sic_Pfad}/${HB_sic_Name}.tar" ./.homebridge* &> /dev/null
	        RC=$?
	      fi
		  [ ${RC} -ne 0 ] &&  if_error "tar" ${RC} 16
	      msg "Das Sicherung von$tNormal ${daten_Dir}*$tFGelb wurde erstellt in$tNormal ${HB_sic_Pfad}/${HB_sic_Name}.tar.gz$tFGelb !" $tFGelb
#	       sudo tar -rPf "${HB_sic_Pfad}/${HB_sic_Name}.tar" /etc/systemd/system/homebridge* 	# -P = nur ab root entpackbar!!
	      msg " Die$tNormal Service-Dateien$tFGelb werden dem Image hinzugefügt!" $tFGelb
	      sudo tar -rf "${HB_sic_Pfad}/${HB_sic_Name}.tar" /etc/default/homebridge* &> /dev/null
	      sudo tar -rf "${HB_sic_Pfad}/${HB_sic_Name}.tar" /etc/systemd/system/homebridge* &> /dev/null
		  if [ -e "/etc/systemd/system/logwatch.timer" ]; then sudo tar -rf "${HB_sic_Pfad}/${HB_sic_Name}.tar"  /etc/systemd/system/logwatch.* &> /dev/null && msg " Dei Dateien zum$tNormal logwatch.timer$tFGelb wurden dem Image hinzugefügt!" $tFGelb ; fi
    	  if [ -e "/etc/systemd/system/reporter.service" ]; then sudo tar -rf "${HB_sic_Pfad}/${HB_sic_Name}.tar"  /etc/systemd/system/reporter.* &> /dev/null && msg " Dei Dateien zum$tNormal reporter.service$tFGelb wurden dem Image hinzugefügt!" $tFGelb ; fi
    	  if [ -e "/etc/systemd/system/fritzbox-reboot.timer" ]; then sudo tar -rf "${HB_sic_Pfad}/${HB_sic_Name}.tar"  /etc/systemd/system/fritzbox-reboot.* &> /dev/null && msg " Dei Dateien zum$tNormal fritzbox-reboot.timer$tFGelb wurden dem Image hinzugefügt!" $tFGelb ; fi
#	       if [ -e "${toolDir}/hbridge.cfg" ]; then sudo tar -rf "${HB_sic_Pfad}/${HB_sic_Name}.tar" ${toolDir}/hbridge.cfg &> /dev/null && msg " Die hbridge.cfg Datei wurde dem Image hinzugefügt!" $tFGelb ; fi
	      if [ -d "${toolDir}" ]; then sudo tar -rf "${HB_sic_Pfad}/${HB_sic_Name}.tar" ${toolDir}/* &> /dev/null && msg " Der Ordner $tNormal${toolDir}$tFGelb wurde dem Image hinzugefügt!" $tFGelb ; fi
    	  if [ -e "${toolDir}/hue_backup_restore" ]; then sudo tar -rf "${HB_sic_Pfad}/${HB_sic_Name}.tar"  ${HB_sic_Pfad}/${HB_hue_sic_Name}.json &> /dev/null && msg " HUE-Sicherungsdatei$tNormal ${HB_hue_sic_Name}.json$tFGelb wurden dem Image hinzugefügt!" $tFGelb ; fi
	      if [ -d "${HOME}/Desktop" ]; then sudo tar -rf "${HB_sic_Pfad}/${HB_sic_Name}.tar" ${HOME}/Desktop/* &> /dev/null && msg " Der Ordner $tNormal${HOME}/Desktop$tFGelb  wurde dem Image hinzugefügt!" $tFGelb ; fi
	      if [ -d "${HOME}/Documents" ]; then sudo tar -rf "${HB_sic_Pfad}/${HB_sic_Name}.tar" ${HOME}/Documents/* &> /dev/null && msg " Der Ordner $tNormal${HOME}/Documents$tFGelb wurde dem Image hinzugefügt!" $tFGelb ; fi
	      if [ -d "${HOME}/Downloads" ]; then sudo tar -rf "${HB_sic_Pfad}/${HB_sic_Name}.tar" ${HOME}/Downloads/* &> /dev/null && msg " Der Ordner $tNormal${HOME}/Downloads$tFGelb wurde dem Image hinzugefügt!" $tFGelb ; fi
	      msg " Die Datei $tNormal${HB_sic_Pfad}/${HB_sic_Name}.tar$tFGelb wird jetzt gepackt!" $tFGelb
          gzip -f -9 "${HB_sic_Pfad}/${HB_sic_Name}.tar" &> /dev/null
          RC=$? 
          [ -e ${HB_sic_Pfad}/${HB_sic_Name}.tar.gz ] && msg "$tFGelb Sicherung in die Datei$tNormal ${HB_sic_Pfad}/${HB_sic_Name}.tar.gz$tFGelb ist abgeschlossen." && sudo chmod 0664 ${HB_sic_Pfad}/${HB_sic_Name}.tar.gz
          [ ${RC} -ne 0 ] &&  if_error "gzip" ${RC} 16
          if [ "${SendTelegram}" == "1" ]; then  send_Telegram "HB_Sicherung vom: <b>$(date +%d.%m.%Y)</b>%0A${txt1_Telegram}%0A Es wurde eine Sicherung \"${HB_sic_Name}.tar.gz\" im Ordner \"${HB_sic_Pfad}/\" abgelegt!" ; fi
		  sudo chown -R root:users ${HB_sic_Pfad}/*.tar.gz >> /dev/null
        else
         if [ "${SendTelegram}" == "1" ]; then  send_Telegram "Es wurde leider nichts zum sichern gefunden!" ; fi
	      msg "Habe nichts zum sichern gefunden!!" $tFGreen
          exitCode="5"
	    fi
      fi
	  cd $HOME
	  umount_SicMedium ${HB_sic_Pfad}
	  RC=$?
	  [ ${RC} != 0 ] && if_error "umount_SicMedium" ${RC} -1
	;;
	
	restore)
      pattern="BREAK" 
      restore_para=
	  mount_SicMedium ${HB_sic_Pfad}
	  RC=$?
	  [ ${RC} != 0 ] && if_error "mount_SicMedium" ${RC} -1
	  msg "\033[0;33m\nDiese Sicherungs-Dateien wurden gefunden:$tNormal"
	  sudo find ${HB_sic_Pfad}/*.tar.gz -exec echo {} \; | more
	  cd ${toolDir}
	  msg "\nBitte den Namen der Sicherungs-Datei für das Restore eingeben ! \n(Name ohne .tar.gz)" "\033[1;33m" 
	  [ ${Date_SicName} = "2" ] && msg "\033[0;32m(Enter = ${formatDate}_homebridge-01.tar.gz)$tNormal" "\033[1;33m" && dummy1="${formatDate}_homebridge-01"
	  [ ${Date_SicName} = "1" ] && msg "\033[0;32m(Enter = homebridge_${formatDate}-01.tar.gz)$tNormal" "\033[1;33m" && dummy1="homebridge_${formatDate}-01"
	  [ ${Date_SicName} != "1" ] && [ ${Date_SicName} != "2" ] && msg "\033[0;32m(Enter = homebridge-01.tar.gz)$tNormal" "\033[1;33m" && dummy1="homebridge-01"
	  read  -t 20 dummy 
	  [ "$dummy" = "" ] && dummy=${dummy1}
  	  if [ -e ${HB_sic_Pfad}/${dummy}.tar.gz ]; then
	    msg "Es werden Dateien aus der Sicherung$tFGelb \"${HB_sic_Pfad}/${dummy}.tar.gz\"$tFGreen hergestellt." $tFGreen
	    inquire "Vorher nochmal anzeigen \033[0;32m(n) $tFGelb?" $tFGelb
        if [ "${answer}" = "y" ]; then
	      sudo tar -tzf ${HB_sic_Pfad}/${dummy}.tar.gz | more
	    fi
	    msg "\n Einzelene Datei Wiederherstellen, eingabe des Dateinamen oder mit\n$tFGreen (Enter)$tFGelb alle Dateien wieder herstellen, ($tFGreen q$tFGelb = Abbruch)!" $tFGelb
	    read name
	    if [ "${name}" = "" ] || [ "${name}" = "a" ]; then
	      msg1_Telegram="alle Dateien"
 		  msg "Es werden alle Dateien aus der Sicherung: $tFGreen${HB_sic_Pfad}/${dummy}.tar.gz$tFGelb wieder her gestellt!" $tFGelb   
	      if [ -e "${toolDir}/hbridge.cfg" ]; then sudo rename -f ${toolDir}/hbridge.cfg ${toolDir}/hbridge_old.cfg &> /dev/null && msg " Die vorhandene hbridge.cfg Datei wurde umbenannt in hbridge_old.cfg!" $tFGelb ; fi
#	       sudo tar -ztf "${HB_sic_Pfad}/${dummy}.tar.gz" -C /		# nur Viewer
	      sudo tar -zxf "${HB_sic_Pfad}/${dummy}.tar.gz" -C /
	      RC=$? 
	    elif [ "${name}" = "q" ]; then
	      exitCode="15"
	    else
	      msg1_Telegram="die Datei ${name}"
	  	  msg "Es wird $tFGreen${name}$tFGelb aus der Sicherung: $tFGreen${HB_sic_Pfad}/${dummy}.tar.gz$tFGelb wieder hergestellt!" $tFGelb
  	      if echo "${name}" | grep -q '^*' ; then
	        restore_para=--wildcards
          fi
#	       sudo tar ${restore_para} -C / -ztvf ${HB_sic_Pfad}/${dummy}.tar.gz "${name}"	# v = verbose # nur Viewer
	      sudo tar ${restore_para} -C / -zxvf ${HB_sic_Pfad}/${dummy}.tar.gz "${name}"	# v = verbose	
	      RC=$? 
	      msg "Jetzt werden die Service's aktiviert!" $tFGelb
	    fi
        [ ${RC} -ne 0 ] &&  if_error "tar" ${RC} 16
	    if [ "${name}" != "q" ]; then	  
	      cd /etc/systemd/system
	      sudo systemctl daemon-reload
#          sudo systemctl enable homebridge*
	      cd $HOME
	      if [ "${SendTelegram}" == "1" ]; then  send_Telegram "HB_Restore vom: $(date +%d.%m.%Y)%0A Es wurde aus der Sicherung-Datei%0A \"${HB_sic_Pfad}/${dummy}.tar.gz\"%0A ${msg1_Telegram} wieder hergestellt!" ; fi
	    fi
	  else
	    msg "Im Ordner $tFGelb\"${HB_sic_Pfad}/\"$tFGreen wurde die Datei $tFGelb\"${dummy}.tar.gz\"$tFGreen nicht gefunden!" $tFGreen
	  fi
	  umount_SicMedium ${HB_sic_Pfad}
	  RC=$?
	  [ ${RC} != 0 ] && if_error "umount_SicMedium" ${RC} -1
	;;

	plugin_list)
      pattern="BREAK"
	  msg "Liste der installierten Plugins, inkl.Version!$tNormal\n (\033[0m\033[33m\033[5m...Bitte warten! ⏳\033[0m)" $tFGreen
	  sudo npm list -g --depth=0
	  msg "Installierte Node.js Version!" $tFGreen
	  sudo node -v
#	   sudo npm -v
	  if [ -e "/usr/bin/deCONZ-autostart.sh" ]; then
	    msg "Es wurde gefunden:" $tFGreen
	    sudo dpkg -l deconz | grep deconz
	  fi
	  if [ "${hb_ServicesRestart}" != "0" ]; then
	    HB_Services start
	  fi
      exitCode="4"
	;;

	config)
      pattern="BREAK"
      if [ -e ${toolDir}/hbridge.cfg ]; then
        cat ${toolDir}/hbridge.cfg | more
      else
        create_ConfigFile
      fi
	;;

	swap)
      pattern="BREAK"
	  [ "${2}" = "list" ] || [ "${2}" = "-l" ] && pattern="swap_list" && continue 
	  if [ ! -e $HOME/.enable_swap ]; then
	    msg "Es wird eine SWAP Datei mit 1024MB eingerichtet." $tFGreen
	    if [ ! -e /etc/dphys-swapfile ]; then
	      msg "SWAP Support wird installiert." $tFGelb
	      sudo apt-get install dphys-swapfile
	    fi
	    sudo systemctl enable dphys-swapfile
	    sudo su -c 'echo "CONF_SWAPFILE=/var/swap" >> /etc/dphys-swapfile'
	    sudo su -c 'echo "CONF_SWAPSIZE=1024" >> /etc/dphys-swapfile'
	    sudo su -c 'echo "CONF_MAXSWAP=2048" >> /etc/dphys-swapfile'
	    sudo dphys-swapfile setup
	    sudo dphys-swapfile swapon
	    touch $HOME/.enable_swap
	  else
	    msg "Eine Swap Datei existiert schon." $tFGreen
	    inquire "SWAP-Datei Support entfernen \033[0;32m(n) $tFGelb?" $tFGelb
        if [ "${answer}" = "y" ]; then
          sudo service dphys-swapfile stop
          sudo systemctl disable dphys-swapfile
	      sudo dphys-swapfile swapoff
	      sudo dphys-swapfile uninstall
	      sudo /etc/init.d/dphys-swapfile stop
	      sudo update-rc.d dphys-swapfile remove
	      sudo apt-get purge dphys-swapfile
		  rm -rf $HOME/.enable_swap
		  rm -rf /etc/dphys-swapfile
	    fi
	  fi
#      pattern="swap_list"
	;&

	swap_list)
	  pattern="BREAK"
	  msg "aktuelle SWAP-Datei:" $tFGelb
 	  swapon -s
      read -t 10 -p "weiter mit Enter.."
      echo
	;;

	service_ctrl)
      pattern="BREAK"
	  ctrl_Services
	;;
	
	pi_clean|pcl)
      pattern="BREAK"
	  raspi_clean
	;;
	
	debug|deb)										# "$2"= cfg, raspiBackup, hbridge
	  pattern="BREAK"
      if [ -f ${toolDir}/$dbgFile ]; then
        dummy="${2}"
        [ "${dummy}" = "" ] && dummy="hbridge"
        . ${toolDir}/${dbgFile} 1 ${dummy}
      else
        msg "\n\tKonnte keine \"${toolDir}/${dbgFile}\" Datei finden!\n" $tFRot
      fi
      exitCode="17"
	;;

	mqtt|-mqtt)
      pattern="BREAK"	
	  Mqtt_Broker
	;;
		
	*)
      pattern="BREAK"
      [ "${HB_sic_Name}" = "" ] && HB_sic_Name="homebridge"
	  msg " (Die ${Anwendung} läuft auf einem: ${Distri}-System)" "\t\t\033[0;33m"
      if [ -f ${toolDir}/${configFile} ]; then msg " (Die Datei: \"${configFile}\" wurde gefunden und eingelesen)" "\t\t\033[0;33m"; fi
	  [ ! -z "${PID_mm2}" ] && msg " (Die Datei: \"${fkt_mm2}\" wurde gefunden und eingelesen)" "\t\t\033[0;33m"
	  if [ "${SendTelegram}" == "1" ]; then msg " (Benachrichtigung per \"Telegram\" ist aktiviert)" "\t\t\033[0;33m"; fi
	  msg "\n\033[0;33mBenutze:\033[1;37m $0\033[0;35m [update {npm/node} | remove | install | plugin {-l (list)} | service {-c (ctrl) |\n\t\t\t\t -i (install) | -r (remove) {npm-check} | -l (list)} | service {start/stop/restart} |\n\t\t\t\t cam | deconz {-r (remove)} | wait2deconz | reboot | restart | backup | restore |\n\t\t\t\t swap {-l (list)} | config | debug {hbridge/cfg} | pi_clean | -mqtt  | -npm (npm-check) |\n\t\t\t\t -daschboard (dashboard) | -hue {-i/-d/-b/-r} | ? ]$tNormal"
      msg " \033[0;32mmögl. Eingaben sind:"
	  msg " y | Y | yes | YES | j | J | ja | Ja,"
      msg " n | N | no | NO | nein | Nein,"
	  msg " bei Enter wird immer \033[0;32m()\033[0m genommen!! $tNormal\n"
      msg "\033[0;33mHinnweis:$tNormal Support mehrere Instanzen (\033[1;37mServices$tNormal) für die \033[0;33m\"homebridge\"$tNormal wird unterstützt. \n\t  Beim ersten Aufruf von \033[1;37mservice$tNormal wird die standard Instanz \033[0;33m\"homebridge\"$tNormal eingerichtet."
	  msg "\t$tNormal  Ab dem zweiten Aufruf von \033[1;37mservice$tNormal können weitere Instanzen angelegt werden.$tNormal\n\t  Verzögertes starten einer Instanz kann mit \033[0;35mwait2deconz$tNormal eingerichtet werden."
	  msg "\n\033[0;33mmögl. Parameter:"
	  msg "\033[0;35m-u (update)\t$tNormal - aktualisiert RasPi/Debian Pakete und Kernel"
	  msg "\033[0;35m-u (update) node$tNormal - aktualisiert das Node.js auf die letzte aktuelle Version"
	  msg "\033[0;35m-u (update) node ${stab_nodeVersion}$tNormal - aktualisiert das Node.js auf Version: ${stab_nodeVersion}"	  
	  msg "\033[0;35m-u (update) npm$tNormal  - aktualisiert das npm Paket auf die letzte aktuelle Version"
	  msg "\033[0;35m-u (update) npm ${stab_npmVersion}$tNormal  - aktualisiert das npm Paket auf die Version: ${stab_npmVersion}"
	  msg "\033[0;35m-u (update) node npm $tNormal - aktualisiert erst node (latest) und dann npm (latest))"	
	  msg "\033[0;35m-u (update) -d\t$tNormal - update deConz (latest)"
	  msg "\033[0;35m-r (remove)\t$tNormal - entfernt alle Instanzen, homebridge, node, npm und Plugins, nicht die config.json"
	  msg "\033[0;35m-r (remove) npm-check\t$tNormal - entfernt das Plugin \033[0;33m\"npm-check\"$tNormal "
	  msg "\033[0;35m-i (install)\t$tNormal - installiert node, npm, homebridge, links und notwendige tools"
	  msg "\033[0;35m-i (install) AirPlay$tNormal - Erstinstallation support für AirPlay Lautsprecher auf Basis von forked-daapd"
	  msg "\033[0;35m-p (plugin)\t$tNormal - liest die zu installierenden Plugins aus der"
	  msg "\t Datei: ${toolDir}/${pluginFile} ein"
	  msg "\t (siehe Bsp-Datei: hbridge_plugin-example.inst)"
	  msg "\t (\033[0;33m#\033[0m am Zeilenanfang, kommentiert das Plugin aus)"
	  msg "\t (\033[0;33m@\033[0m am Zeilenanfang, installiert Plugin aus dem web/git)"
	  msg "\t (\033[0;33m@2.1.0\033[0m am Ende vom Pluginname, installiert Plugin in dieser Version)"
	  msg "\033[0;35m-p (plugin) -l (list)$tNormal  - Anzeige aller installierten Plugins (inkl.Version)"
	  msg "\033[0;35m-s (service)$tNormal - installiert den homebridge-Dienst, ab dem 2ten Aufruf werden weitere\n\t  Instanzen eingerichtet (\033[0;33m\"/etc/default/homebridge\"$tNormal muss vorhanden sein)\n\t (inkl. Abfrage: -selective Plugin laden, -standalone config-ui-x)"
	  msg "\033[0;35m-s (service) -i (install) \033[0;33mInstanzName$tNormal - installiert einen Dienst mit dem Namen \033[0;33m\"homebridge-InstanzName.service\"$tNormal" $tNormal
	  msg "\033[0;35m-s (service) -c (ctrl)$tNormal - erstellen/löschen von Services die das System kontrollieren"$tNormal
      msg "\033[0;33m\t reporter.service$tNormal - überwachen der Services und bei Ausfall, Nachricht per Telegram möglich" $tNormal
      msg "\033[0;33m\t logwatch.timer$tNormal - Systemstatus, Systemupdate Pluginupdate prüfen, Nachricht per Telegram möglich" $tNormal
      msg "\033[0;33m\t fritzbox-reboot.timer$tNormal - Fritz-Box und/oder Fritz-Repeater geplant neu starten, Nachricht per Telegram mögl." 
	  msg "\033[0;35m-s (service) -r (remove)$tNormal - löschen von homebridge-Instanzen, inkl. standalone config-ui-x Instanz (wenn vohanden)"
	  msg "\033[0;35m-s (service) -r (remove)$tNormal  \033[0;33mInstanzName$tNormal - löscht eine homebridge-Instanz, (\033[0;33m\"hue\"$tNormal = homebridge-hue.services)"
	  msg "\033[0;35m-s (service) -l (list/status)$tNormal - Anzeige der eingerichteten Homebridge- und Ctrl-Instanzen"
	  msg "\033[0;35m-s (service) start/stop/restart$tNormal - alle installierten Instanzen re-starten/stoppen (inkl. der Ctrl-Instanzen)"
#	  msg "\033[0m\t\t\t\t (ausser den \"deconz*\" und \"mqtt\" Instanzen s.u., oder deconz_service=\"\" setzen)$tNormal"
	  msg "\033[0;35m-s (service) start/stop/restart \033[0;33mInstanzName$tNormal - eine Instanz \033[0;33m\"InstanzName\"$tNormal re-starten/stoppen"
	  msg "\033[0;35m\t -s (service) stop\033[0;33m nuki\t$tNormal - stoppt die Instanz $tGelb\"homebridge-nuki.service\"$tNormal"
	  msg "\033[0;35m\t -s (service) start/stop/restart\033[0;33m mosquitto (mqtt)$tNormal - start/stop/restart'e die Instanz $tGelb\"mosquitto.service\"$tNormal"
	  msg "\033[0;35m\t -s (service) start/stop/restart\033[0;33m deconz (deconz-gui)$tNormal - start/stop/restart'e diese Instanz$tNormal"
	  msg "\033[0;35m-d (deconz)\t$tNormal - deCONZ für Raspbian oder Debian installieren/updaten (starten als Dienst oder X11 Anwendung)"
	  msg "\033[0;35m-d (deconz) -r (remove)\t$tNormal - deCONZ-Paket für Raspbian oder Debian deinstallieren"
	  msg "\033[0;35m-d (deconz) -s (service)$tNormal - den start von deCONZ einrichten (X11/Dienst)"
	  msg "\033[0;35m-wd (wait2deconz)\t$tNormal  - Verzögerung beim start'en/reboot'en der Dienste einrichten/entfernen"
	  msg "\033[0;35m-hue\t -i\t\t$tNormal - installieren der benötigten Tools zur sicherung der HUE-Bridge"
	  msg "\033[0;35m\t -d\t\t$tNormal - deinstallieren der benötigten Tools"
	  msg "\033[0;35m\t -b\t\t$tNormal - backup  HUE-Bridge konfiguration sichern ($tGelb${HB_hue_sic_Pfad}/${HB_hue_sic_Name}.json$tNormal)"
	  msg "\033[0;35m\t -r\t\t$tNormal - restore  HUE-Bridge konfiguration wieder herstellen"
	  read -t 15 -p "weiter mit Enter.."
	  echo ""
	  msg "\033[0;35mcam\t$tNormal - Kamera am CamPort (nur Raspberry) aktivieren, vorher (sudo raspi-config -> 5 -> P1 + reboot) ausführen"
#	   msg "\033[0;35mlistdev\t$tNormal - anzeigen der aktuellen Devices zum ermitteln des Sicherungs-Device" "\033[1;35m"
	  msg "\033[0;35mreboot\t$tNormal - startet den RasPi/Debian neu"
	  msg "\033[0;35mrestart\t$tNormal - alle homebridge-Instanzen (Dienste) beenden und neu starten"
	  msg "\033[0;35mrestart \033[0;33mInstanzName$tNormal - Instanz $tGelb\"homebridgeInstanzName.service\"$tNormal beenden und neu starten"
	  msg "\033[0;35m\t restart\033[0;33m nuki\t$tNormal - beendet und startet die Instanz $tGelb\"homebridge-nuki.service\"$tNormal neu"
	  [ ${Date_SicName} = "1" ] && HB_sic_Name="${HB_sic_Name}_Datum" 
	  [ ${Date_SicName} = "2" ] && HB_sic_Name="Datum_${HB_sic_Name}"	# für Aanzeige
	  msg "\033[0;35mbackup\t$tNormal - liest (wenn vorhanden) die $tGelb\"${toolDir}/${hb_Backup_cfg}\"$tNormal ein und sichert die\n\t Dateien/Ordner die in dieser Datei angegeben wurden. Falls nicht vorhanden, wird der\n\t Homebridge-Datenordner gesucht und gesichert. Die Service-Dateien, hbridge.cfg und\n\t hbridge_plugin.inst sowie (wenn vorhanden) $HOME/Desktop, $HOME/Documents und\n\t $HOME/Downloads werden mit gesichert.\n\t Die Variablen HB_sic_Device, HB_sic_Pfad, HB_sic_Name, HB_sic_Anzahl, Date_Format, Date_SicName\n\t in der cfg-Datei beachten.\n\t Sicherungsdatei: $tGelb\"${HB_sic_Pfad}/${HB_sic_Name}-01.tar.gz\""
	  msg "\033[0;35m\t backup del\t$tNormal - alle Sicherungsdateien löschen, danach Sicherung durchführen"
	  msg "\033[0;35m\t backup nodel\t$tNormal - keine Sicherungsdateien löschen, danach Sicherung durchführen"
	  msg "\033[0;35m\t backup\t\t$tNormal - $((HB_sic_Anzahl-1)) alte +  aktuelle Sicherungsdateien bleiben erhalten, einstellbar in \"Backup_Anzahl=3\""
	  msg "\n\033[0;35mrestore\t$tNormal - rücksichern einer(aller) Dateien aus der Datei: $tGelb\"${HB_sic_Pfad}/${HB_sic_Name}-01.tar.gz\""
	  msg "\033[0;35mswap\t$tNormal - erstellen/entfernen einer SWAP-Datei: $tGelb\"/var/swap\"$tNormal (von 1024MB bis 2048MB)"
	  msg "\033[0;35mswap -l (list) $tNormal - anzeigen der aktuellen SWAP-Datei"
	  msg "\033[0;35mconfig\t$tNormal - anzeige/erstellen einer minimalen config Datei in: $tGelb\"${toolDir}/${configFile}\""
	  msg "\033[0;35mdebug\t$tNormal - anzeige von Debug Info's aus der Datei: $tGelb\"${toolDir}/${dbgFile}\""
	  msg "\033[0;35mdebug hbridge\t$tNormal - anzeige von Debug Info's für die Datei: $tGelb\"${MYSELF}\""
##	  msg "\033[0;35mdebug raspiBackup\t$tNormal - anzeige von Debug Info's für die Datei: $tGelb\"raspiBackup.sh\""
	  msg "\033[0;35mdebug backup\t$tNormal - anzeige von Debug Info's für die Datei: $tGelb\"raspiBackup.sh\""
	  msg "\033[0;35mdebug cfg\t$tNormal - anzeige der Datei: $tGelb\"${toolDir}/${configFile}\""
	  msg "\033[0;35m-dashboard (dashboard)$tNormal - in-/deinstall dashboard, zur Anzeige eines Homebridge-Dashbord beim SSH-Login,\n\t\t\t (installiert npm-check wenn nötig)$tNormal"
	  msg "\t\t\t Es wird die aktuelle Version von $tGreen\"https://github.com/Nastras/homebridge-dashboard\"$tNormal\n\t\t\t runtergeladen und installiert"
	  msg "\033[0;35m-npm (npm-check)$tNormal - startet $tGelb\"npm-check\"$tNormal für Plugin Updates, (installiert npm-check wenn nötig)"	  
	  msg "\033[0;35m-mqtt \t\t$tNormal - de-/installiere MQTT-Broker für das Plugin $tGelb\"homebridge-camera-ui\"$tNormal"	  
	  msg "\033[0;35mpi_clean\t$tNormal - RaspBerry von Ballast befreien (Pakete/Logs löschen u.s.w.)$tNormal\n" "\033[0;35m"
	  msg "\033[1;33mmögliche Kurzbefehle für Parameter/Optionen:\t$tGelb\"${MYSELF} Parameter Option (InstanzName)\""
	  msg "$tNormal Parameter\t\t Option"
	  msg "\033[0;35m-u = update\t\t -l = list"
	  msg "\033[0;35m-r = remove\t\t -i = install"	  
	  msg "\033[0;35m-i = install\t\t -r = remove"
	  msg "\033[0;35m-p = plugin\t\t -c = ctrl"
	  msg "\033[0;35m-s = service"	  
	  msg "\033[0;35m-d = deconz"
	  msg "\033[0;35m-dashboard"
	  msg "\033[0;35m-hue = hue (-i/-d/-b/-r)"
	  msg "\033[0;35m-npm = mpm-check"
	  msg "\033[0;35m-mqtt = mqtt"
	  msg "\033[0;35m-h(?) = Hilfe"
	  read -t 15 -p "weiter mit Enter.."
	  echo ""
	  msg "\033[1;33mHinnweis zu den Variablen:"	  
	  msg " (in der Datei:$tGelb \"${toolDir}/${configFile}\"$tNormal)"
	  msg "\033[1;37m  SendTelegram=0\t\t\033[0m keine Benachrichtigung via \"Telegram\" vom User \"pi\" senden" "\033[0m"
	  msg "\033[1;37m  TToken_hbridge_new= \t\033[0m den Telegram-API Token eintragen" "\033[0m"
	  msg "\033[1;37m  TChat_ID_hbridge_new=\t\033[0m die Telegram Chat-ID für den \"bot Chat\" eintragen" "\033[0m"
	  msg "\033[1;37m  TeleAnhang= \t\t\033[0m eine Datei die per Telegram gesendet werden soll" "\033[0m"
	  msg "\033[1;37m  TelePhoto=\t\t\033[0m ein Bild das per Telegram gesendet werden soll" "\033[0m"
	  msg "\033[1;37m  Logfile=\"\"\t\t$tNormal aktiviert das loggen in eine Datei (verzögert die Anzeige etwas) bzw. \"journal\" in syslog" "\033[0m"
      msg "\033[1;37m  hb_ServicesRestart=\t$tNormal 1=starten/stoppen, 0= nicht starten/stoppen der homebridge Dienste"
	  msg "\033[1;37m  Distri=\"\"\t\t$tNormal das aktuelle System festlegen, \"Raspbian\" für Raspberry oder \"Debian\" für Debx86" "\033[0m"
      msg "\033[1;37m  Restart_Services=\"\"\t welche Services beendet/gestartet/restartet werden (=\"reporter deconz homebridge\")" "\033[0m"
      msg "\033[1;37m  Date_Format=\"Jahr\"\t Datumformat \"Tag\"=09122019, \"Jahr\"=20191209, \"Monat\"=12092019" "\033[0m"
      msg "\033[1;37m  Date_SicName=\"0\"\t 0=Name, 1=Name+Date_Format, 2=Date_Format+Name, Format des Namen für die Sicherungsdatei" "\033[0m"
      msg "\033[1;37m  HB_hue_ip=\"\"\t\t IP-Adresse der Hue, kann aus der Plugin config.json genommen werden" "\033[0m"
      msg "\033[1;37m  HB_hue_api=\"\"\t\t API-Key, aus der Plugin config.json von \"users\" der Teil nach dem :\"ApiKey\"" "\033[0m"
      msg "\033[1;37m  HB_hue_sic_Pfad=\"\"\t\t Pfad für HUE-Sicherung (wenn leer: \"$HOME/hbridge_install\")" "\033[0m"
      msg "\033[1;37m  HB_hue_sic_Name=\"\"\t Name der HUE-Sicherungsdatei, \"\"=\"hue_sic\" -01.json wird autom. angefügt\n" "\033[0m"
	  msg "als letzte stabile Version hat sich erwiesen:"
	  msg "- Node: ${stab_nodeVersion}"
	  msg "- NPM: ${stab_npmVersion}"
	  msg "- homebridge: ${stab_hbVersion}"
	  msg "- deConz (Raspberry): ${stab_deCONZVersion}\t akt. Vers. siehe: \033[0;33m${www_deconz_raspian}/$tNormal"
	  msg "- deConz (Debian)...: ${stab_deCONZVersionDeb}\t akt. Vers. siehe: \033[0;33m${www_deconz_ubuntu}/$tNormal"
	  msg ""
	  if [ "${hb_ServicesRestart}" != "0" ]; then
	    HB_Services start
	  fi
      exitCode="1"
	;;

esac

done

	if [ "${hb_ServicesRestart}" != "0" ]; then
	  inquire "Die HomeBridge-Dienste jetzt starten \033[0;32m(j) $tNormal" $tFGelb
	  if [ "${answer}" = "" -o "${answer}" = "y" ]; then
	    HB_Services start
	  fi
	fi
	cd $HOME
	
#chmod -R 0777 /var/homebridge*
#chmod -R 0666 /var/homebridge*/*.*
#chown -R homebridge:users ./homebridge*/*.*

exit ${exitCode}


