#!/bin/bash
#set -x
#set -e
#
## ============================================================
#                  User Variablen
# in der Datei: /home/UserName/hbridge_install/hbridge.cfg festlegen
## ============================================================
#
# Author: det (@SmartApfel Forum)
Version="0.4.14"
#
grep -iq debug <<< "${Version}"			# debug version?
is_Debug=$((! $? ))						# "debug" in "$Version" = 1
[ "${is_Debug}" -eq 1 ] && set -x
#
# Mit diesem Script kann man:
#  - Das komplette Raspberry/DebianX86 System in einer IMG-Datei sichern.
#      Mit oder ohne beenden (Batch Modus) der homebridge Instanzen.
#      Diese wird auf einem USB-Stick bzw. NAS gesichert.
#      Wenn gewünscht,ist im Anschluss das packen (shrinking) des Image möglich. (kein Support für NOOB-Image)
#  - einstellbare Anzahl der IMG-Datei die auf dem Backupmedium verbleiben sollen
#  - das Backupmedium mounten/umounten
#  - Anzeige der .img-, .log-, .txt- Dateien und freien Speicher auf dem Backupmedium 
#  - Benachrichtigung via Telegram möglich
#  - KommentarDatei.txt anlegen zur BackupDatei.
#
#    Beschreibung siehe "/home/UserName/hbridge_install/raspiBackup.sh ?"
# 
#  Default mässig wird das Script über die Datei: "/home/UserName/hbridge_install/hbridge.cfg" konfiguriert.
#  Bei Benutzung ohne cfg-Datei, sind die folgenden Variablen zu setzen und am Zeilenanfang das "#" entfernen !!
#
########################################################################################################################
#			Anfang Configuration			   	 		raspiBackup.sh											   	   #	
########################################################################################################################
#Distri="Raspbian" 					# "no"= keine Überprüfung, "Raspbian" für RaspBerri oder "Debian" für x86 System
#Logfile="" 						# kein mit loggen, in einer Datei oder journal
#SendTelegram="0" 					# 1= über Telegram API benachrichtigen, 0= keine Nachricht senden
#Restart_Services=""				# Services die beendet/gestartet werden soll, Service-Name eintragen "reporter deconz-gui" usw.
#									# "deconz-gui mosquitto" wenn diese Service beendet/gestartet werden soll
#
#Boot_Device="" 					# Das Boot-Device eintragen (Achtung ohne Ziffer, "sda", "sdb")
#Backup_Device=""					# hier das Sicherungs-Device eintragen (\"\dev\sda1\", \"\dev\sdc1\" oder \"192.168.6.68:/volume1\")
#Backup_Pfad=""					    # Backup Ziel ("" = /mnt/USB_Device) oder z.B. "/home/UserName/hbridge_install" eintragen
#Backup_Anzahl="3" 					# 2 alte Backups bleiben erhalten +1 (aktuelle Backup)
#Del_Img="1" 						# 0= nichts löschen "nodel", 1= max. AnzBackup-1 Img bleiben auf dem Stick, 2= alle Img löschen "del"
#DispSicTime="1"					# Anzeige der Uhrzeit vor und nach der Sicherung/Shrinking 1= an, 0= aus
#Run_Batch="0" 						# 1= Batch-Modus an, 0= Batch-Modus aus
#image_Name="" 						# Dateiname der Sicherungsdatei vorgeben (das Datum, wird autom. angefügt)
#Date_Format="Jahr"					# Datumformat "Tag"=09122019, "Jahr"=20191209, "Monat"=12092019
#Date_SicName="1"					# 0=Name_(Date_Format), 1=(Date_Format)_Name; Format des Namen der Sicherungsdatei
#gzImage="0"						# 0 = disable, zip/gz = im Anschluss wird die img-Datei gepackt (*.img.zip/*.img.gz)
#Backup_txt="0"						# 1 = eine Kommentar-Datei zum Backup anlegen (Bestätigung mit Enter notwendig!)
#KommentarZeilen="5"				# Anzahl der Zeilen für den Kommentar
#Backup_Log=0						# 1= mini Log-Datei zum Backup mit erstellen
#TToken_raspiBackup=				# Token für Telegram API
#TChat_ID_raspiBackup=				# CHAT ID für Telegram bot Chat
########################################################################################################################
#			Ende Configuration						   	raspiBackup.sh											   	   #	
########################################################################################################################
# History:
# 0.4.14 =  BugFix ${}, shrink BugFix
# 0.4.13 = Date_Format, final, BugFix img_name
# 0.4.12 = img_Name (intern), Date_SicName=1 Name_Date.tar.gz, 1 = Date_Name.tar.gz, BugFix, maxSicTag, formatDate, Date_Format, -nz
# 0.4.11c = Code cleaning, *.log last komprimieren
# 0.4.11 = ext_Array= Array für mögliche Datei Extensionen (log. txt, img, gz, zip), BugFix -l
# 0.4.10 = Variable Restart_Services, ""=Instanzen werden gesucht, "deconz homebridge"=diese Dienste beim Backup beenden/starten
# 0.4.9 = reporter.service first-stop / last-start
# 0.4.8d = BugFix (Backup Bereinigung)
# 0.4.8 = zip/gz und unzip (Parameter: -unpack/unpack) gzImage="0" (zip/gz
# 0.4.6 = Variable "deconz_service" eingeführt
# 0.4.5 = BugFix restart Service
# 0.4.4 = start/stop deconz
# 0.4.3 = BugFix 
# 0.4.2b =  BugFix [ "${ (Namensbildung)
# 0.4.2 = gzImage einbau zip-Datei erstellen
# 0.4.0 = anpassung send Telegram
# 0.3.9 = selftest remove, modified in warning
# 0.3.8 = -s = shrink, Shrink handling
# 0.3.6 = Code cleaning, BugFix, -l = list
# 0.3.5 = dbg Info, hilfe Info angepasst,view *.log und *.txt bei "list"
# 0.3.3 = inkl. selftest, BugFix
# 0.3.2 = cleaning, BugFix Telegram shrink
# 0.3.1d = Systemlinks angepasst
# 0.3.1c = anpassungen prints
# 0.3.1b = cleaning help
# 0.3.1 = shrink umstellen
# 0.3.0 = Code cleaning, Parameter Abfrage geändert
# 0.2.9b = debug, "free" Anzeige *.log und *.txt
# 0.2.9a = Sicherungsdauer
# 0.2.9 = Variablen testen/setzen (stand alone)
# 0.2.8b = [img mount/umount]
# 0.2.8 = send_Telgram geändert
# 0.2.7a = bug remove *.img behoben, mini Log erstellen
# 0.2.7 = mountPoint rechte, BugFix, (rm *.img), format
# 0.2.6a = BugFix
# 0.2.6 = prüfen ob Backup_Pfad bereits gemounted ist, dann kein unmount
# 0.2.5c = von whoami zu $HOME
# 0.2.5a = Script prüfung, $(whoami)
# 0.2.5 = Code cleaning, push ABBRUCH
# 0.2.4e = mount error - ABBRUCH
# 0.2.4b = Kosmetik, Variablen BackupDevice, BackupPoint
# 0.2.4 = umount /media/pi/*
# 0.2.3 = Backup.txt, Variablen anpassen
# 0.2.2 = Variablen anpassen, $HOSTNAME im Telegram
# 0.2.0 = umstellung auf hbridge.cfg
# 0.1.8 = Telegram per API
# 0.1.7 = Code cleaning, NOOBS Hinnweis
## ============================================================
# -- Exit Codes --
#  exit 0 = exit normal 
#  exit 1 = exit from help, ?
#  exit 2 = exit from free, list
#  exit 4 = exit from mount
#  exit 5 = exit from umount
#  exit 6 = exit from listdev
#  exit 7 = exit from ntfy install
#  exit 8 = exit Distri nicht ermittelt
#  exit 9 = exit "debug" Info anzeigen
#  exit 10 = exit bei mount error
#  exit 11 = exit no User pi
#  exit 12 = exit Stick formatieren erfolgreich
#  exit 13 = exit ABBRUCH formatieren
#  exit 14 = exit ABBRUCH curl installieren
#  exit 15 = exit mount/umount image
#  exit 16 = exit ABBRUCH Image mount
#  exit 254 = no USB Stick found
#
## ============================================================
## Variablen
## ============================================================
#
# !! Platz auf dem Backupmedium beachten!!
# es wird eine Kopie von dem Image auf dem Backupmedium erstellt
#
# Nur mit der zusätzlichen Datei pishrink.sh möglich. 
# von hier: https://github.com/Drewsif/PiShrink, oder im Tool-Packet enthalten.
Shrink_Image="0"                        # 0= Image nicht shrinken, 1= Image shrinken
#Skip_Autoexpand="false"                # true = kein autom. erweitern des Filsystem nach dem Restore
Skip_Autoexpand=""						# autom. erweitern des Filsystem nach dem Restore -> abfragen
## ============================================================
# Konstanten
## ============================================================
#!!Backup_Pfad="/mnt/${USB_Device}" -> wird nach ermitteln von "$USB_Device" gesetzt!!
StopHB_Serv="1"                         # 0= Dienste sind gestoppt, 1= Dienste laufen, beim Script start
#toolDir=/home/$(whoami)/hbridge_install
toolDir=$(dirname "$(readlink -e "$0")")
#toolDir=$HOME/hbridge_install          # Tools Ordner
configFile="hbridge.cfg"       			# config Dateiname (RaspBerry)
dbgFile="hbridge.dbg"					# Debug-Info Dateiname
helpFile="hbridge.hlp"					# Hilfe Dateiname
USB_Label=                              # USB-Stick Label
USB_Device=                             # angestecktes USB Device (RaspBerry)
med_IsMounted=0			    			# Medium ist beim Start bereits gemounted, 1= kein umount
#ext_Array=( img log txt ${gzImage} )	# mögliche Datei extensionen
ext_Array=( img log txt )				# mögliche Datei extensionen
maxSicTag=5								# maximale Anzahl der Sicherungen pro Tag
rc=0									# return Code
#Date_Format="%d%m%Y"						# Datumsformat %d%m%Y=29122019, %Y%m%d=20191229
#formatDate=$(date +$Date_Format})			# Datumsformat +%d%m%Y=29122019, +%Y%m%d=20191229

MYSELF=${0##*/}							# ScriptName.sh
MYNAME=${MYSELF%.*}						# ScriptName
#MYPID=$$
#
tRot="\033[0;31m"
tGelb="\033[0;33m"
tBlue="\033[0;36m"
tGreen="\033[0;32m"
tFGelb="\033[1;33m"
tFMagenta="\033[1;35m"
tFBlue="\033[1;36m"
tFGreen="\033[1;32m"
tFRot="\033[1;31m"
tFWithe="\033[1;97m"
tNormal='\033[0m'
tFNormal="\033[1;37m"
#
## ============================================================
# Funktionen
## ============================================================

function set_Config (){												# prüfen ob "Variablen gesetzt ist, wenn nein -> setzen!
#    if [ -z ${var+x} ]; then echo "var is unset"; else echo "var is set to '${var}'"; fi
	msg "\nHinweis!! Keine cfg-Datei gefunden.\n$tFGreen Bei nicht gesetzten Variablen werden jetzt die Standardwerte gesetzt!" $tFGelb
	[ -z ${Distri+x} ] && Distri="Raspbian" && msg "Distri=${Distri}" $tNormal
	[ -z ${Logfile+x} ] && Logfile="" && msg "Logfile=${Logfile}" $tNormal
	[ -z ${SendTelegram+x} ] && SendTelegram="0" && msg "SendTelegram=${SendTelegram}" $tNormal
	[ -z ${Restart_Services+x} ] && Restart_Services= && msg "Restart_Services=${Restart_Services}" $tNormal 
	[ -z ${Date_SicName+x} ] && Date_SicName="1" && msg "Date_SicName=${Date_SicName}" $tNormal
	[ -z ${Date_Format+x} ] && Date_Format="Jahr" && msg "Date_Format=${Date_Format}" $tNormal
	[ -z ${Boot_Device+x} ] && Boot_Device="" && msg "Boot_Device=${Boot_Device}" $tNormal
	[ -z ${Backup_Device+x} ] && Backup_Device="" && msg "Backup_Device=${Backup_Device}" $tNormal
	[ -z ${Backup_Pfad+x} ] && Backup_Pfad=""	&& msg "Backup_Pfad=${Backup_Pfad}" $tNormal
	[ -z ${Backup_Anzahl+x} ] && Backup_Anzahl="3" && msg "Backup_Anzahl=${Backup_Anzahl}" $tNormal
	[ -z ${Del_Img+x} ] && Del_Img="1" && msg "Del_Img=${Del_Img}" $tNormal
	[ -z ${DispSicTime+x} ] && DispSicTime="1" && msg "DispSicTime=${DispSicTime}" $tNormal
	[ -z ${Run_Batch+x} ] && Run_Batch="0" && msg "Run_Batch=${Run_Batch}" $tNormal
	[ -z ${image_Name+x} ] && image_Name="" && msg "image_Name=${image_Name}" $tNormal
	[ -z ${gzImage+x} ] && gzImage="0" && msg "gzImage=${gzImage}" $tNormal
	[ -z ${Backup_txt+x} ] && Backup_txt="0" && msg "Backup_txt=${Backup_txt}" $tNormal
	[ -z ${KommentarZeilen+x} ] && KommentarZeilen="5" && msg "KommentarZeilen=${KommentarZeilen}" $tNormal
	[ -z ${Backup_Log+x} ] && Backup_Log=0 && msg "Backup_Log=${Backup_Log}" $tNormal
	[ -z ${Shrink_Image+x} ] && Shrink_Image="0" && msg "Shrink_Image=${Shrink_Image}" $tNormal
	[ -z ${Skip_Autoexpand+x} ] && Skip_Autoexpand=true && msg "Skip_Autoexpand=${Skip_Autoexpand}" $tNormal
	[ -z ${TToken_raspiBackup+x} ] && TToken_raspiBackup= && msg "TToken_raspiBackup=${TToken_raspiBackup}" $tNormal
	[ -z ${TChat_ID_raspiBackup+x} ] && TChat_ID_raspiBackup= && msg "TChat_ID_raspiBackup=${TChat_ID_raspiBackup}" $tNormal
    sleep 9
}

function backup_log (){												# $1= Text für LOG-Datei
  echo -e "${1}" >> ${Backup_Pfad}/${image_name}.log
}

function HB_Services (){											# $1 = restart/start/stop
  local action=$1													# Action für Service
  local PID_HB=`pidof homebridge`
  local tk="${action}e"												# Text korrektur
  local service_name=$2												# ServiceName
  local Service_Array=( ${Restart_Services[@]} )					# Array mit Servicenamen füllen
  
  [ "${action}" == "stop" ] && tk="${action}pe"
   
  if [ "${service_name}" != "" ]; then
    if [ "${service_name}" = "mosquitto" ] || [ "${service_name}" = "mqtt" ]; then
	  msg "${tk} das Programm:$tNormal ${service_name}" $tFGelb
	  sudo /etc/init.d/mosquitto $action &
	else
  	  msg "${tk} den Dienst:$tNormal ${service_name}" $tFGelb
	  sudo systemctl ${action} ${service_name} 
	fi  
	return 1
  fi
  if  [ ! -z "${Service_Array[0]}" ]; then							# nur wenn Arry nicht leer ist
	for service_name in ${Service_Array[@]} ;do						# service = Dienst aus Service_Array
	  if [ "${service_name}" = "mosquitto" ] || [ "${service_name}" = "mqtt" ]; then
	    msg "${tk} das Programm:$tNormal ${service_name}" $tFGelb
	  	sudo /etc/init.d/mosquitto ${action} &
	  	[ "${tk}" = "starte" ] || [ "${tk}" = "restarte" ] && msg "($tRot ACHTUNG!!$tNormal Nach dem neu starten, die Cam's neu starten. Damit diese sich wieder mit dem Dienst verbinden können!)" $tNormal
	  else
	  	msg "${tk} den Dienst:$tNormal ${service_name}" $tFGelb
	    sudo systemctl ${action} ${service_name} &
	  fi
	  sleep 1
	done
    return 1
  fi
  if [ -n "$PID_HB" ] && [ "${action}" = "start" ]; then
    msg "Die Homebridge läuft schon mit der ID:\033[1;33m${PID_HB}$tNormal und kann nicht noch einmal gestartet werden!!\n" 
  elif [ -z "${PID_HB}" ] && [ "${action}" = "stop" ]; then
    msg "Die Homebridge kann nicht gestoppt werden, da sie aktuell nicht läuft!!\n" 
  else
  	[ "${action}" == "stop" ] && [ -e /etc/systemd/system/reporter.service ] && sudo systemctl ${action} reporter.service && msg "${tk} den Dienst:$tNormal reporter.service" $tFGelb
 	[ -e /etc/systemd/system/multi-user.target.wants/deconz-gui.service ] && sudo systemctl ${action} deconz-gui.service && msg "${tk} den Dienst:$tNormal deconz-gui.service" $tFGelb
	[ -e /etc/systemd/system/multi-user.target.wants/deconz.service ] && [ -L /etc/systemd/system/multi-user.target.wants/deconz.service ] && sudo systemctl ${action} deconz.service && msg "${tk} den Dienst:$tNormal deconz.service" $tFGelb
	[ -e /etc/init.d/mosquitto ] && msg "!! Benutze:$tNormal \"$MYSELF -s ${action} mqtt\"$tFGreen um das Programm \"mosquitto\" neu zu startetrn !!" $tRot
# 	if [ -e /etc/init.d/mosquitto ]; then
#  	  sudo /etc/init.d/mosquitto $action 
#  	  msg "$tk$tNormal das Programm:$tFGelb mosquitto$tNormal" $tFGelb
#  	  [ "${tk}" = "starte" ] || [ "$tk" = "restarte" ] && msg "($tRot ACHTUNG!!$tNormal Nach dem neu starten, die Cam's neu starten. Damit diese sich wieder mit dem Dienst verbinden können!)" $tNormal
#  	fi
	if [ -e /etc/default/homebridge ]; then
      for i in /etc/systemd/system/homebridge*.service ;do
        [ ! -f "${i}" ] && continue
	  # Alle Zeichen inkl. dem letzt möglichen "/" werden von Links entfernt. 	
	    service_name=${i##*/} 
	    msg $tk" den Dienst:$tNormal $service_name" $tFGelb
	    sudo systemctl ${action} ${service_name} &
	    sleep 1
      done
	  [ -e /etc/systemd/system/logwatch.timer ] && sudo systemctl ${action} logwatch.timer && msg "${tk} den Dienst:$tNormal logwatch.timer" $tFGelb
	  [ -e /etc/systemd/system/fritzbox-reboot.timer ] && sudo systemctl ${action} fritzbox-reboot.timer && msg "${tk} den Dienst:$tNormal fritzbox-reboot.timer" $tFGelb
    elif [ -e /etc/init.d/homebridge ]; then
      sudo /etc/init.d/homebridge ${action}
      msg " ${tk} Homebridge als Programm!" $tFGelb
    else
      msg "Keinen Autostart von Homebridge gefunden!"
    fi
	[[ "${action}" =~ "start" ]] && [ -e /etc/systemd/system/reporter.service ] && sudo systemctl ${action} reporter.service && msg "${tk} den Dienst:$tNormal reporter.service" $tFGelb			# enthält "start"
  fi
}

function send_Telegram(){			  								# $1 = message to send
  local a
  
  command -v curl >/dev/null 2>&1 || { msg "[Abbruch] bitte curl installieren!"; exit 14; }
  if [ "${SendTelegram}" != "1" ] || ( [ "${TChat_ID_raspiBackup}" == "" ] || [ "${TToken_raspiBackup}" == "" ] ); then
    [ "${SendTelegram}" != "1" ] && msg "Benachrichtigung mit Telegram nicht erlaubt" $tRot
    ( [ "${TChat_ID_raspiBackup}" == "" ] || [ "${TToken_raspiBackup}" == "" ] ) &&  msg "Die Variablen \"TToken_raspiBackup\" und \"TChat_ID_raspiBackup\" sind nicht gesetzt !" $tRot
  else
#    a=$(curl -s -X POST https://api.telegram.org/bot${TToken_raspiBackup}/sendMessage -d chat_id="${TChat_ID_raspiBackup}" -d text="Nachricht von $HOSTNAME: $1" 2>&1)
	a=$(curl -s -X POST "https://api.telegram.org/bot${TToken_raspiBackup}/sendMessage" --data "disable_notification=true" -d chat_id="${TChat_ID_raspiBackup}" -d "parse_mode=html" -d "text=<b>Nachricht von $HOSTNAME:</b>%0A${1}" 2>&1)
    if [[ "$a" =~ "error" ]]; then
      msg "\n\t Abbruch es trat eine Fehler auf!! " $tFRot
      msg " Error:$tFGelb $a \n$tNormal\t Es wurde keine Nachricht gesendet!\n" $tFGreen
    else
      if [ "${TelegramAnhang}" != "" ]; then curl -s -X POST  https://api.telegram.org/bot${TToken_raspiBackup}/sendDocument -F chat_id="${TChat_ID_raspiBackup}" -F document=@"${TelegramAnhang}" >/dev/null 2>&1; fi
      if [ -n "${TelegramPhoto}" ]; then curl -s -X POST  https://api.telegram.org/bot${TToken_raspiBackup}/sendPhoto -F chat_id="${TChat_ID_raspiBackup}" -F photo=@"${TelegramPhoto}" >/dev/null 2>&1; fi
    fi
  fi
}

function msg(){  													# $1=message to logging and console, $2=farbattribut
    local text=$1
    local attr=$2
  	local date_string=`date +'%Y-%m-%d %H:%M:%S'`

  	echo -e "${attr}${text} \033[0m"
  	if [ "${Logfile}" == "journal" ]; then 
      echo "${text}" | systemd-cat -t "raspiBackup"
  	elif [ -n "${Logfile}" ]; then 
	  echo -e "${date_string} ${text}" | sudo tee -a ${Logfile} >> /dev/null
  	fi
}

function Pi_Shrink() {   											# $1 = Dateiname vom Image
    local SourceImage_Name=$1
    
    msg " Support für internes shrinken kommt noch!\n" $tFGelb
}

function shrink_Image() {    										# $1 = Dateiname vom Quell-Image
    local SourceImage_Name=$1										# Name zu shrinkendes Source-Image
    local DestImage_Name="${SourceImage_Name}_shrink"				# Name des geshrinkten Destination-Image
    local dummy
    local dat_diff													# Zeitdauer
    local dat														# akt. Zeit
    local dat_run=`date +%s`										# start Zeit
    
    if [ -e ${toolDir}/pishrink.sh ]; then 
      msg "\t  Das Image ${SourceImage_Name}.img wird jetzt gekürzt!!" $tFRot
      dat=`date +%T`    
      if [ "${DispSicTime}" = "1" ]; then msg "Shrinking gestartet..:\033[0m ${dat}" "\033[0;32m"; fi
      [ "${Backup_Log}" = "1" ] && backup_log " Shrinking gestartet..: ${dat}"    
      if [ "${SendTelegram}" = "1" ]; then send_Telegram "Shrinking, gestartet um ${dat}"; fi
      if [ "${Skip_Autoexpand}" != "false" ] && [ "${Skip_Autoexpand}" != "true" ]; then 
        msg "Das Filesystem nach der Wiederherstellung autom. erweitern? \033[0;32m [j/n] (n)\n" $tFGelb
        read -n1 -t 10 dummy
        if [ "${dummy}" == "n" ] || [ "${dummy}" == "" ]; then
		  Skip_Autoexpand="true"
        else
          Skip_Autoexpand="false" 
        fi        
      fi
      [ "${is_Debug}" -eq 1 ] &&  msg "Quell_Image_Name=${SourceImage_Name}" && msg "Shrink_image_Name=${DestImage_Name}"
      if [ "${Skip_Autoexpand}" != "true" ]; then
        DestImage_Name="${SourceImage_Name}_AutoRestore"
        msg "Das Filesystem wird nach der Wiederherstellung autom. erweitert.\n" $tFGreen
		[ "${Backup_Log}" = "1" ] && backup_log "Das Filesystem wird nach der Wiederherstellung autom. erweitert."
        sudo bash -c "${toolDir}/pishrink.sh ${SourceImage_Name}.img ${DestImage_Name}.img"
      else
        DestImage_Name="${SourceImage_Name}_shrink"
        msg "Das Filesystem wird nach der Wiederherstellung$tFRot NICHT$tFGreen autom. erweitert.\n" $tFGreen
		[ "${Backup_Log}" = "1" ] && backup_log "Das Filesystem wird nach der Wiederherstellung NICHT autom. erweitert."
	    sudo bash -c "${toolDir}/pishrink.sh -s ${SourceImage_Name}.img ${DestImage_Name}.img"
      fi    
      dat_diff=$(( ($(date +%s) - $dat_run) / 60 ))					# = Shrinkdauer
      dat=`date +%T`
      [ "$Backup_Log" = "1" ] && backup_log " shrinke ${SourceImage_Name}.img zu $DestImage_Name.img"
      if [ "$DispSicTime" = "1" ]; then msg "Shrinking beendet...:\033[0m $dat\n\033[0;32m Shrinkdauer:........:\033[0m ${dat_diff}\033[0;32m min" "\033[0;32m"; fi
      [ "$Backup_Log" = "1" ] && backup_log "Shrinking beendet...: $dat" 
      [ "$Backup_Log" = "1" ] && backup_log "Shrinkdauer.........: ${dat_diff} Minuten"
      if [ "$SendTelegram" = "1" ]; then send_Telegram "Das Shrinken von ${SourceImage_Name}.img%0A zu ${DestImage_Name}.img%0A wurde beendet und hat ${dat_diff} min gedauert.%0A"; fi
      [ -f "${SourceImage_Name}.log" ] && sudo cp -f ${SourceImage_Name}.log ${DestImage_Name}.log
#if [ $? -eq -1 ]; then  # exit code abfrage
#  echo -e "falscher Aufruf!!"
#  exit -1
#elif [ $? -eq -2 ]; then
#  echo -e "Datei: $1.img existiert nicht!!" >&2
#  exit -2
#elif [ $? -eq -3 ]; then
#  echo -e "Bitte das Script als root starten!!" >&2
#  exit -3
#elif [ $? -eq -4 ]; then
#  echo -e "parted ist nicht installiert!!" >&2
#  exit -4
#elif [ $? -eq -5 ]; then
#  echo -e "Kann Datei nicht kopieren!!" >&2
#  exit -5
#else
#  echo -e "No ERRORs found !"
#  exit 0
#fi
    else
      msg " Abbruch!! \033[0;33mdie Datei \033[0;32m$1.img \033[0;33mwurde \033[1;31mnicht\033[0;33m gekürzt!!" $tFGelb
      msg " Die Datei \"pishrink.sh\" ist nicht vorhanden, bitte von hier: https://github.com/Drewsif/PiShrink herunterladen!!\n" "\033[0;33m"
    fi
}

function is_Mounted() { 											# $1=MountPoint, return rc
	local mount_Point=$1
	local mes
	
	if [[ -n "${mount_Point}" ]]; then
	  mes=$(sudo grep "${mount_Point}" /proc/mounts)
	  if [ -n "${mes}" ]; then
	    rc=1
		med_IsMounted=1												# Medium ist gemounted
	  else
	  	rc=0
	  	med_IsMounted=0												# kein Medium gemounted
	  fi 	
	else
	  rc=2
	  msg "kein MountPoint angegeben!!"
	fi
	return "$rc"
}

function mount_BackupMedium() {										# $1 = off, keine Warnung ausgeben (Batchmodus), return rc
    local dummy														# key input
#	local rc														# rc = Return ErrorCode global
    local rc2
    local msg_off=$1
    
    if [ -e /sbin/mkfs.ntfs ]; then 
      [ "${msg_off}" != "off" ] && msg " Support für NTFS (max 16TB) ist bereits installiert." $tFGelb
    elif [ -e /sbin/mkfs.exfat ]; then
      [ "${msg_off}" != "off" ] && msg " Support für exFAT (max 512TB) ist bereits installiert." $tFGelb
    else
      msg " Support für NTFS (max 16TB)\033[0m (n) $tFGelboder" $tFGelb
      msg " Support für exFAT (max 512TB) installieren? \033[0;32m(x)\n" $tFGelb
      read -n1 -t 10 a
      if [ "${dummy}" == "n" ]; then
        sudo apt-get install ntfs-3g -y
        msg " Support für NTFS wurde installiert." $tFGelb
      else
        sudo apt-get install exfat-fuse exfat-utils -y
        msg " Support für exFAT wurde installiert." $tFGelb
      fi
    fi
#	sudo apt-get remove ntfs-3g -y
#	sudo apt-get remove exfat-fuse exfat-utils -y
    is_Mounted ${Backup_Pfad}
    if [ "${rc}" = "1" ]; then
      [ "${msg_off}" != "off" ] && msg " \"${Backup_Pfad}\" ist bereits gemounted." $tFGelb
	elif [ "${rc}" = "2" ]; then
      return "$rc"
    else
      if [ ! -e ${Backup_Pfad} ]; then
        msg " Mountpoint ${Backup_Pfad} für Backup wurde angelegt!" $tFGelb
        sudo mkdir ${Backup_Pfad} 1> /dev/null 2>&1
        sudo chown -R homebridge:users ${Backup_Pfad}
        sudo chmod -R 0777 ${Backup_Pfad}
      else
        [ "${msg_off}" != "off" ] && msg " Der MountPoint existiert bereits." $tFGelb
      fi 
      sudo mount ${Backup_Device} ${Backup_Pfad} 1> /dev/null 2>&1
      rc2=$?
      if [ ${rc2} != 0 ]; then  
        msg "$tFRot ABBRUCH!! $tFGelb mounten fehlgeschlagen\n" $tFGelb 
        if [ "${SendTelegram}" = "1" ]; then send_Telegram "%0A<b>ABBRUCH!!</b>%0A Das mounten des Backupmedium ist fehlgeschlagen." ; fi   
        exit 10
      else
        msg " Das Backupmedium \"${Backup_Device}\" wurde im MountPoint:\"${Backup_Pfad}\" geladen!"  $tFGelb
      fi
    fi
    if [ "${msg_off}" != "off" ]; then
      msg " Das Backupmedium \033[0;33m${Backup_Device}\033[0;33m ist im Ordner: \033[0;33m${Backup_Pfad}\033[0m sichtbar." "\n\033[0m"
      msg " Das Backupmedium vor dem entfernen unmount'en, mit $tNormal\"umount\"\033[1;31m!!!\n" "\n\t\033[1;31m"
    fi
}

function umount_BackupMedium() {									# $1 = off, keine Warnung ausgeben (Batchmodus)
    local msg_off=$1
    local i=1
    
	if [ "${med_IsMounted}" = "0" ]; then
      msg "\n ..Bitte warten!!! ⏳" $tNormal  
      while [ "${i}" != "11" ]; do									# max. 10 Versuche
		sleep 2 
        sudo umount ${Backup_Pfad} 1> /dev/null 2>&1
        is_Mounted ${Backup_Pfad}
        [ "${rc}" = "0" ] && break
   		msg "Umount schlug fehl bei Versuch: ${i}" $tRot
   		i=`expr $i + 1`
      done
      if [ -d /media/pi/${USB_Label} ]; then
        sudo umount /media/pi/${USB_Label} 1> /dev/null 2>&1
        [ "${msg_off}" != "off" ] && msg "Das Backupmedium wurde auch unter \"/media/pi/${USB_Label}\" entladen!" $tNormal
      fi
      sleep 2
#      sudo rm -d  ${Backup_Pfad}
#      msg " Mountpoint ${Backup_Pfad} für Backup wurde gelöscht!" $tFGelb
      [ "${msg_off}" != "off" ] && msg "Das Backupmedium kann jetzt entfernt werden!\n" "\n\t\033[1;31m"
    else
      msg " Das Backupmedium bleibt unter \"${Backup_Pfad}\" gemounted!\n" $tFRot
    fi
}

function list_Device() {
    local dummy
    
    msg "\nBitte erst ohne den Sicherungs-Sick starten und Device in die Tabelle merken.\n\t(die vorhandenen Devices sda1, sdb1,sdc1 merken)\n" $tFGelb
    sudo lsblk
    msg "Jetzt den Sicherungs-Stick anstecken! (10sec warten, dann weiter mit Enter) \c" $tFGelb
    read dummy
    sudo lsblk
    msg "Das neue Device in obiger Liste in die Variable \n\033[1;37m Backup_Device=\"\"$tFGelb eintragen. (\dev\sda1, \dev\sdb1, \dev\sdc1..)(mit einem Linux-Editor)" $tFGelb
    msg "Das Device welches /boot enthällt bei\n\033[1;37m Boot_Device=\"\"$tFGelb eintragen. (Achtung ohne Ziffer!!)" $tFGelb
    msg "\n$tFGreen Beispiel vorgehen:\n\033[0m In einer SSH-Konsole eingeben: \033[1;37m\"vi ${toolDir}/${configFile}\"\n\033[0m mit den Kursor Tasten zu den Variablen gehen und das Device eintragen."
    msg "\033[1;37m Backup_Device=\"\dev\sdc1\"" 
    msg "\033[1;37m Boot_Device=\"sda\"\n\033[0m Editor beenden und speichern mit der Eingabe: \033[1;37m\":wq\""
}

function txtFile_Backup(){
  	local fin=1														# 0= beenden
  	local txt_array													# array für Text der Textdatei
  	local i
  	
  	if [ -e ${Backup_Pfad}/${image_name}.txt ]; then
      msg "Die Datei: \033[0m${image_name}.txt "$tFGelb"existiert bereits und wird umbenannt \n in: \033[0m${Backup_Pfad}/${image_name}-2.txt" $tFGelb
      [ -e "${Backup_Pfad}/${image_name}-2.txt"  ] && sudo rm -fr ${Backup_Pfad}/${image_name}-2.txt
      sudo mv -f ${Backup_Pfad}/${image_name}.txt ${Backup_Pfad}/${image_name}-2.txt
  	fi
  	msg "Erstellen einer Backup Kommentar-Datei \"${Backup_Pfad}/${image_name}.txt\"" $tFGreen

  	while [ -n "$fin" ]; do
      touch ${Backup_Pfad}/${image_name}.txt
      echo "Datum: $(date +%Y-%m-%d_%H:%M:%S)" >> ${Backup_Pfad}/${image_name}.txt
      msg "\033[0;33mBitte die Version eingeben:\033[0m \c"
      read version
      echo "Version: $version" >> ${Backup_Pfad}/${image_name}.txt
      echo "Distribution: $Distri" >> ${Backup_Pfad}/${image_name}.txt
      echo "Backupname: ${image_name}.img" >> ${Backup_Pfad}/${image_name}.txt
      echo ""  >> ${Backup_Pfad}/${image_name}.txt
      echo "Kommentar:" >> ${Backup_Pfad}/${image_name}.txt
      msg "\033[0;33mDu kannst hier Deine Änderungen kommentieren.\n\033[0m\t (in ${KommentarZeilen} Zeilen, je mit Enter bestätigen)"
      typeset -i i=0
      while [ $i -lt ${KommentarZeilen} ]
        do
        read txt_array[$i]
        i=i+1
      done
      # Ausgabe
      printf "%s\n" "${txt_array[@]}" >> ${Backup_Pfad}/${image_name}.txt
      clear
      msg "\033[1;32mDie Kommentar-Datei ${image_name}.txt wurde erstellt!\n\033[0;33mHier der Inhalt der der Datei:\033[0m\n"
      cat ${Backup_Pfad}/${image_name}.txt
      msg "\n\033[1;32mDiese Kommentar Datei übernehmen? \033[0m\n(übernehmen mit Enter)$tNormal\n" 
      read  fin
      if [ "$fin" = "" ]; then
        msg "Backup Kommentar-Datei wurde erstellt!" $tNormal
   	    continue 
   	  fi
      clear
      rm -rf ${Backup_Pfad}/${image_name}.txt
      msg "\033[1;32mDie Kommentar-Datei wurde wieder gelöscht, es wird eine neue erstellt!"
	done
}

function format_Stick() { 											# $1=Device, return rc
  	local U_Device=$1
  	local dev_Device=${U_Device%?}									# letze Zeichen abschneiden
  	local U_Label
  	
  	if [ ! -e /sbin/mkfs.exfat ]; then
      sudo apt-get install exfat-fuse exfat-utils -y
      msg " Support für exFAT wurde installiert." $tFGelb
  	fi
  	is_Mounted ${Backup_Pfad}
  	if [ "${rc}" != "1" ]; then
      msg "Das Device: $tFGelb\"${U_Device}\"$tNormal wird entladen." $tNormal
      sudo umount ${U_Device}
  	fi
  	msg "Formatieren (nur exFAT), setzen des Datenträger-Namen und der Clustergröße auf 1MB ! (Enter=Abbruch)\n(Achtung!! alle Daten werden gelöscht)" $tFGreen
  	msg "Gib den Name für den Datenträger ein: \c" $tFGelb
  	read U_Label
  	if [ "${U_Label}" != "" ]; then
      sudo fdisk ${dev_Device} <<EOF
d
n
p
1


t
7
w
EOF
	  msg "formatiere ${U_Device}..."
      sudo mkfs.exfat -n "${U_Label}" -s 2048 ${U_Device} >> /dev/null
      sleep 2
#      read -p "weiter mit Enter.." 
      msg "\nName des Datenträger:$tFGelb \"`lsblk -n -o label ${U_Device}`\"" $tFGreen
      sudo fsck ${U_Device}
      rc=12
    else
      msg "$tFRot ABBRUCH!! $tFGelb formatieren von ${U_Device} wurde abgebrochen\n" $tFGelb 
      rc=13
    fi
  	if [ "$med_IsMounted" = "1" ]; then
      msg "\nDas Device: $tFGelb\"${U_Device}\"$tNormal wird wieder gemounted." $tNormal
      sudo mount ${U_Device} ${Backup_Pfad} >> /dev/null
      med_IsMounted=0
  	fi
  	return $rc
}

function unpack (){	  												# unpack zip-Image
	local dat=`date +%T`											# akt. Uhrzeit
	local dat_run=`date +%s`										# Startzeit
	local dat_diff													# = Komprimierungsdauer
	local dummy
	local ext=".zip/.img.zip/.img.gz"								# extension

	mount_BackupMedium off
    msg " Das Backupmedium ist im Ordner: \033[0;33m${Backup_Pfad}\033[0m sichtbar." "\n\033[0m"
  	msg "\033[0;33m\nDiese komprimierten Images wurden gefunden:$tNormal" 
#  	if [ "${ext}" = ".img.zip/.img.gz" ]; then
	  sudo find ${Backup_Pfad}/*.zip -exec echo {} \; | more
	  sudo find ${Backup_Pfad}/*.gz -exec echo {} \; | more
#	else
#	  sudo find ${Backup_Pfad}/*${ext} -exec echo {} \; | more
#	fi
	msg "\nDen Namen der Datei eingeben ! \n(Dateiname ohne ${ext})\n\033[0;32m(Enter = ${BACKUP_NAME}_${formatDate})$tNormal" "\033[1;33m"
	read -t 10 dummy
	[ "$dummy" = "" ] && dummy=${BACKUP_NAME}_${formatDate}
	[ -e ${Backup_Pfad}/${dummy}.zip ] && ext=".zip"
	[ -e ${Backup_Pfad}/${dummy}.img.zip ] && ext=".img.zip"
	[ -e ${Backup_Pfad}/${dummy}.img.gz ] && ext=".img.gz"
  	if [ -e ${Backup_Pfad}/${dummy}${ext} ]; then
  	  cd ${Backup_Pfad}
#  	  image_Name="${dummy}"
  	  # Alle Zeichen inkl. dem ersten "_" werden von rechts entfernt.
##  	  image_Name=${image_Name%_*}
#	  [ ${Date_SicName} = "2" ] && image_Name=${image_Name#*_} || image_Name=${image_Name%_*}
  	  [ "${Backup_Log}" = "1" ] && backup_log " Entpacken gestartet..: ${dat}"
	  if [ "${DispSicTime}" = "1" ]; then msg " Entpacken von \033[0m${Backup_Pfad}/${dummy}${ext}\033[0;32m gestartet:\033[0m $dat" "\n\033[0;32m"; fi
  	  msg " nun sehr lange warten... ⏳\033[0m" $tFGelb
  	  if [ ${ext} = ".img.gz" ]; then
        gunzip -c ${Backup_Pfad}/${dummy}${ext} > ${Backup_Pfad}/${dummy}.img
      elif [ ${ext} = ".img.zip" ] || [ ${ext} = ".zip" ]; then
        unzip ${Backup_Pfad}/${dummy}${ext} > /dev/null
      fi
  	  dat=`date +%T`
  	  dat_diff=$(( ($(date +%s) - $dat_run) / 60 ))					# = Komprimierungsdauer
  	  if [ "${DispSicTime}" = "1" ]; then msg " Entpacken von\033[0m ${Backup_Pfad}/${dummy}${ext}\033[0;32m wurde beendet: \033[0m $dat" "\n\033[0;32m"; fi
   	  [ "${Backup_Log}" = "1" ] && backup_log " Entpacken beendet...: ${dat}"
      [ "${Backup_Log}" = "1" ] && backup_log " Entpackungsdauer....: ${dat_diff} Minuten\n Image: \"${Backup_Pfad}/${dummy}${ext}\" wurde entpackt."
    else
      msg "Eine Datei$tNormal ${Backup_Pfad}/${dummy}${ext}$tFGelb existiert nicht!\033[0m" $tFGelb
	fi
	cd $toolDir
    umount_BackupMedium off
}

function image (){	  												# $1 = mount/umount
  	local dummy
  	local sektor	
  	local dez
  	local para="$1"													# mount/umount

  	if [ "$para" == "mount" ]|| [ "$para" == "" ]; then
      mount_BackupMedium off
      msg " Das Backupmedium ist im Ordner: \033[0;33m${Backup_Pfad}\033[0m sichtbar." "\n\033[0m"
  	  msg "\033[0;33m\nDiese Images wurden gefunden:$tNormal"
	  sudo find ${Backup_Pfad}/*.img -exec echo {} \; | more
	  cd $toolDir
	  msg "\nBitte den Namen des Image eingeben ! \n(Dateiname ohne .img)\n\033[0;32m(Enter = Standard+heute)$tNormal" "\033[1;33m"
	  read dummy
	  [ "$dummy" = "" ] && dummy=${BACKUP_NAME}_${formatDate}
  	  if [ -e ${Backup_Pfad}/${dummy}.img ]; then
  	    sudo mkdir /mnt/image >> /dev/null
	    sudo fdisk -l ${Backup_Pfad}/${dummy}.img
	    msg "\nBitte die Zahl eingeben von Zeile/Spalte:\n Zeile: $tFGelb${Backup_Pfad}/${dummy}.img2\n$tFGreen Spalte:$tFGelb Start" $tFGreen
	    read sektor
	    [ "${sektor}" == "" ] && msg " ABBRUCH!! \n$tNormal(Eingabe falsch)$tNormal" $tFRot && exit 16
	    dez=$((${sektor}*512))
#	     echo "dez=$dez"  
	    msg "Mounte das Image ${Backup_Pfad}/${dummy}.img im Ordner /mnt/image." $tNormal
	    sudo mount ${Backup_Pfad}/${dummy}.img -o offset=${dez} /mnt/image
	    msg "\nMan kann jetzt auf den Inhalt des Image's unter \"/mnt/image\" zugreifen.\n\t\t$tFRot Nicht vergessen!! \n$tNormal Das Image mit $tFGelb\"raspiBackup.sh img umount\"$tNormal wieder entladen!!" $tFGelb
      else
        msg "Das ${Backup_Pfad}/${dummy}.img Image existiert nicht!" $tFGelb
	  fi
  	elif [ "${para}" == "umount" ]; then
	  sudo umount /mnt/image 1> /dev/null 2>&1
      sudo rmdir /mnt/image 1> /dev/null 2>&1
      msg " Das Image unter \033[0;33m\"/mnt/image\"\033[0m wurde entladen." "\n\033[0m"
      umount_BackupMedium off
      msg " Das Backupmedium im Ordner: \033[0;33m${Backup_Pfad}\033[0m wurde entladen." "\n\033[0m"
  	else
      msg "Benutze:$tNormal $0 [mount|umount]" $tFGreen
  	fi
#    exit 15
}

function list_typ_dir (){											# Ordner nach Dateityp durchsuchen und anzeigen
	local typ=$1													# Dateiendung
	local pfad=$2													# Pfad der Dateien
	local list_File=$3												# 1=Datei anzeigen
	local dummy
	local i
	local error=0													# !=0 -> Error anzeigen
	local file														# gefundener Dateiname
	
	if [ "${list_File}" != "1" ]; then
      dummy=$(ls -lah1 ${pfad}/*.${typ} 2>/dev/null | grep -c ".${typ}")
	  if [ ${dummy} -gt 0 ]; then   
        msg " Im Ordner \"${pfad}\" wurden folgende \"*.${typ}\" Dateien gefunden:" "\033[0;33m"
        sudo ls -lah1 ${pfad}/*.${typ}
	  else
	    error=1
	  fi
#	elif [ "${list_File}" = "1" ]; then
	else
      dummy=$(ls -lah1 ${pfad}/*.${typ} 2>/dev/null | grep -c ".${typ}")
	  if [ ${dummy} -gt 0 ]; then
        msg " Im Ordner \"${pfad}\" wurden folgende \"*.${typ}\" Dateien gefunden:" "\033[0;33m"
        sudo ls -lah1 ${pfad}/*.${typ}
		for file in $(ls ${pfad}/*.${typ}); do
		  msg " \n Diese Datei jetzt anzeigen?\033[0m\n $file \033[0;32m[j/n/q] (n) \c" "\033[0;33m"
   		  read -n1 -t 9 dummy
   		  echo -e "\033[0m"
   		  if [[ ${dummy} =~ ^[JjYy]$ ]]; then
    		[[ ${typ} = *gz ]] && sudo zcat ${file} | more || sudo cat ${file} | more		# Anzeige
     	  elif [ "${dummy}" == "q" ]; then
     	    break													# Abbruch
   		  fi
		done
#	  elif [[ ${dummy} =~ ^[qQ]$ ]]; then
#		break
	  else
	    error=1
	  fi
	fi
	[ "${error}" != 0 ] && msg "\n SORRY,\033[0;33m im Ordner \"${pfad}\" wurden keine \"*.${typ}\" Dateien gefunden!!" "$tRot" 
}

function clean_file_typ1 (){											# clean DateiTyp $1 = log/img/txt/gz/zip
	local typ=$1													# /home/pi/hbridge_install/file/*.log
	local files=(${Backup_Pfad}/*.${typ})
	local files2=(${Backup_Pfad}/*-2.${typ})
	local rc=1														# Fehler vor definiert
	local ext
	
	if [ ${#files[@]} -gt 1 ]; then
	  if [ "${typ}" = "${gzImage}" ]; then
		for ext in ${ext_Array[@]}; do								# Array mit benutzten Dateierweiterungen
	      files2=(${Backup_Pfad}/*-2.${ext}.${typ})					# Array mit -2.erw.zip/gz
		  if [ ${#files2[@]} -gt 1 ]; then							# mehr als eine Datei
#		  	echo -e "files2=$files2"
	        sudo ls -td ${Backup_Pfad}/*-2.${ext}.${typ} | tail -n +${Backup_Anzahl} | xargs rm -rf > /dev/null	
	      fi
	      files2=(${Backup_Pfad}/*.${ext}.${typ})					# Array mit erw+zip/gz
		  if [ ${#files2[@]} -gt 1 ]; then							# mehr als eine Datei
#	      	echo -e "files2=$files2"
	        sudo ls -td ${Backup_Pfad}/*.${ext}.${typ} | tail -n +${Backup_Anzahl} | xargs rm -rf > /dev/null		    
	      fi
	    done
	  else
	    files2=(${Backup_Pfad}/*-2.${typ})					# Array mit -2.erw.zip/gz
		if [ ${#files2[@]} -gt 1 ]; then							# mehr als eine Datei
#	      echo -e "files3=$files2"
          sudo ls -td ${Backup_Pfad}/*-2.${typ} | tail -n +${Backup_Anzahl} | xargs rm -rf > /dev/null
	    fi
	    files2=(${Backup_Pfad}/*.${typ})					# Array mit erw+zip/gz
		if [ ${#files2[@]} -gt 1 ]; then							# mehr als eine Datei
#	      echo -e "files3=$files2"
          sudo ls -td ${Backup_Pfad}/*.${typ} | tail -n +${Backup_Anzahl} | xargs rm -rf > /dev/null
	    fi
      fi
      rc=0														# kein Fehler
    fi
	[ "$rc" == "0" ] && msg " ${typ}-Dateien wurden bereinigt !!" $tGelb
	return $rc
}


function clean_file_typ (){											# clean DateiTyp $1 = log/img/txt/gz/zip
	local typ=$1													# /home/pi/hbridge_install/file/*.log
	local files=(${Backup_Pfad}/*.${typ})
	local rc=1														# Fehler vor definiert

	shopt -s nullglob dotglob     									# To include hidden files
	if [ ${#files[@]} -gt 0 ]; then 
#	  echo -e "summe= ${#files[@]} typ=${Backup_Pfad}/*.${typ}"
      sudo ls -td ${Backup_Pfad}/*.${typ} | tail -n +${Backup_Anzahl} | xargs rm -rf > /dev/null
      rc=0															# kein Fehler
    fi
	[ "$rc" == "0" ] && msg " ${typ}-Dateien wurden bereinigt !!" $tGelb
	return $rc
}

function clean_file_typ2 (){										# clean DateiTyp $1 = log/img/txt/gz/zip
	local typ=$1													# /home/pi/hbridge_install/file/*.log
	local files
	local rc=1														# Fehler vor definiert

	for files in ${Backup_Pfad}/*.${typ}; do
	  if [ -f ${files} ]; then
	    echo -e "files=${files}"
        sudo ls -td ${Backup_Pfad}/*.${typ} | tail -n +${Backup_Anzahl} | xargs rm -rf > /dev/null
        rc=0														# kein Fehler
      fi
	done
	[ "$rc" == "0" ] && msg " ${typ}-Dateien wurden bereinigt !!" $tGelb
	return $rc
}

#
# Dateinamen fuer IMG zusammen setzen
## ============================================================
LSB_REL=`lsb_release -a | grep Codename:`
CODE_NAM=${LSB_REL##*:}      										# remove part before last :
CODE_NAME=`echo ${CODE_NAM%.*}`  									# remove part after *
KRNL_REL=`uname -r`													# Kernel Version
KRNL_VERS=`echo ${KRNL_REL%-*}`										# remove part after last -
BACKUP_NAME="hbridge_"${CODE_NAME}"_"${KRNL_VERS}
## ============================================================
PID_HB=`pidof homebridge`
if [ -n "$PID_HB" ]; then
  StopHB_Serv="1"
else
  StopHB_Serv="0"
fi

# -- auf Tools-Ordner prüfen --
[ ! -e "${toolDir}/${MYSELF}" ] && ( msg "\n ABBRUCH!$tFGreen\n Es existiert kein Tool-Ordner $tFGelb\"${toolDir}/\"$tFGreen\n bitte die Tools neu installieren!\n" $tFRot) && exit 11

if [ -f $HOME/hbridge_install/${MYSELF} ]; then
  [ ! -h /usr/bin/${MYSELF} ] && sudo ln -s $HOME/hbridge_install/${MYSELF} /usr/bin/${MYSELF} && msg "System-Link zu $HOME/hbridge_install/${MYSELF} wurde erstellt."
fi

## ============================================================
######################################
#########    Mainprogramm     ########
######################################
## ============================================================
clear
msg " Es wird das Script: ${MYSELF} in der Version: ${Version} benutzt !! " "\n\033[4;36m"
msg " (ohne Eingabe wird (grün) nach 10sec autom. übernommen)" "\t\033[0;32m"

# -- selftest, ob Script schon läuft --
#echo läuft als  $$
#[ "$(pidof -x "$0")" != $$ ] && (msg "$tFRot ABBRUCH! $0$tFGelb läuft bereits, \n$tFGreen Bitte erst beenden !\n") && exit 222
[ "$(pidof -x "$0")" != $$ ] && (msg "$tFRot ACHTUNG! $tNormal$0$tFGelb läuft bereits!\n") 

# -- test auf cfg Datei --
if [ -f ${toolDir}/${configFile} ]; then								# prüfen ob cfg-Datei vorhanden ist!
  . ${toolDir}/${configFile} 
else
  set_Config
fi

#if [ -f $toolDir/$helpFile ]; then . $toolDir/$helpFile; fi
if [ -n "${Logfile}" ]; then msg " (logge in: \"${Logfile}\" mit)" "\t\t\033[0;33m"; fi
[ -z ${gzImage+x} ] && gzImage="0" 									# wenn Variable nicht existiert -> setzen
[ -z ${Date_Format+x} ] && Date_Format="%d%m%Y" 					# wenn Variable nicht existiert -> setzen 
if [[ ${Date_Format} =~ ^[mM](onat)* ]]; then						# fängt mit [mM]onat an -> Monat
 Date_Format="%m%d%Y"
elif [[ ${Date_Format} =~ ^[jJ](ahr)* ]]; then						# fängt mit [jJ]ahr an ->  Jahr
 Date_Format="%Y%m%d"
else																# rest Tag
 Date_Format="%d%m%Y"
fi
#[[ ${Date_Format} =~ ^[jJyY]$ ]] && Date_Format="%Y%m%d" || Date_Format="%d%m%Y" # fängt mit [jJyY] an -> Jahr/Monat/Tag sonst Tag/Maonat/Jahr setzen
formatDate=$(date +${Date_Format})									# internes Datumsformat 

# auf Distribution prüfen
[ "${Distri}" == "no" ] && flag=1
if [ "${Distri}" == "" ] || [ "${Distri}" != "Debian" -a "${Distri}" != "Raspbian" ]; then
  Distri=`lsb_release -s -i`
  if [ "${Distri}" != "Raspbian" -a "${Distri}" != "Debian" ]; then
    msg "Distributor = ${Distri} !" $tFGelb
    if [ "${flag}" != "1" ]; then
      msg "\n Abbruch: Dieses System wird derzeit nicht supportet, nur Raspbian und Debian!!\n" $tFRot
      msg " (evtl. \"Distri\" manuell setzen)" $tNormal
      exit 8
    fi
  fi
fi

if [ "${Backup_Device}" = "" ]; then
# auf USB-Device, Boot-Device prüfen
  if [ "${Distri}" == "Raspbian" ]; then
    if [ "$Boot_Device" = "" ]; then
      Boot_Device="mmcblk0"
    fi
    if [ "${USB_Device}" = "" ]; then
      if [ -e /dev/sda1 ]; then
        USB_Device="sda1"
      elif [ -e /dev/sdb1 ]; then
        USB_Device="sdb1"
      else
        msg "\033[1;33m\n\t Kein sda oder sdb Device gefunden!\033[0m"
        msg "\033[1;31m\t Bitte ein USB-Backupmedium anstecken!\033[0m\n"
        msg "Kein sda oder sdb Device gefunden!" >&2
        exit 254
      fi
    fi
    Backup_Device="/dev/${USB_Device}"
  fi
fi
    
if [ "${Backup_Device}" = "" -o "${Boot_Device}" = "" ]; then
  msg "\nEs ist kein Sicherungs-Device bzw. Boot-Device eingetragen!" $tFGreen
  msg "Bitte \"Backup_Device\" oder \"Backup_Pfad\" und \"Boot_Device\" eintragen, dann erneut starten." $tFGelb
  list_Device
  exit 6
fi

## ============================================================

[ "${Backup_Pfad}" = "" ] && Backup_Pfad="/mnt/${USB_Device}"
# USB_Label=`lsblk -n -o label ${Backup_Device}`
[ "${USB_Device}" != "" ] && USB_Label=`lsblk -n -o label /dev/${USB_Device}`

#is_Debug=1
[ "${is_Debug}" -eq 1 ] && [ -f $toolDir/${dbgFile} ] && . ${toolDir}/${dbgFile} ${is_Debug} raspiBackup

# Test of $1 max. 3 Parameter
## ============================================================
while [ $# -gt 0 ]; do												# solange die Anzahl der Parameter ($#) größer 0 ist
  if [ "${1}" == "del" ] || [ "$1" == "-d" ]; then
#	[ $# -eq 2 ] && clean_file_typ $2 && exit 1
    msg "  Es werden alle Sicherungsdateien auf dem Backupmedium gelöscht!!\n" "\t\033[1;31m"
	read -t 10 -p "Jetzt alle löschen (j/y/N)?" dummy
	if [[ ${dummy} =~ ^[jJYy]$ ]]; then
      Del_Img="2"
	fi
  elif [ "${1}" == "cmd" ] || [ "${1}" == "-b" ] || [ "${1}" == "-cmd" ]; then
    Run_Batch="1"
  elif [ "${1}" == "-nz" ] || [ "${1}" == "noZip" ]; then
     gzImage="0"
  elif [ "${1}" == "nodel" ] || [ "${1}" == "-nd" ]; then
    msg "  Es wird nichts vom Backupmedium gelöscht!!\n" "\t\t\033[0;33m"
    Del_Img="0"
  elif [ "${1}" == "log" ] || [ "${1}" == "-lg" ]; then 
    Backup_Log="1"
  elif [ "${1}" == "notiz" ] || [ "${1}" == "-n" ]; then
    Backup_txt="1"
  elif [ "${1}" == "comment" ] || [ "${1}" == "-c" ]; then
    Backup_txt="1"
  elif [ "${1}" == "debug" ] || [ "${1}" == "-db" ]; then
    if [ -f $toolDir/$dbgFile ]; then
      if [ "${2}" == "cfg" ] || [ "${1}" == "-cfg" ]; then
        . $toolDir/$dbgFile 1 cfg
      else
        . $toolDir/$dbgFile 1 raspiBackup
      fi
    else
      msg "\n\tKonnte keine \"$toolDir/$dbgFile\" Datei finden!\n" $tFRot
    fi
    exit 9
  elif [ "${1}" == "free" ] || [ "${1}" == "list" ] || [ "${1}" == "-l" ]; then
    mount_BackupMedium off
    list_typ_dir img ${Backup_Pfad} 0
    list_typ_dir gz ${Backup_Pfad} 0
    list_typ_dir zip ${Backup_Pfad} 0
    list_typ_dir log ${Backup_Pfad} 1
    list_typ_dir txt ${Backup_Pfad} 1
    msg " Achte auf die Zeile, die mit /dev/sd.. beginnt." "\n\033[0;33m"
    sudo df -h | grep -E 'Dateisystem|sd[abcd]'
    umount_BackupMedium
    exit 2
  elif [ "${1}" == "shrink" ] || [ "${1}" == "-s" ]; then
    Shrink_Image=1
    if [ "${Skip_Autoexpand}" != "true" ] && [ "${Skip_Autoexpand}" != "false" ]; then
      msg "\n Filesystem nach der Wiederherstellung autom. erweitern? \033[0;32m[j/n](n)" $tFGelb
      read -n1 -t 10 a
      if [ "${a}" == "n" ] || [ "${a}" == "" ]; then
      	msg "Das Filesystem wird nach der Wiederherstellung$tFRot NICHT$tFGreen autom. erweitert.\n" $tFGreen
        Skip_Autoexpand="true"
      else
        msg "Das Filesystem wird nach der Wiederherstellung autom. erweitert.\n" $tFGreen
        Skip_Autoexpand="false"
      fi
    fi
  elif [ "${1}" == "img" ] || [ "${1}" == "-img" ]; then
    image "${2}"
	exit 15    
  elif [ "${1}" == "mount" ] || [ "${1}" == "-mount" ]; then
    mount_BackupMedium
    exit 4
  elif [ "${1}" == "umount" ] || [ "${1}" == "-umount" ]; then
    umount_BackupMedium
    exit 5
  elif [ "${1}" == "unpack" ] || [ "${1}" == "-unpack" ]; then
    unpack
    exit 0
  elif [ "${1}" == "listdev" ] || [ "${1}" == "-listdev" ]; then
    list_Device
    exit 6
  elif [ "${1}" == "format" ] || [ "${1}" == "-format" ]; then
    format_Stick /dev/${USB_Device}
    exit $rc
  elif [ "${1}" == "help" ] || [ "${1}" == "?" ] || [ "${1}" == "-h" ] || [ "${1}" = "-?" ]; then
	msg " (Die Homebridge läuft auf einem: $Distri-System)" "\t\033[0;33m"
    if [ -f ${toolDir}/${configFile} ]; then msg " (Die Datei: \"${configFile}\" wurde gefunden und eingelesen)" "\t\033[0;33m"; fi
	if [ "${SendTelegram}" = "1" ]; then msg " (Benachrichtigung per \"Telegram\" erlaubt)" "\t\033[0;33m"; fi
	msg "\n  Mit diesem Script wird das kompl. Device: ${Boot_Device} auf das Medium: ${Backup_Device} gesichert!\n" "\033[1;37m"
	msg "Benutze: \033[1;37m${0} [-nd (nodel)|-d (del)|-s (shrink)|-b (cmd)|-c -n (comment(notiz))|-lg (log)|mount|umount|-nz|\n\t\t\t\t img mount/umount|listdev|format|-l (list(free))|-db (debug)|-d (debug) cfg|help(?/-?)]"
	msg "(Parameter in dieser Farbe beenden das Tool ohne eine Sicherung)" "\033[1;35m\t"
#	msg "${hlp_bk_nodel}"
	msg "mögliche Parameter sind:" "\n$tFGelb"
	msg "\033[1;37m nodel (-nd)\033[0m\t-keine Sicherung vom Backupmedium löschen"
	msg "\033[1;37m del (-d)\033[0m\t-löschen aller Sicherungen vom Backupmedium"
	msg "\t\033[0m\t ohne \"\033[1;37mdel\033[0m\" oder \"\033[1;37mnodel\033[0m\" - die letzten $(($Backup_Anzahl-1)), +1 Sicherung bleiben auf dem Backupmedium"
	msg "\033[1;37m shrink (-s)\033[0m\t -Image nach dem erstellen schrumpfen (verkleinern), benötigt den doppelten Platz\n\t\t auf dem Backupmedium und die Datei \"pishrink.sh\""
	msg " \t\t (mit Abfrage ob die org. Partitiongrösse wiederhergestellt werden soll)\n\t\t (aktuell kein Support für NOOBS-Image)"
	msg "\033[1;37m cmd (-b)\033[0m\t-Batch-Modus (homebridge* Dienste werden \033[1;31mNICHT\033[0m beendet)"
	msg "\t\t   z.B.: zum starten aus dem cmdtrigger-Plugin in der config.json mit:"
	msg "\t\t  \"command\": \"${toolDir}/${MYSELF} cmd\""
	msg " comment(notiz) (-c -n)\033[0m - nach der Sicherung wird eine gleichnamige Kommentar-Datei.txt angelegt\n\t\t Anzahl der Zeilen kann eingestellt werden (Bestätigung mit Enter notwendig!)" "\033[1;37m"
	msg " log (-lg)\033[0m\t- es wird zum Backup eine gleichnahmiges mini Log angelegt" "\033[1;37m"
	msg " mount\033[0m\t\t-  bindet das Backupmedium ins Filesystem ein" "\033[1;35m"
	msg " umount\033[0m\t\t-  entfernt das Backupmedium aus dem Filesystem" "\033[1;35m"
	msg " unpack\033[0m\t\t-  entpackt ein komprimiertes Image (*.img.zip/*.img.gz -> *.img)" "\033[1;35m"
	msg " img mount\033[0m\t- ein Backup-Image unter \"/mnt/image\" mounten, dadurch hat man Dateizugriff auf den Inhalt" "\033[1;35m"
	msg " img umount\033[0m\t- ein geladenes Backup-Image unter \"/mnt/image\" wieder entladen" "\033[1;35m"
	msg " listdev\033[0m\t- anzeigen der akt. Devices zum ermitteln des Sicherungs-Device und Boot-Device" "\033[1;35m"
	msg " format\033[0m\t\t-  USB-Device Partition löschen, anlegen, formatieren (nur exFAT) und beNamen" "\033[1;35m"
	msg " list  (-l)\033[0m\t-  zeigt die Image's, Log-, Txt- Dateien und den freien Speicherplatz auf dem Backupmedium an" "\033[1;35m"
	msg " free\033[0m\t\t-  siehe list" "\033[1;35m"
	msg " noZip (-nz)\033[0m\t-  Image nicht packen, trotz$tGelb gzImage=\"zip/gz\"\033[0m in der cfg-Datei" "\033[1;35m"
#	msg " debug hbridge$tNormal - anzeige von Debug Info's für die Datei: $tGelb\"hbridge_new.sh\"" "\033[1;35m"
	msg " debug (-db)\033[0m\t- anzeige von Debug Info's für die Datei: $tGelb\"${MYSELF}\"" "\033[1;35m"
	msg " debug (-db) cfg$tNormal - anzeige der Datei: $tGelb\"${toolDir}/${configFile}\"" "\033[1;35m"
	msg " help  (-h)\033[0m\t-  diese Hilfe" "\033[1;35m"
	msg " ?\033[0m\t\t-  siehe help\n" "\033[1;35m"
	msg "\033[1;33mmögliche Kurzbefehle für Parameter/Optionen:\t$tGelb\"${MYSELF} Parameter Option\""
	msg "$tNormal Parameter\t Option"
	msg "\033[0;35m-d = del\t -nd = nodel"
	msg "\033[0;35m-l = list\t -db = debug"	  
	msg "\033[0;35m-b = cmd\t  -nz = noZip"
	msg "\033[0;35m-s = shrink\t -cfg = cfg"
	msg "\033[0;35m-n = notiz\t -lg = log"	  
	msg "\033[0;35m-c = comment"
	msg "\033[0;35m-h(?) = Hilfe\n"
	read -t 25 -p "weiter mit Enter..."
	msg "\nHinweis zu Variablen:" "$tFGelb"
	msg " (in der Datei: ${toolDir}/$configFile)\n" "\033[0m"
	msg "\033[1;37m  image_Name=\033[0m\t\t festlegen des Dateinamen für die Sicherungsdatei (Datum wird autom. angefügt)" "\033[0m"
	msg "\033[1;37m  Date_Format=\"Jahr\"\033[0m\t Datumsformat \"Tag\"=09122019, \"Jahr\"=20191209, \"Monat\"=12092019"
	msg "\033[1;37m  Date_SicName="1"\033[0m\t\t 0= Name, 1= Name_Datum, 2= Datum_Name, Format des Namen der Sicherungsdatei" "\033[0m"
	msg "\033[1;37m  gzImage=\"0\"\033[0m\t\t zip/gz= komprimiertes Image erstellen (*.img -> *.img.zip/*.img.gz)" "\033[0m"
	msg "\033[1;37m  Backup_Anzahl=\"3\"\033[0m\t  Anzahl der Backup's auf dem Backupmedium, 2 alte Backups bleiben erhalten +1(aktuelle Sicherung)" "\033[0m"
	msg "\033[1;37m  DispSicTime=\"1\"\033[0m\t ein/aus Anzeige der Uhrzeit vor und nach der Sicherung/Shrinking" "\033[0m"
	msg "\033[1;37m  SendTelegram=\"0\"\033[0m\t Benachrichtigung via \"Telegram\" vom User \"pi\" senden" "\033[0m"
	msg "\033[1;37m  TToken_raspiBackup= \033[0m\t  den Telegram-API Token eintragen" "\033[0m"
	msg "\033[1;37m  TChat_ID_raspiBackup=\033[0m\t die Telegram Chat-ID für den \"bot Chat\" eintragen" "\033[0m"
	msg "\033[1;37m  TelegramAnhang= \033[0m\t eine Datei die per Telegram gesendet werden soll" "\033[0m"
	msg "\033[1;37m  TelegramPhoto=\033[0m\t\t ein Bild das per Telegram gesendet werden soll" "\033[0m"
	msg "\033[1;37m  Logfile=\"\" \033[0m\t\t aktiviert das loggen in eine Datei (verzögert die Anzeige etwas) bzw. \"journal\" in syslog" "\033[0m"
	msg "\033[1;37m  Del_Img=\"1\" \033[0m\t\t 0=nichts löschen \"\033[1;37mnodel\033[0m\", 1=max. ${Backup_Anzahl}-1 Backips bleiben auf dem Backupmedium, 2=alle Backups löschen \"\033[1;37mdel\033[0m\"" "\033[0m"
	msg "\033[1;37m  Run_Batch=\"0\" \033[0m\t\t 1= Batch-Modus an, 0= Batch-Modus aus, siehe \"cmd\"" "\033[0m"
	msg "\033[1;37m  Backup_Device=\"\" $tNormal\t =  hier das Sicherungs-Device eintragen (\"\dev\sda1\", \"\dev\sdc1\" oder \"192.168.6.68:/volume1\")" "\033[0m"
	msg "\033[1;37m  Backup_Pfad=\"\" $tNormal\t = Backup Ziel ("" = /mnt/USB_Device) oder \"${toolDir}\" eintragen" "\033[0m"
	msg "\033[1;37m  Boot_Device=\"\"$tNormal\t\t hier das Boot-Device eintragen (ohne Ziffer, \"sda\", \"sdb\")" "\033[0m"
	msg "\033[1;37m  Distri=\"\"$tNormal\t\t das aktuelle System festlegen, \"Raspian\" für Raspberry oder \"Debian\" für x86 System" "\033[0m"
	msg "\033[1;37m  Backup_txt=\"0\"\033[0m\t\t 1= eine Kommentar txt-Datei zum Backup anlegen (Bestätigung mit Enter notwendig!)" "\033[0m"
	msg "\033[1;37m  KommentarZeilen=\"5\"\033[0m\t Anzahl der Zeilen für den Kommentar in der txt-Datei" "\033[0m"
    msg "\033[1;37m  Backup_Log=\"0\"\t\t 1= eine (mini) LOG-Datei zur Sicherung anlegen" "\033[0m"
    msg "\033[1;37m  Restart_Services=\"\"\t welche Services beendet/gestartet/restartet werden (=\"reporter deconz homebridge\")\n" "\033[0m"
	msg "\n$tFGelb mögl. Beispiele: " $tNormal
	msg " \"${MYSELF} del cmd notiz (-d -b -n)\""
	msg " - löscht die Sicherungsdateien, beendet die \"homebridge\" \033[1;31mNICHT\033[0;33m und startet die Sicherung\n\t und fragt danach die Daten für eine Kommentar-Datei ab" "\033[0;33m"
	msg " \"${MYSELF} del (-d)\""
	msg " - löscht alle Sicherungsdateien, beendet/startet \"homebridge\" " "\033[0;33m"
	msg " \"${MYSELF} nodel (-nd)\""
	msg " - löscht keine Sicherungsdateien, beendet \"homebridge\" und startet die Sicherung" "\033[0;33m"
	msg " \"${MYSELF} cmd (-b)\""
	msg " - beendet die \"homebridge\" \033[1;31mNICHT\033[0;33m und startet die Sicherung\n  (es verbleiben ${Backup_Anzahl} Sicherung auf dem Backupmedium)" "\033[0;33m"
	msg " \"${MYSELF}\""
	msg " - beendet die \"homebridge\" startet die Sicherung, startet die \"homebridge\" wieder\n  (es verbleiben ${Backup_Anzahl} Sicherung auf dem Backupmedium)\033[0m\n" "\033[0;33m"
	msg "   (zur Wiederherstellung benutze \"Win32DiskImager\", \"Etcher\" bzw. \"PiBaker\")\n"
	exit 1
  fi
  shift																# Parameter verschieben $2->$1, $3->$2, $4->$3,..
done

[ "${Run_Batch}" = "1" ] && msg "Es wird in den Batch-Modus geschalten, \"homebridge\"-Dienste werden nicht beendet!\n" $tFRot
[ "${Del_Img}" = "1" ] &&  msg "   (max. verbleiben $(($Backup_Anzahl)) Backups auf dem Backupmedium)" "\t\t\033[0;33m"
[ "${Backup_Log}" = "1" ] && msg " ( Es wird eine log Datei zum Backup erstellt !!)" "\t\t\033[0;33m"
echo -e ""

mount_BackupMedium off

#[ -z ${gzImage+x} ] && gzImage="0" 								# wenn Variable nicht existiert -> setzen
[ "${gzImage}" != "0" ] && msg " Nach der Sicherung wird das Image zur ${gzImage}-Datei komprimiert!\033[0m" $tGreen
[ "${Shrink_Image}" == "1" ] && msg " Nach der Sicherung wird das Image ge-Shrinkt!\033[0m" $tGreen

if [ "${image_Name}" = "" ]; then
  msg " Bitte den Namen für die Backup-Datei eingeben:" $tFGelb
  msg " ${BACKUP_NAME}\033[0m_${formatDate}.img (Datum wird automatisch eingefügt)" "\033[0;32m"
  read -t 25 image_Name
fi
[ "${image_Name}" = "" ] && image_Name=${BACKUP_NAME}
[ ${Date_SicName} = "2" ] && image_name="${formatDate}_${image_Name}" 
[ ${Date_SicName} = "1" ] && image_name="${image_Name}_${formatDate}"
msg "\n Es wird der Dateiname benutzt: \033[0m${image_name}.img\n" $tFGelb

# Stoppe services
#if [ "${Run_Batch}" != "1" -o "${StopHB_Serv}" == "1" ]; then
if [ "${Run_Batch}" != "1" ]; then
  msg " Für die Dauer des Backup werden die \"homebridge\"-Dienste gestoppt!" $tFGelb
  HB_Services stop
else
  msg " Batchmodus aktiv, die \"homebridge\"-Dienste werden nicht verändert!" $tFGelb
fi

#if ls ${Backup_Pfad}/*.img 1> /dev/null 2>&1; then
if [ -e ${Backup_Pfad} ]; then
  if [ "${Del_Img}" = "2" ]; then
    sudo rm -rf ${Backup_Pfad}/*.img > /dev/null
    [ "${gzImage}" != "0" ] && sudo rm -rf ${Backup_Pfad}/*.${gzImage} > /dev/null   
    sudo rm -rf ${Backup_Pfad}/*.log > /dev/null
    sudo rm -rf ${Backup_Pfad}/*.txt > /dev/null
    msg " Alle img/gz/log Dateien wurden auf den Backupmedium gelöscht !!" $tFGelb
  elif [ "${Del_Img}" = "1" ]; then
    ## Backuphistorie bereinigen (Anzahl = Anzahl Historie+1) 
	clean_file_typ img												# img Dateien auf Backupmedium bereinigen
#	RC=$?
# 	[ ${RC} != 0 ] && msg "Error!" $tRot
	[ "${gzImage}" != "0" ] && clean_file_typ ${gzImage}
	clean_file_typ log
	clean_file_typ txt
  else
    msg " Es wurden keine *.img/*.gz/*.zip/*.log/*.txt Dateien auf dem Backupmedium gelöscht !!" $tFGelb
  fi
else
  msg " Es existiert kein Sicherungsort: \"${Backup_Pfad}\" !!" $tFGelb
fi

msg " Erstelle die Backupdatei: \033[0m${image_name}.img\n$tFGelb im Ordner: \033[0m${Backup_Pfad}/\n$tFGelb vom Device: \033[0m/dev/${Boot_Device}" "\n$tFGelb"
msg "\033[0m (das wird etwas dauern... ⏳)"
msg "Das Backupmedium jetzt nicht entfernen!!\n" "\n$tFRot\t"

# SicFile exist -> rename
for ext in ${ext_Array[@]}; do										# Array mit benutzten Dateierweiterungen
  if [ -e ${Backup_Pfad}/${image_name}.${ext} ]; then
    i="2"
    while [ $i -lt ${maxSicTag} ]; do
      [ -e "${Backup_Pfad}/${image_name}-${i}.${ext}" ] || break && i=`expr $i + 1`
	done
    msg "Die Datei: \033[0m${image_name}.${ext} "$tFGelb"existiert bereits und wird \n umbenannt in: \033[0m${Backup_Pfad}/${image_name}-${i}.${ext}" $tFGelb
	[ ${i} = ${maxSicTag} ] && rm -fr ${Backup_Pfad}/${image_name}-${i}.${ext} && msg "maximale Sicherung pro Tag erreicht!" $tFRot
#	 rm -fr ${Backup_Pfad}/${image_name}-*.${ext}
    sudo mv -f ${Backup_Pfad}/${image_name}.${ext} ${Backup_Pfad}/${image_name}-${i}.${ext}
  fi
  if [ "${gzImage}" != "0" ]; then									# nur wenn zip/gz
    if [ -e ${Backup_Pfad}/${image_name}.${ext}.${gzImage} ]; then	# *.${ext}.zip/gz -> *-2.${ext}.zip/gz
      i="2"
      while [ $i -lt ${maxSicTag} ]; do
        [ -e "${Backup_Pfad}/${image_name}-${i}.${ext}.${gzImage}" ]  || break && i=`expr $i + 1`
	  done
      msg "Die Datei: \033[0m${image_name}.${ext}.${gzImage} "$tFGelb"existiert bereits und wird \n umbenannt in: \033[0m${Backup_Pfad}/${image_name}-${i}.${ext}.${gzImage}" $tFGelb
	  [ ${i} = ${maxSicTag} ] && rm -fr ${Backup_Pfad}/${image_name}-${i}.${ext}.${gzImage} && msg "maximale Sicherung pro Tag erreicht!" $tFRot
      sudo mv -f ${Backup_Pfad}/${image_name}.${ext}.${gzImage} ${Backup_Pfad}/${image_name}-${i}.${ext}.${gzImage}
    fi
  fi
done

dat=`date +%T`
dat_run=`date +%s`
[ "${Backup_Log}" = "1" ] && backup_log " Sicherung vom: $(date +%d.%m.%Y)\n"
[ "${Backup_Log}" = "1" ] && backup_log " Sicherungsdatei: ${image_name}.img\n Sicherung vom Device: /dev/${Boot_Device}"

if [ "${DispSicTime}" = "1" ]; then msg " Sicherung gestartet:\033[0m $dat" "\n\033[0;32m"; fi
[ "${Backup_Log}" = "1" ] && backup_log " Sicherung gestartet: $dat"
if [ "${SendTelegram}" = "1" ]; then send_Telegram "Sicherung ${image_name}.img gestartet um $dat" ; fi

#if [ "${gzImage}" != "gz" ]; then
  # Backup mit dd erstellen
  #!!sudo dd if=/dev/${Boot_Device} of=${Backup_Pfad}/${image_name}.img bs=1MB 2>&1
  dummy=$(sudo dd if=/dev/${Boot_Device} of=${Backup_Pfad}/${image_name}.img bs=1MB 2>&1)
#elif [ "${gzImage}" = "gz" ]; then
#  dummy=$(sudo dd if=/dev/${Boot_Device} bs=1M | gzip -c > ${Backup_Pfad}/${image_name}.img.gz 2>&1)			# -k = *.img ni. löschen
#fi

# BS ausgabe erstellen 
out=${dummy%%i*} 
msg "$out \bin"
out=${dummy#*n}				#löscht von li bis zum 1ten n
out=${out#*n}
out=${out%s*}				#löscht von re bis zum 1ten s 
out=${out%s*} 
out=${out%s*}  
out=${out%s*} 
msg "$out \bs"
sum=${dummy##*u} 			#löscht von li bis zum letztem u
sum=${sum#*s} 
speed=${sum#*s} 
speed=${speed#*s} 
speed=${speed#*,} 
sum=${sum%t*} 
msg "${sum}t mit $speed"
dat=`date +%T`
dat_diff=$(( ($(date +%s) - $dat_run) / 60 ))						# = Sicherungsdauer

if [ "${DispSicTime}" = "1" ]; then msg " Sicherung beendet..:\033[0m $dat\n\033[0;32m Sicherungsdauer....:\033[0m ${dat_diff} min\n" "\033[0;32m"; fi
[ "${Backup_Log}" = "1" ] && backup_log " Sicherung beendet..: ${dat}"
[ "${Backup_Log}" = "1" ] && backup_log " Sicherungsdauer....: ${dat_diff} Minuten"
[ "${Backup_Log}" = "1" ] && backup_log " gesichert wurden...: ${sum}t"
if [ "${SendTelegram}" = "1" ]; then send_Telegram "Sicherung von ${image_name}.img beendet um ${dat}, die Sicherung hat ${dat_diff} min gedauert.%0A Es wurden, ${sum}t mit ${speed}."; fi

# Starte services
#if [ "${Run_Batch}" != "1" -o ${StopHB_Serv} == "1" ]; then
if [ "${Run_Batch}" != "1" ]; then
  msg "Die \"homebridge\"-Dienste werden wieder gestartet!\n" $tFGelb
  HB_Services start
else
  msg " Batchmodus aktiv, die \"homebridge\"-Dienste werden nicht verändert!\n" $tFGelb
fi

if [ "${Shrink_Image}" = "1" ]; then
  shrink_Image ${Backup_Pfad}/${image_name}
fi
if [ "${Backup_txt}" = "1" ]; then
  txtFile_Backup
  msg "Backup Kommentar-Datei wurde erstellt!\033[0m"
fi

# Komprimierung img, txt und log
if [ "${gzImage}" != "0" ]; then
  [ ! -e /usr/bin/zip ] && sudo apt-get install -y zip unzip &> /dev/null && msg "Die Pakete zip und unzip wurden installiert." $tFGelb
  [ ! -e /bin/gzip ] && sudo apt-get install -y gzip gunzip  &> /dev/null && msg "Die Pakete gzip und gunzip wurden installiert." $tFGelb
  dat_run=`date +%s`
  dat=`date +%T`
  msg "\033[0m (jetzt viel Geduld und lange warten... ⏳)\n"
  if [ "${DispSicTime}" = "1" ]; then msg " Komprimieren von\033[0m ${Backup_Pfad}/${image_name}.img\033[0;32m gestartet:\033[0m $dat" "\033[0;32m"; fi
  [ "${Backup_Log}" = "1" ] && backup_log " Komprimierung gestartet: ${dat}"
  [ "${SendTelegram}" = "1" ] && send_Telegram "Komprimierung von ${image_name}.img gestartet: ${dat}"
  cd ${Backup_Pfad}
  if [ "${gzImage}" = "gz" ]; then
    sudo gzip -f9 "${Backup_Pfad}/${image_name}.img" &> /dev/null												# *.img löschen (-k ni. löschen)
    sudo gzip -f9 "${Backup_Pfad}/${image_name}.txt" &> /dev/null								# *.txt löschen (-k ni. löschen)
    dummy_txt=" \"gunzip -c ${Backup_Pfad}/${image_name}.img.gz > ${Backup_Pfad}/${image_name}.img\" "
  elif [ "${gzImage}" = "zip" ]; then
    sudo zip -m ./${image_name}.img.zip ./${image_name}.img &> /dev/null 						# -m = *.img löschen
    sudo zip -m ./${image_name}.txt.zip ./${image_name}.txt &> /dev/null 						# -m = *.txt löschen
    dummy_txt=" \"unzip ${Backup_Pfad}/${image_name}.img.zip\" "
  else
    msg "Die Variable$tNormal gzImage=\"${gzImage}\"$tFGreen ist falsch gesetzt!\n$tFGelb (unterstützt wird: \"0\"=disable, \"zip\" und \"gz\")$tFRot\n\nDas komprimieren von:$tNormal \"${Backup_Pfad}/${image_name}.img\"$tFRot wurde abgebrochen!!\n" $tFGreen
  fi
  dat=`date +%T`
  dat_diff=$(( ($(date +%s) - $dat_run) / 60 ))						# = Komprimierungsdauer
  [ "${DispSicTime}" = "1" ] && msg " Komprimieren von\033[0m ${Backup_Pfad}/${image_name}.img\033[0;32m wurde beendet:\033[0m $dat" "\033[0;32m"
  [ "${DispSicTime}" = "1" ] && [ "${gzImage}" = "zip" ] && msg " Entpacken mit...:\033[0m \"unzip ${Backup_Pfad}/${image_name}.img.zip\"\n" $tGreen
  [ "${DispSicTime}" = "1" ] && [ "${gzImage}" = "gz" ] && msg " Entpacken mit...:\033[0m \"gunzip -c ${Backup_Pfad}/${image_name}.img.gz  > ${Backup_Pfad}/${image_name}.img\"\n" $tGreen
  [ "${Backup_Log}" = "1" ] && backup_log " Komprimierung beendet..: ${dat}\n Komprimierungsdauer....: ${dat_diff} Minuten\n\n Entpacken mit:\n ${dummy_txt}"
#  [ "${Backup_Log}" = "1" ] && backup_log " Komprimierungsdauer....: ${dat_diff} Minuten\n\n Entpacken mit:\n ${dummy_txt}"
  # .log zuletzt Komprimieren !!
  [ "${gzImage}" = "gz" ] && sudo gzip -f9 "${Backup_Pfad}/${image_name}.log" &> /dev/null  	# *.log löschen (-k ni. löschen)
  [ "${gzImage}" = "zip" ] && sudo zip -m ./${image_name}.log.zip ./${image_name}.log &> /dev/null 		# -m = *.log löschen
  if [ "${SendTelegram}" = "1" ]; then send_Telegram "Komprimierung von ${image_name}.img in ${image_name}.img.${gzImage}%0A beendet um ${dat}, sie hat ${dat_diff} min gedauert."; fi
  cd ${toolDir}
fi

umount_BackupMedium
msg "Hinnweis:\033[0m\nFür die Wiederherstellung, benutze: \"Win32DiskImager\" bzw. \"PiBaker\"!/n" $tFGelb

# Backup manuell entpacken/restore:
# gunzip -c /mnt/sd??/image.img.gz > /mnt/sd??/image.img
# unzip /mnt/sd??/image.img.zip 
# sudo dd if=/mnt/sd??/MeinBackup.img of=/dev/mmcblk? bs=1MB
# gzip -dc /mnt/sd??/image.img.gz | sudo dd bs=4M of=/dev/mmcblk?

cd $HOME
exit 0
 